/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.collisions.datatypes;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.utils.collisions.datatypes.BoundingBox;
import ac.grim.grimac.utils.collisions.datatypes.CollisionBox;
import ac.grim.grimac.utils.nmsutil.Ray;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class SimpleCollisionBox
implements CollisionBox {
    public static final double COLLISION_EPSILON = 1.0E-7;
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;
    boolean isFullBlock = false;

    public SimpleCollisionBox() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, false);
    }

    public SimpleCollisionBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, boolean fullBlock) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.minZ = minZ;
        this.maxZ = maxZ;
        this.isFullBlock = fullBlock;
    }

    public SimpleCollisionBox(Vector min, Vector max) {
        this(min.getX(), min.getY(), min.getZ(), max.getX(), max.getY(), max.getZ());
    }

    public SimpleCollisionBox(Vector3i pos) {
        this(pos.getX(), pos.getY(), pos.getZ(), pos.getX() + 1, pos.getY() + 1, pos.getZ() + 1);
    }

    public SimpleCollisionBox(double minX, double minY, double minZ) {
        this(minX, minY, minZ, minX + 1.0, minY + 1.0, minZ + 1.0, true);
    }

    public SimpleCollisionBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.minZ = minZ;
        this.maxZ = maxZ;
        if (minX == 0.0 && minY == 0.0 && minZ == 0.0 && maxX == 1.0 && maxY == 1.0 && maxZ == 1.0) {
            this.isFullBlock = true;
        }
    }

    public SimpleCollisionBox(Vector3d min, Vector3d max) {
        this(min.getX(), min.getY(), min.getZ(), max.getX(), max.getY(), max.getZ());
    }

    public SimpleCollisionBox(Location loc, double width, double height) {
        this(loc.toVector(), width, height);
    }

    public SimpleCollisionBox(Vector vec, double width, double height) {
        this(vec.getX(), vec.getY(), vec.getZ(), vec.getX(), vec.getY(), vec.getZ());
        this.expand(width / 2.0, 0.0, width / 2.0);
        this.maxY += height;
    }

    public SimpleCollisionBox(BoundingBox box) {
        this(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
    }

    public SimpleCollisionBox expand(double x, double y, double z) {
        this.minX -= x;
        this.minY -= y;
        this.minZ -= z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        return this.sort();
    }

    public SimpleCollisionBox sort() {
        double minX = Math.min(this.minX, this.maxX);
        double minY = Math.min(this.minY, this.maxY);
        double minZ = Math.min(this.minZ, this.maxZ);
        double maxX = Math.max(this.minX, this.maxX);
        double maxY = Math.max(this.minY, this.maxY);
        double maxZ = Math.max(this.minZ, this.maxZ);
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        return this;
    }

    public SimpleCollisionBox expandMin(double x, double y, double z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        return this;
    }

    public SimpleCollisionBox expandMax(double x, double y, double z) {
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        return this;
    }

    public SimpleCollisionBox expand(double value) {
        this.minX -= value;
        this.minY -= value;
        this.minZ -= value;
        this.maxX += value;
        this.maxY += value;
        this.maxZ += value;
        return this;
    }

    public Vector[] corners() {
        Vector[] vectors = new Vector[]{new Vector(this.minX, this.minY, this.minZ), new Vector(this.minX, this.minY, this.maxZ), new Vector(this.maxX, this.minY, this.minZ), new Vector(this.maxX, this.minY, this.maxZ), new Vector(this.minX, this.maxY, this.minZ), new Vector(this.minX, this.maxY, this.maxZ), new Vector(this.maxX, this.maxY, this.minZ), new Vector(this.maxX, this.maxY, this.maxZ)};
        return vectors;
    }

    public SimpleCollisionBox expandToAbsoluteCoordinates(double x, double y, double z) {
        return this.expandToCoordinate(x - (this.minX + this.maxX) / 2.0, y - (this.minY + this.maxY) / 2.0, z - (this.minZ + this.maxZ) / 2.0);
    }

    public SimpleCollisionBox expandToCoordinate(double x, double y, double z) {
        if (x < 0.0) {
            this.minX += x;
        } else {
            this.maxX += x;
        }
        if (y < 0.0) {
            this.minY += y;
        } else {
            this.maxY += y;
        }
        if (z < 0.0) {
            this.minZ += z;
        } else {
            this.maxZ += z;
        }
        return this;
    }

    public SimpleCollisionBox combineToMinimum(double x, double y, double z) {
        this.minX = Math.min(this.minX, x);
        this.maxX = Math.max(this.maxX, x);
        this.minY = Math.min(this.minY, y);
        this.maxY = Math.max(this.maxY, y);
        this.minZ = Math.min(this.minZ, z);
        this.maxZ = Math.max(this.maxZ, z);
        return this;
    }

    @Override
    public boolean isCollided(SimpleCollisionBox other) {
        return other.maxX >= this.minX && other.minX <= this.maxX && other.maxY >= this.minY && other.minY <= this.maxY && other.maxZ >= this.minZ && other.minZ <= this.maxZ;
    }

    @Override
    public boolean isIntersected(SimpleCollisionBox other) {
        return other.maxX - 1.0E-7 > this.minX && other.minX + 1.0E-7 < this.maxX && other.maxY - 1.0E-7 > this.minY && other.minY + 1.0E-7 < this.maxY && other.maxZ - 1.0E-7 > this.minZ && other.minZ + 1.0E-7 < this.maxZ;
    }

    public boolean isIntersected(CollisionBox other) {
        if (other instanceof SimpleCollisionBox) {
            return this.isIntersected((SimpleCollisionBox)other);
        }
        ArrayList<SimpleCollisionBox> boxes = new ArrayList<SimpleCollisionBox>();
        other.downCast(boxes);
        for (SimpleCollisionBox box : boxes) {
            if (!this.isIntersected(box)) continue;
            return true;
        }
        return false;
    }

    public boolean collidesVertically(SimpleCollisionBox other) {
        return other.maxX > this.minX && other.minX < this.maxX && other.maxY >= this.minY && other.minY <= this.maxY && other.maxZ > this.minZ && other.minZ < this.maxZ;
    }

    @Override
    public SimpleCollisionBox copy() {
        return new SimpleCollisionBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.isFullBlock);
    }

    @Override
    public SimpleCollisionBox offset(double x, double y, double z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        return this;
    }

    @Override
    public void downCast(List<SimpleCollisionBox> list) {
        list.add(this);
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isFullBlock() {
        return this.isFullBlock;
    }

    public boolean isFullBlockNoCache() {
        return this.minX == 0.0 && this.minY == 0.0 && this.minZ == 0.0 && this.maxX == 1.0 && this.maxY == 1.0 && this.maxZ == 1.0;
    }

    public double collideX(SimpleCollisionBox other, double offsetX) {
        if (offsetX != 0.0 && other.minY - this.maxY < -1.0E-7 && other.maxY - this.minY > 1.0E-7 && other.minZ - this.maxZ < -1.0E-7 && other.maxZ - this.minZ > 1.0E-7) {
            if (offsetX >= 0.0) {
                double max_move = this.minX - other.maxX;
                if (max_move < -1.0E-7) {
                    return offsetX;
                }
                return Math.min(max_move, offsetX);
            }
            double max_move = this.maxX - other.minX;
            if (max_move > 1.0E-7) {
                return offsetX;
            }
            return Math.max(max_move, offsetX);
        }
        return offsetX;
    }

    public double collideY(SimpleCollisionBox other, double offsetY) {
        if (offsetY != 0.0 && other.minX - this.maxX < -1.0E-7 && other.maxX - this.minX > 1.0E-7 && other.minZ - this.maxZ < -1.0E-7 && other.maxZ - this.minZ > 1.0E-7) {
            if (offsetY >= 0.0) {
                double max_move = this.minY - other.maxY;
                if (max_move < -1.0E-7) {
                    return offsetY;
                }
                return Math.min(max_move, offsetY);
            }
            double max_move = this.maxY - other.minY;
            if (max_move > 1.0E-7) {
                return offsetY;
            }
            return Math.max(max_move, offsetY);
        }
        return offsetY;
    }

    public double collideZ(SimpleCollisionBox other, double offsetZ) {
        if (offsetZ != 0.0 && other.minX - this.maxX < -1.0E-7 && other.maxX - this.minX > 1.0E-7 && other.minY - this.maxY < -1.0E-7 && other.maxY - this.minY > 1.0E-7) {
            if (offsetZ >= 0.0) {
                double max_move = this.minZ - other.maxZ;
                if (max_move < -1.0E-7) {
                    return offsetZ;
                }
                return Math.min(max_move, offsetZ);
            }
            double max_move = this.maxZ - other.minZ;
            if (max_move > 1.0E-7) {
                return offsetZ;
            }
            return Math.max(max_move, offsetZ);
        }
        return offsetZ;
    }

    public double distance(SimpleCollisionBox box) {
        double xwidth = (this.maxX - this.minX) / 2.0;
        double zwidth = (this.maxZ - this.minZ) / 2.0;
        double bxwidth = (box.maxX - box.minX) / 2.0;
        double bzwidth = (box.maxZ - box.minZ) / 2.0;
        double hxz = Math.hypot(this.minX - box.minX, this.minZ - box.minZ);
        return hxz - (xwidth + zwidth + bxwidth + bzwidth) / 4.0;
    }

    public Vector intersectsRay(Ray ray, float minDist, float maxDist) {
        Vector invDir = new Vector(1.0 / ray.calculateDirection().getX(), 1.0 / ray.calculateDirection().getY(), 1.0 / ray.calculateDirection().getZ());
        boolean signDirX = invDir.getX() < 0.0;
        boolean signDirY = invDir.getY() < 0.0;
        boolean signDirZ = invDir.getZ() < 0.0;
        Vector bbox = signDirX ? this.max() : this.min();
        double tmin = (bbox.getX() - ray.getOrigin().getX()) * invDir.getX();
        bbox = signDirX ? this.min() : this.max();
        double tmax = (bbox.getX() - ray.getOrigin().getX()) * invDir.getX();
        bbox = signDirY ? this.max() : this.min();
        double tymin = (bbox.getY() - ray.getOrigin().getY()) * invDir.getY();
        bbox = signDirY ? this.min() : this.max();
        double tymax = (bbox.getY() - ray.getOrigin().getY()) * invDir.getY();
        if (tmin > tymax || tymin > tmax) {
            return null;
        }
        if (tymin > tmin) {
            tmin = tymin;
        }
        if (tymax < tmax) {
            tmax = tymax;
        }
        bbox = signDirZ ? this.max() : this.min();
        double tzmin = (bbox.getZ() - ray.getOrigin().getZ()) * invDir.getZ();
        bbox = signDirZ ? this.min() : this.max();
        double tzmax = (bbox.getZ() - ray.getOrigin().getZ()) * invDir.getZ();
        if (tmin > tzmax || tzmin > tmax) {
            return null;
        }
        if (tzmin > tmin) {
            tmin = tzmin;
        }
        if (tzmax < tmax) {
            tmax = tzmax;
        }
        if (tmin < (double)maxDist && tmax > (double)minDist) {
            return ray.getPointAtDistance(tmin);
        }
        return null;
    }

    public Vector max() {
        return new Vector(this.maxX, this.maxY, this.maxZ);
    }

    public Vector min() {
        return new Vector(this.minX, this.minY, this.minZ);
    }

    public String toString() {
        return "SimpleCollisionBox{minX=" + this.minX + ", minY=" + this.minY + ", minZ=" + this.minZ + ", maxX=" + this.maxX + ", maxY=" + this.maxY + ", maxZ=" + this.maxZ + ", isFullBlock=" + this.isFullBlock + '}';
    }
}

