/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.collisions.datatypes;

import ac.grim.grimac.utils.collisions.datatypes.CollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ComplexCollisionBox
implements CollisionBox {
    private final List<CollisionBox> boxes = new ArrayList<CollisionBox>();

    public ComplexCollisionBox(CollisionBox ... boxes) {
        Collections.addAll(this.boxes, boxes);
    }

    public boolean add(CollisionBox collisionBox) {
        return this.boxes.add(collisionBox);
    }

    @Override
    public boolean isCollided(SimpleCollisionBox other) {
        for (CollisionBox box : this.boxes) {
            if (!box.isCollided(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIntersected(SimpleCollisionBox other) {
        for (CollisionBox box : this.boxes) {
            if (!box.isIntersected(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CollisionBox copy() {
        ComplexCollisionBox cc = new ComplexCollisionBox(new CollisionBox[0]);
        for (CollisionBox b : this.boxes) {
            cc.boxes.add(b.copy());
        }
        return cc;
    }

    @Override
    public CollisionBox offset(double x, double y, double z) {
        for (CollisionBox b : this.boxes) {
            b.offset(x, y, z);
        }
        return this;
    }

    @Override
    public void downCast(List<SimpleCollisionBox> list) {
        for (CollisionBox box : this.boxes) {
            box.downCast(list);
        }
    }

    @Override
    public boolean isNull() {
        for (CollisionBox box : this.boxes) {
            if (box.isNull()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFullBlock() {
        return false;
    }
}

