/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.collisions.blocks.connecting;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.defaulttags.BlockTags;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.East;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.North;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.South;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.West;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import ac.grim.grimac.utils.collisions.CollisionData;
import ac.grim.grimac.utils.collisions.blocks.connecting.DynamicConnecting;
import ac.grim.grimac.utils.collisions.datatypes.CollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.CollisionFactory;
import ac.grim.grimac.utils.collisions.datatypes.ComplexCollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.HexCollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;

public class DynamicWall
extends DynamicConnecting
implements CollisionFactory {
    public static final CollisionBox[] BOXES = DynamicWall.makeShapes(4.0f, 3.0f, 16.0f, 0.0f, 16.0f, false);
    private static final CollisionBox[] COLLISION_BOXES = DynamicWall.makeShapes(4.0f, 3.0f, 24.0f, 0.0f, 24.0f, false);

    public CollisionBox fetchRegularBox(GrimPlayer player, WrappedBlockState state, ClientVersion version, int x, int y, int z) {
        int up = 0;
        int east = 0;
        int west = 0;
        int south = 0;
        int north = 0;
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThan(ServerVersion.V_1_12_2)) {
            boolean sixteen = PacketEvents.getAPI().getServerManager().getVersion().isNewerThan(ServerVersion.V_1_16);
            if (state.getNorth() != North.NONE) {
                north += state.getNorth() == North.LOW || sixteen ? 1 : 2;
            }
            if (state.getEast() != East.NONE) {
                east += state.getEast() == East.LOW || sixteen ? 1 : 2;
            }
            if (state.getSouth() != South.NONE) {
                south += state.getSouth() == South.LOW || sixteen ? 1 : 2;
            }
            if (state.getWest() != West.NONE) {
                west += state.getWest() == West.LOW || sixteen ? 1 : 2;
            }
            if (state.isUp()) {
                up = 1;
            }
        } else {
            north = this.connectsTo(player, version, x, y, z, BlockFace.NORTH) ? 1 : 0;
            south = this.connectsTo(player, version, x, y, z, BlockFace.SOUTH) ? 1 : 0;
            west = this.connectsTo(player, version, x, y, z, BlockFace.WEST) ? 1 : 0;
            east = this.connectsTo(player, version, x, y, z, BlockFace.EAST) ? 1 : 0;
            up = 1;
        }
        if (version.isNewerThanOrEquals(ClientVersion.V_1_13)) {
            ComplexCollisionBox box = new ComplexCollisionBox(new CollisionBox[0]);
            if (up == 1) {
                box.add(new HexCollisionBox(4.0, 0.0, 4.0, 12.0, 16.0, 12.0));
                return box;
            }
            if (north == 1) {
                box.add(new HexCollisionBox(5.0, 0.0, 0.0, 11.0, 14.0, 11.0));
            } else if (north == 2) {
                box.add(new HexCollisionBox(5.0, 0.0, 0.0, 11.0, 16.0, 11.0));
            }
            if (south == 1) {
                box.add(new HexCollisionBox(5.0, 0.0, 5.0, 11.0, 14.0, 16.0));
            } else if (south == 2) {
                box.add(new HexCollisionBox(5.0, 0.0, 5.0, 11.0, 16.0, 16.0));
            }
            if (west == 1) {
                box.add(new HexCollisionBox(0.0, 0.0, 5.0, 11.0, 14.0, 11.0));
            } else if (west == 2) {
                box.add(new HexCollisionBox(0.0, 0.0, 5.0, 11.0, 16.0, 11.0));
            }
            if (east == 1) {
                box.add(new HexCollisionBox(5.0, 0.0, 5.0, 16.0, 14.0, 11.0));
            } else if (east == 2) {
                box.add(new HexCollisionBox(5.0, 0.0, 5.0, 16.0, 16.0, 11.0));
            }
        }
        float f = 0.25f;
        float f1 = 0.75f;
        float f2 = 0.25f;
        float f3 = 0.75f;
        if (north == 1) {
            f2 = 0.0f;
        }
        if (south == 1) {
            f3 = 1.0f;
        }
        if (west == 1) {
            f = 0.0f;
        }
        if (east == 1) {
            f1 = 1.0f;
        }
        if (north == 1 && south == 1 && west != 0 && east != 0) {
            f = 0.3125f;
            f1 = 0.6875f;
        } else if (north != 1 && south != 1 && west == 0 && east == 0) {
            f2 = 0.3125f;
            f3 = 0.6875f;
        }
        return new SimpleCollisionBox(f, 0.0, f2, f1, 1.0, f3);
    }

    @Override
    public CollisionBox fetch(GrimPlayer player, ClientVersion version, WrappedBlockState block, int x, int y, int z) {
        boolean up;
        boolean west;
        boolean south;
        boolean north;
        boolean east;
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13) && version.isNewerThan(ClientVersion.V_1_12_2)) {
            east = block.getEast() != East.NONE;
            north = block.getNorth() != North.NONE;
            south = block.getSouth() != South.NONE;
            west = block.getWest() != West.NONE;
            up = block.isUp();
        } else {
            north = this.connectsTo(player, version, x, y, z, BlockFace.NORTH);
            south = this.connectsTo(player, version, x, y, z, BlockFace.SOUTH);
            west = this.connectsTo(player, version, x, y, z, BlockFace.WEST);
            east = this.connectsTo(player, version, x, y, z, BlockFace.EAST);
            up = true;
        }
        if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_13)) {
            if (up) {
                ComplexCollisionBox box = new ComplexCollisionBox(COLLISION_BOXES[this.getAABBIndex(north, east, south, west)].copy());
                box.add(new HexCollisionBox(4.0, 0.0, 4.0, 12.0, 24.0, 12.0));
                return box;
            }
            return COLLISION_BOXES[this.getAABBIndex(north, east, south, west)].copy();
        }
        float f = 0.25f;
        float f1 = 0.75f;
        float f2 = 0.25f;
        float f3 = 0.75f;
        if (north) {
            f2 = 0.0f;
        }
        if (south) {
            f3 = 1.0f;
        }
        if (west) {
            f = 0.0f;
        }
        if (east) {
            f1 = 1.0f;
        }
        if (north && south && !west && !east) {
            f = 0.3125f;
            f1 = 0.6875f;
        } else if (!north && !south && west && east) {
            f2 = 0.3125f;
            f3 = 0.6875f;
        }
        return new SimpleCollisionBox(f, 0.0, f2, f1, 1.5, f3);
    }

    @Override
    public boolean checkCanConnect(GrimPlayer player, WrappedBlockState state, StateType one, StateType two) {
        return BlockTags.WALLS.contains(one) || CollisionData.getData(one).getMovementCollisionBox(player, player.getClientVersion(), state, 0, 0, 0).isFullBlock();
    }
}

