/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.collisions;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.defaulttags.BlockTags;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.East;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.Half;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.North;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.South;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.Tilt;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.enums.West;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.utils.collisions.CollisionData;
import ac.grim.grimac.utils.collisions.blocks.connecting.DynamicFence;
import ac.grim.grimac.utils.collisions.blocks.connecting.DynamicWall;
import ac.grim.grimac.utils.collisions.datatypes.CollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.ComplexCollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.HexCollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.HitBoxFactory;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.nmsutil.Materials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public enum HitboxData {
    SCAFFOLDING((player, item, version, data, x, y, z) -> {
        if (item == StateTypes.SCAFFOLDING) {
            return new SimpleCollisionBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, true);
        }
        ComplexCollisionBox box = new ComplexCollisionBox(new HexCollisionBox(0.0, 14.0, 0.0, 16.0, 16.0, 16.0), new HexCollisionBox(0.0, 0.0, 0.0, 2.0, 16.0, 2.0), new HexCollisionBox(14.0, 0.0, 0.0, 16.0, 16.0, 2.0), new HexCollisionBox(0.0, 0.0, 14.0, 2.0, 16.0, 16.0), new HexCollisionBox(14.0, 0.0, 14.0, 16.0, 16.0, 16.0));
        if (data.getHalf() == Half.LOWER) {
            box.add(new HexCollisionBox(0.0, 0.0, 0.0, 2.0, 2.0, 16.0));
            box.add(new HexCollisionBox(14.0, 0.0, 0.0, 16.0, 2.0, 16.0));
            box.add(new HexCollisionBox(0.0, 0.0, 14.0, 16.0, 2.0, 16.0));
            box.add(new HexCollisionBox(0.0, 0.0, 0.0, 16.0, 2.0, 2.0));
        }
        return box;
    }, StateTypes.SCAFFOLDING),
    DRIPLEAF((player, item, version, data, x, y, z) -> {
        if (version.isOlderThanOrEquals(ClientVersion.V_1_16_4)) {
            return new SimpleCollisionBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, true);
        }
        ComplexCollisionBox box = new ComplexCollisionBox(new CollisionBox[0]);
        if (data.getFacing() == BlockFace.NORTH) {
            box.add(new HexCollisionBox(5.0, 0.0, 9.0, 11.0, 15.0, 15.0));
        } else if (data.getFacing() == BlockFace.SOUTH) {
            box.add(new HexCollisionBox(5.0, 0.0, 1.0, 11.0, 15.0, 7.0));
        } else if (data.getFacing() == BlockFace.EAST) {
            box.add(new HexCollisionBox(1.0, 0.0, 5.0, 7.0, 15.0, 11.0));
        } else {
            box.add(new HexCollisionBox(9.0, 0.0, 5.0, 15.0, 15.0, 11.0));
        }
        if (data.getTilt() == Tilt.NONE || data.getTilt() == Tilt.UNSTABLE) {
            box.add(new HexCollisionBox(0.0, 11.0, 0.0, 16.0, 15.0, 16.0));
        } else if (data.getTilt() == Tilt.PARTIAL) {
            box.add(new HexCollisionBox(0.0, 11.0, 0.0, 16.0, 13.0, 16.0));
        }
        return box;
    }, StateTypes.BIG_DRIPLEAF),
    FENCE_GATE((player, item, version, data, x, y, z) -> {
        boolean isInWall;
        boolean isXAxis;
        boolean bl = isXAxis = data.getFacing() == BlockFace.WEST || data.getFacing() == BlockFace.EAST;
        if (isXAxis) {
            boolean zPosWall = Materials.isWall(player.compensatedWorld.getStateTypeAt(x, y, z + 1));
            boolean zNegWall = Materials.isWall(player.compensatedWorld.getStateTypeAt(x, y, z - 1));
            isInWall = zPosWall || zNegWall;
        } else {
            boolean xPosWall = Materials.isWall(player.compensatedWorld.getStateTypeAt(x + 1, y, z));
            boolean xNegWall = Materials.isWall(player.compensatedWorld.getStateTypeAt(x - 1, y, z));
            boolean bl2 = isInWall = xPosWall || xNegWall;
        }
        if (isInWall) {
            return isXAxis ? new HexCollisionBox(6.0, 0.0, 0.0, 10.0, 13.0, 16.0) : new HexCollisionBox(0.0, 0.0, 6.0, 16.0, 13.0, 10.0);
        }
        return isXAxis ? new HexCollisionBox(6.0, 0.0, 0.0, 10.0, 16.0, 16.0) : new HexCollisionBox(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    }, BlockTags.FENCE_GATES.getStates().toArray(new StateType[0])),
    FENCE((player, item, version, data, x, y, z) -> {
        WrappedBlockState state = player.compensatedWorld.getWrappedBlockStateAt(x, y, z);
        if (version.isOlderThanOrEquals(ClientVersion.V_1_12_2)) {
            int i = 0;
            if (data.getSouth() == South.TRUE) {
                i |= 1;
            }
            if (data.getWest() == West.TRUE) {
                i |= 2;
            }
            if (data.getNorth() == North.TRUE) {
                i |= 4;
            }
            if (data.getEast() == East.TRUE) {
                i |= 8;
            }
            return DynamicFence.LEGACY_BOUNDING_BOXES[i].copy();
        }
        ArrayList<SimpleCollisionBox> boxes = new ArrayList<SimpleCollisionBox>();
        CollisionData.getData(state.getType()).getMovementCollisionBox(player, version, state, x, y, z).downCast(boxes);
        for (SimpleCollisionBox box : boxes) {
            box.maxY = 1.0;
        }
        return new ComplexCollisionBox(boxes.toArray(new SimpleCollisionBox[0]));
    }, BlockTags.FENCES.getStates().toArray(new StateType[0])),
    WALL((player, item, version, data, x, y, z) -> {
        WrappedBlockState state = player.compensatedWorld.getWrappedBlockStateAt(x, y, z);
        return new DynamicWall().fetchRegularBox(player, state, version, x, y, z);
    }, BlockTags.WALLS.getStates().toArray(new StateType[0])),
    HONEY_BLOCK(new SimpleCollisionBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, true), StateTypes.HONEY_BLOCK),
    POWDER_SNOW(new SimpleCollisionBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, true), StateTypes.POWDER_SNOW),
    SOUL_SAND(new SimpleCollisionBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, true), StateTypes.SOUL_SAND),
    CACTUS(new HexCollisionBox(1.0, 0.0, 1.0, 15.0, 16.0, 15.0), StateTypes.CACTUS),
    SNOW((player, item, version, data, x, y, z) -> new SimpleCollisionBox(0.0, 0.0, 0.0, 1.0, (double)data.getLayers() * 0.125, 1.0), StateTypes.SNOW),
    LECTERN_BLOCK((player, item, version, data, x, y, z) -> {
        ComplexCollisionBox common = new ComplexCollisionBox(new HexCollisionBox(0.0, 0.0, 0.0, 16.0, 2.0, 16.0), new HexCollisionBox(4.0, 2.0, 4.0, 12.0, 14.0, 12.0));
        if (data.getFacing() == BlockFace.WEST) {
            common.add(new HexCollisionBox(1.0, 10.0, 0.0, 5.333333, 14.0, 16.0));
            common.add(new HexCollisionBox(5.333333, 12.0, 0.0, 9.666667, 16.0, 16.0));
            common.add(new HexCollisionBox(9.666667, 14.0, 0.0, 14.0, 18.0, 16.0));
        } else if (data.getFacing() == BlockFace.NORTH) {
            common.add(new HexCollisionBox(0.0, 10.0, 1.0, 16.0, 14.0, 5.333333));
            common.add(new HexCollisionBox(0.0, 12.0, 5.333333, 16.0, 16.0, 9.666667));
            common.add(new HexCollisionBox(0.0, 14.0, 9.666667, 16.0, 18.0, 14.0));
        } else if (data.getFacing() == BlockFace.EAST) {
            common.add(new HexCollisionBox(10.666667, 10.0, 0.0, 15.0, 14.0, 16.0));
            common.add(new HexCollisionBox(6.333333, 12.0, 0.0, 10.666667, 16.0, 16.0));
            common.add(new HexCollisionBox(2.0, 14.0, 0.0, 6.333333, 18.0, 16.0));
        } else {
            common.add(new HexCollisionBox(0.0, 10.0, 10.666667, 16.0, 14.0, 15.0));
            common.add(new HexCollisionBox(0.0, 12.0, 6.333333, 16.0, 16.0, 10.666667));
            common.add(new HexCollisionBox(0.0, 14.0, 2.0, 16.0, 18.0, 6.333333));
        }
        return common;
    }, StateTypes.LECTERN);

    private static final Map<StateType, HitboxData> lookup;
    private final StateType[] materials;
    private CollisionBox box;
    private HitBoxFactory dynamic;

    private HitboxData(CollisionBox box, StateType ... materials) {
        this.box = box;
        HashSet<StateType> mList = new HashSet<StateType>(Arrays.asList(materials));
        mList.remove(null);
        this.materials = mList.toArray(new StateType[0]);
    }

    private HitboxData(HitBoxFactory dynamic, StateType ... materials) {
        this.dynamic = dynamic;
        HashSet<StateType> mList = new HashSet<StateType>(Arrays.asList(materials));
        mList.remove(null);
        this.materials = mList.toArray(new StateType[0]);
    }

    public static HitboxData getData(StateType material) {
        return lookup.get(material);
    }

    public static CollisionBox getBlockHitbox(GrimPlayer player, StateType heldItem, ClientVersion version, WrappedBlockState block, int x, int y, int z) {
        HitboxData data = HitboxData.getData(block.getType());
        if (data == null) {
            return CollisionData.getRawData(block.getType()).getMovementCollisionBox(player, version, block, x, y, z);
        }
        if (data.box != null) {
            return data.box.copy().offset(x, y, z);
        }
        return HitboxData.getData((StateType)block.getType()).dynamic.fetch(player, heldItem, version, block, x, y, z).offset(x, y, z);
    }

    static {
        lookup = new HashMap<StateType, HitboxData>();
        for (HitboxData data2 : HitboxData.values()) {
            for (StateType type : data2.materials) {
                lookup.put(type, data2);
            }
        }
    }
}

