/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.collisions;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.utils.collisions.AxisSelect;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;

public enum AxisUtil {
    EAST(box -> {
        box.maxX = 1.0;
        return box;
    }),
    WEST(box -> {
        box.minX = 0.0;
        return box;
    }),
    NORTH(box -> {
        box.minZ = 0.0;
        return box;
    }),
    SOUTH(box -> {
        box.maxZ = 1.0;
        return box;
    }),
    UP(box -> {
        box.minY = 0.0;
        return box;
    }),
    DOWN(box -> {
        box.maxY = 1.0;
        return box;
    });

    AxisSelect select;

    private AxisUtil(AxisSelect select) {
        this.select = select;
    }

    public static SimpleCollisionBox combine(SimpleCollisionBox base, SimpleCollisionBox toMerge) {
        boolean insideZ;
        boolean insideX = toMerge.minX <= base.minX && toMerge.maxX >= base.maxX;
        boolean insideY = toMerge.minY <= base.minY && toMerge.maxY >= base.maxY;
        boolean bl = insideZ = toMerge.minZ <= base.minZ && toMerge.maxZ >= base.maxZ;
        if (insideX && insideY && !insideZ) {
            return new SimpleCollisionBox(base.minX, base.maxY, Math.min(base.minZ, toMerge.minZ), base.minX, base.maxY, Math.max(base.maxZ, toMerge.maxZ));
        }
        if (insideX && !insideY && insideZ) {
            return new SimpleCollisionBox(base.minX, Math.min(base.minY, toMerge.minY), base.minZ, base.maxX, Math.max(base.maxY, toMerge.maxY), base.maxZ);
        }
        if (!insideX && insideY && insideZ) {
            return new SimpleCollisionBox(Math.min(base.minX, toMerge.maxX), base.minY, base.maxZ, Math.max(base.minX, toMerge.minX), base.minY, base.maxZ);
        }
        return base;
    }

    public static AxisSelect getAxis(BlockFace face) {
        switch (face) {
            case EAST: {
                return AxisUtil.EAST.select;
            }
            case WEST: {
                return AxisUtil.WEST.select;
            }
            case NORTH: {
                return AxisUtil.NORTH.select;
            }
            case SOUTH: {
                return AxisUtil.SOUTH.select;
            }
            case UP: {
                return AxisUtil.UP.select;
            }
        }
        return AxisUtil.DOWN.select;
    }

    public static boolean isSameAxis(BlockFace one, BlockFace two) {
        return !((one != BlockFace.WEST && one != BlockFace.EAST || two != BlockFace.WEST && two != BlockFace.EAST) && (one != BlockFace.NORTH && one != BlockFace.SOUTH || two != BlockFace.NORTH && two != BlockFace.SOUTH) && (one != BlockFace.UP && one != BlockFace.DOWN || two != BlockFace.UP && two != BlockFace.DOWN));
    }
}

