/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.kyori.adventure.text.serializer.gson;

import ac.grim.grimac.shaded.gson.JsonParseException;
import ac.grim.grimac.shaded.gson.TypeAdapter;
import ac.grim.grimac.shaded.gson.stream.JsonReader;
import ac.grim.grimac.shaded.gson.stream.JsonWriter;
import ac.grim.grimac.shaded.kyori.adventure.util.Index;
import java.io.IOException;

final class IndexedSerializer<E>
extends TypeAdapter<E> {
    private final String name;
    private final Index<String, E> map;

    public static <E> TypeAdapter<E> of(String name, Index<String, E> map) {
        return new IndexedSerializer<E>(name, map).nullSafe();
    }

    private IndexedSerializer(String name, Index<String, E> map) {
        this.name = name;
        this.map = map;
    }

    @Override
    public void write(JsonWriter out, E value) throws IOException {
        out.value(this.map.key(value));
    }

    @Override
    public E read(JsonReader in) throws IOException {
        String string = in.nextString();
        E value = this.map.value(string);
        if (value != null) {
            return value;
        }
        throw new JsonParseException("invalid " + this.name + ":  " + string);
    }
}

