/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.viaversion;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.User;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.reflection.Reflection;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.viaversion.ViaState;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.viaversion.ViaVersionAccessor;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.viaversion.ViaVersionAccessorImpl;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.viaversion.ViaVersionAccessorImplLegacy;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ViaVersionUtil {
    private static ViaState available = ViaState.UNKNOWN;
    private static ViaVersionAccessor viaVersionAccessor;

    private ViaVersionUtil() {
    }

    private static void load() {
        if (viaVersionAccessor == null) {
            try {
                Class.forName("com.viaversion.viaversion.api.Via");
                viaVersionAccessor = new ViaVersionAccessorImpl();
            }
            catch (Exception e) {
                try {
                    Class.forName("us.myles.ViaVersion.api.Via");
                    viaVersionAccessor = new ViaVersionAccessorImplLegacy();
                }
                catch (ClassNotFoundException ex) {
                    viaVersionAccessor = null;
                }
            }
        }
    }

    public static void checkIfViaIsPresent() {
        boolean present = Bukkit.getPluginManager().isPluginEnabled("ViaVersion");
        available = present ? ViaState.ENABLED : ViaState.DISABLED;
    }

    public static boolean isAvailable() {
        if (available == ViaState.UNKNOWN) {
            return ViaVersionUtil.getViaVersionAccessor() != null;
        }
        return available == ViaState.ENABLED;
    }

    public static ViaVersionAccessor getViaVersionAccessor() {
        ViaVersionUtil.load();
        return viaVersionAccessor;
    }

    public static int getProtocolVersion(User user) {
        try {
            int version;
            Player player;
            if (user.getUUID() != null && (player = Bukkit.getPlayer((UUID)user.getUUID())) != null && (version = ViaVersionUtil.getProtocolVersion(player)) != -1) {
                return version;
            }
            ChannelHandler viaEncoder = ((Channel)user.getChannel()).pipeline().get("via-encoder");
            Object connection = Reflection.getField(viaEncoder.getClass(), "connection").get(viaEncoder);
            Object protocolInfo = Reflection.getField(connection.getClass(), "protocolInfo").get(connection);
            return (Integer)Reflection.getField(protocolInfo.getClass(), "protocolVersion").get(protocolInfo);
        }
        catch (Exception e) {
            System.out.println("Unable to grab ViaVersion client version for player!");
            return -1;
        }
    }

    public static int getProtocolVersion(Player player) {
        return ViaVersionUtil.getViaVersionAccessor().getProtocolVersion(player);
    }

    public static Class<?> getUserConnectionClass() {
        return ViaVersionUtil.getViaVersionAccessor().getUserConnectionClass();
    }

    public static Class<?> getBukkitDecodeHandlerClass() {
        return ViaVersionUtil.getViaVersionAccessor().getBukkitDecodeHandlerClass();
    }

    public static Class<?> getBukkitEncodeHandlerClass() {
        return ViaVersionUtil.getViaVersionAccessor().getBukkitEncodeHandlerClass();
    }
}

