/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.io.github.retrooper.packetevents.injector.connection;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.UserConnectEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.ConnectionState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.User;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.UserProfile;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.PacketEventsImplHelper;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.injector.handlers.PacketEventsDecoder;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.injector.handlers.PacketEventsEncoder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.NoSuchElementException;

public class ServerConnectionInitializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initChannel(Object ch, ConnectionState connectionState) {
        Channel channel = (Channel)ch;
        if (channel.getClass().getSimpleName().equals("FakeChannel")) {
            return;
        }
        User user = new User(channel, connectionState, null, new UserProfile(null, null));
        if (connectionState == ConnectionState.PLAY) {
            user.setClientVersion(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
            PacketEvents.getAPI().getLogManager().debug("Late injection detected!");
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            if (channel.pipeline().get("splitter") == null) {
                channel.close();
                return;
            }
            UserConnectEvent connectEvent = new UserConnectEvent(user);
            PacketEvents.getAPI().getEventManager().callEvent(connectEvent);
            if (connectEvent.isCancelled()) {
                channel.unsafe().closeForcibly();
                return;
            }
            ServerConnectionInitializer.relocateHandlers(channel, null, user);
            channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> PacketEventsImplHelper.handleDisconnection(user.getChannel(), user.getUUID())));
            PacketEvents.getAPI().getProtocolManager().setUser(channel, user);
        }
    }

    public static void relocateHandlers(Channel ctx, PacketEventsDecoder decoder, User user) {
        try {
            PacketEventsEncoder encoder;
            if (decoder != null) {
                if (decoder.hasBeenRelocated) {
                    return;
                }
                decoder.hasBeenRelocated = true;
                decoder = (PacketEventsDecoder)ctx.pipeline().remove(PacketEvents.DECODER_NAME);
                encoder = ctx.pipeline().remove(PacketEvents.ENCODER_NAME);
            } else {
                encoder = new PacketEventsEncoder(user);
                decoder = new PacketEventsDecoder(user);
            }
            ctx.pipeline().addBefore("decoder", PacketEvents.DECODER_NAME, (ChannelHandler)decoder);
            ctx.pipeline().addBefore("encoder", PacketEvents.ENCODER_NAME, (ChannelHandler)encoder);
        }
        catch (NoSuchElementException ex) {
            String handlers = ChannelHelper.pipelineHandlerNamesAsString(ctx);
            throw new IllegalStateException("PacketEvents failed to add a decoder to the netty pipeline. Pipeline handlers: " + handlers, ex);
        }
    }
}

