/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.Location;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.MathUtil;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class WrapperPlayServerSpawnPlayer
extends PacketWrapper<WrapperPlayServerSpawnPlayer> {
    private static final float ROTATION_DIVISOR = 0.7111111f;
    private int entityID;
    private UUID uuid;
    private Vector3d position;
    private float yaw;
    private float pitch;
    @Deprecated
    private ItemType item;
    private List<EntityData> entityMetadata;

    public WrapperPlayServerSpawnPlayer(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerSpawnPlayer(int entityId, UUID uuid, Location location, List<EntityData> entityMetadata) {
        this(entityId, uuid, location.getPosition(), location.getYaw(), location.getPitch(), entityMetadata);
    }

    public WrapperPlayServerSpawnPlayer(int entityId, UUID uuid, Location location, EntityData ... entityMetadata) {
        this(entityId, uuid, location.getPosition(), location.getYaw(), location.getPitch(), Arrays.asList(entityMetadata));
    }

    public WrapperPlayServerSpawnPlayer(int entityID, UUID uuid, Vector3d position, float yaw, float pitch, List<EntityData> entityMetadata) {
        super(PacketType.Play.Server.SPAWN_PLAYER);
        this.entityID = entityID;
        this.uuid = uuid;
        this.position = position;
        this.yaw = yaw;
        this.pitch = pitch;
        this.entityMetadata = entityMetadata;
        this.item = ItemTypes.AIR;
    }

    @Override
    public void read() {
        this.entityID = this.readVarInt();
        this.uuid = this.readUUID();
        boolean v1_9 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9);
        this.position = v1_9 ? new Vector3d(this.readDouble(), this.readDouble(), this.readDouble()) : new Vector3d((double)this.readInt() / 32.0, (double)this.readInt() / 32.0, (double)this.readInt() / 32.0);
        this.yaw = (float)this.readByte() / 0.7111111f;
        this.pitch = (float)this.readByte() / 0.7111111f;
        this.item = !v1_9 ? ItemTypes.getById(this.serverVersion.toClientVersion(), this.readShort()) : ItemTypes.AIR;
        this.entityMetadata = this.serverVersion.isOlderThan(ServerVersion.V_1_15) ? this.readEntityMetadata() : new ArrayList<EntityData>();
    }

    @Override
    public void write() {
        this.writeVarInt(this.entityID);
        this.writeUUID(this.uuid);
        boolean v1_9 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9);
        if (v1_9) {
            this.writeDouble(this.position.getX());
            this.writeDouble(this.position.getY());
            this.writeDouble(this.position.getZ());
        } else {
            this.writeInt(MathUtil.floor(this.position.getX() * 32.0));
            this.writeInt(MathUtil.floor(this.position.getY() * 32.0));
            this.writeInt(MathUtil.floor(this.position.getZ() * 32.0));
        }
        this.writeByte((byte)(this.yaw * 0.7111111f));
        this.writeByte((byte)(this.pitch * 0.7111111f));
        if (!v1_9) {
            this.writeShort(this.item.getId(this.serverVersion.toClientVersion()));
        }
        if (this.serverVersion.isOlderThan(ServerVersion.V_1_15)) {
            this.writeEntityMetadata(this.entityMetadata);
        }
    }

    @Override
    public void copy(WrapperPlayServerSpawnPlayer wrapper) {
        this.entityID = wrapper.entityID;
        this.uuid = wrapper.uuid;
        this.position = wrapper.position;
        this.yaw = wrapper.yaw;
        this.pitch = wrapper.pitch;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public void setEntityId(int entityID) {
        this.entityID = entityID;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public void setPosition(Vector3d position) {
        this.position = position;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    @Deprecated
    public List<EntityData> getEntityMetadata() {
        return this.entityMetadata;
    }

    @Deprecated
    public void setEntityMetadata(List<EntityData> entityMetadata) {
        this.entityMetadata = entityMetadata;
    }

    @Deprecated
    public ItemType getItem() {
        return this.item;
    }

    @Deprecated
    public void setItem(ItemType item) {
        this.item = item;
    }
}

