/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3f;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.List;

public class WrapperPlayServerExplosion
extends PacketWrapper<WrapperPlayServerExplosion> {
    private Vector3f position;
    private float strength;
    private List<Vector3i> records;
    private Vector3f playerMotion;

    public WrapperPlayServerExplosion(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerExplosion(Vector3f position, float strength, List<Vector3i> records, Vector3f playerMotion) {
        super(PacketType.Play.Server.EXPLOSION);
        this.position = position;
        this.strength = strength;
        this.records = records;
        this.playerMotion = playerMotion;
    }

    @Override
    public void read() {
        float x = this.readFloat();
        float y = this.readFloat();
        float z = this.readFloat();
        this.position = new Vector3f(x, y, z);
        this.strength = this.readFloat();
        int recordsLength = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17) ? this.readVarInt() : this.readInt();
        this.records = new ArrayList<Vector3i>(recordsLength);
        Vector3i floor = this.toFloor(this.position);
        for (int i = 0; i < recordsLength; ++i) {
            int chunkPosX = this.readByte() + floor.getX();
            int chunkPosY = this.readByte() + floor.getY();
            int chunkPosZ = this.readByte() + floor.getZ();
            this.records.add(new Vector3i(chunkPosX, chunkPosY, chunkPosZ));
        }
        float motX = this.readFloat();
        float motY = this.readFloat();
        float motZ = this.readFloat();
        this.playerMotion = new Vector3f(motX, motY, motZ);
    }

    @Override
    public void write() {
        this.writeFloat(this.position.x);
        this.writeFloat(this.position.y);
        this.writeFloat(this.position.z);
        this.writeFloat(this.strength);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.writeVarInt(this.records.size());
        } else {
            this.writeInt(this.records.size());
        }
        Vector3i floor = this.toFloor(this.position);
        for (Vector3i record : this.records) {
            this.writeByte(record.x - floor.getX());
            this.writeByte(record.y - floor.getY());
            this.writeByte(record.z - floor.getZ());
        }
        this.writeFloat(this.playerMotion.x);
        this.writeFloat(this.playerMotion.y);
        this.writeFloat(this.playerMotion.z);
    }

    @Override
    public void copy(WrapperPlayServerExplosion wrapper) {
        this.position = wrapper.position;
        this.strength = wrapper.strength;
        this.records = wrapper.records;
        this.playerMotion = wrapper.playerMotion;
    }

    private Vector3i toFloor(Vector3f position) {
        int floorZ;
        int floorY;
        int floorX;
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            floorX = (int)Math.floor(position.x);
            floorY = (int)Math.floor(position.y);
            floorZ = (int)Math.floor(position.z);
        } else {
            floorX = (int)position.x;
            floorY = (int)position.y;
            floorZ = (int)position.z;
        }
        return new Vector3i(floorX, floorY, floorZ);
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    public List<Vector3i> getRecords() {
        return this.records;
    }

    public void setRecords(List<Vector3i> records) {
        this.records = records;
    }

    public Vector3f getPlayerMotion() {
        return this.playerMotion;
    }

    public void setPlayerMotion(Vector3f playerMotion) {
        this.playerMotion = playerMotion;
    }
}

