/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.DiggingAction;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;

public class WrapperPlayClientPlayerDigging
extends PacketWrapper<WrapperPlayClientPlayerDigging> {
    private DiggingAction action;
    private Vector3i blockPosition;
    private BlockFace blockFace;
    private int sequence;

    public WrapperPlayClientPlayerDigging(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientPlayerDigging(DiggingAction action, Vector3i blockPosition, BlockFace blockFace, int sequence2) {
        super(PacketType.Play.Client.PLAYER_DIGGING);
        this.action = action;
        this.blockPosition = blockPosition;
        this.blockFace = blockFace;
        this.sequence = sequence2;
    }

    @Override
    public void read() {
        this.action = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9) ? DiggingAction.getById(this.readVarInt()) : DiggingAction.getById(this.readByte());
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            this.blockPosition = this.readBlockPosition();
        } else {
            int x = this.readInt();
            short y = this.readUnsignedByte();
            int z = this.readInt();
            this.blockPosition = new Vector3i(x, y, z);
        }
        short face = this.readUnsignedByte();
        this.blockFace = BlockFace.getBlockFaceByValue(face);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.sequence = this.readVarInt();
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            this.writeVarInt(this.action.getId());
            this.writeBlockPosition(this.blockPosition);
        } else {
            this.writeByte(this.action.getId());
            this.writeInt(this.blockPosition.x);
            this.writeByte(this.blockPosition.y);
            this.writeInt(this.blockPosition.z);
        }
        this.writeByte(this.blockFace.getFaceValue());
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.writeVarInt(this.sequence);
        }
    }

    @Override
    public void copy(WrapperPlayClientPlayerDigging wrapper) {
        this.action = wrapper.action;
        this.blockPosition = wrapper.blockPosition;
        this.blockFace = wrapper.blockFace;
        this.sequence = wrapper.sequence;
    }

    public DiggingAction getAction() {
        return this.action;
    }

    public void setAction(DiggingAction action) {
        this.action = action;
    }

    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public BlockFace getBlockFace() {
        return this.blockFace;
    }

    public void setBlockFace(BlockFace blockFace) {
        this.blockFace = blockFace;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence2) {
        this.sequence = sequence2;
    }
}

