/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.InteractionHand;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3f;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.Optional;

public class WrapperPlayClientPlayerBlockPlacement
extends PacketWrapper<WrapperPlayClientPlayerBlockPlacement> {
    private InteractionHand interactionHand;
    private Vector3i blockPosition;
    private BlockFace face;
    private Vector3f cursorPosition;
    private Optional<ItemStack> itemStack;
    private Optional<Boolean> insideBlock;
    int sequence;

    public WrapperPlayClientPlayerBlockPlacement(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientPlayerBlockPlacement(InteractionHand interactionHand, Vector3i blockPosition, BlockFace face, Vector3f cursorPosition, Optional<Boolean> insideBlock, int sequence2) {
        super(PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT);
        this.interactionHand = interactionHand;
        this.blockPosition = blockPosition;
        this.face = face;
        this.cursorPosition = cursorPosition;
        this.insideBlock = insideBlock;
        this.sequence = sequence2;
    }

    @Override
    public void read() {
        this.itemStack = Optional.empty();
        this.insideBlock = Optional.empty();
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            this.interactionHand = InteractionHand.getById(this.readVarInt());
            this.blockPosition = this.readBlockPosition();
            this.face = BlockFace.getBlockFaceByValue(this.readVarInt());
            this.cursorPosition = new Vector3f(this.readFloat(), this.readFloat(), this.readFloat());
            this.insideBlock = Optional.of(this.readBoolean());
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
                this.sequence = this.readVarInt();
            }
        } else {
            this.blockPosition = this.serverVersion == ServerVersion.V_1_7_10 ? new Vector3i(this.readInt(), this.readUnsignedByte(), this.readInt()) : this.readBlockPosition();
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
                this.face = BlockFace.getBlockFaceByValue(this.readVarInt());
                this.interactionHand = InteractionHand.getById(this.readVarInt());
            } else {
                this.face = BlockFace.getLegacyBlockFaceByValue(this.readUnsignedByte());
                this.itemStack = Optional.of(this.readItemStack());
                this.interactionHand = InteractionHand.MAIN_HAND;
            }
            this.cursorPosition = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_11) ? new Vector3f(this.readFloat(), this.readFloat(), this.readFloat()) : new Vector3f((float)this.readUnsignedByte() / 16.0f, (float)this.readUnsignedByte() / 16.0f, (float)this.readUnsignedByte() / 16.0f);
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            this.writeVarInt(this.interactionHand.getId());
            this.writeBlockPosition(this.blockPosition);
            this.writeVarInt(this.face.getFaceValue());
            this.writeFloat(this.cursorPosition.x);
            this.writeFloat(this.cursorPosition.y);
            this.writeFloat(this.cursorPosition.z);
            this.writeBoolean(this.insideBlock.orElse(false));
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
                this.writeVarInt(this.sequence);
            }
        } else {
            if (this.serverVersion == ServerVersion.V_1_7_10) {
                this.writeInt(this.blockPosition.x);
                this.writeByte(this.blockPosition.x);
                this.writeInt(this.blockPosition.z);
            } else {
                this.writeBlockPosition(this.blockPosition);
            }
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
                this.writeVarInt(this.face.getFaceValue());
                this.writeVarInt(this.interactionHand.getId());
            } else {
                this.writeByte(this.face.getFaceValue());
                this.writeItemStack(this.itemStack.orElse(ItemStack.EMPTY));
            }
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_11)) {
                this.writeFloat(this.cursorPosition.x);
                this.writeFloat(this.cursorPosition.y);
                this.writeFloat(this.cursorPosition.z);
            } else {
                this.writeByte((int)(this.cursorPosition.x * 16.0f));
                this.writeByte((int)(this.cursorPosition.y * 16.0f));
                this.writeByte((int)(this.cursorPosition.z * 16.0f));
            }
        }
    }

    @Override
    public void copy(WrapperPlayClientPlayerBlockPlacement wrapper) {
        this.interactionHand = wrapper.interactionHand;
        this.blockPosition = wrapper.blockPosition;
        this.face = wrapper.face;
        this.cursorPosition = wrapper.cursorPosition;
        this.itemStack = wrapper.itemStack;
        this.insideBlock = wrapper.insideBlock;
        this.sequence = wrapper.sequence;
    }

    public InteractionHand getHand() {
        return this.interactionHand;
    }

    public void setHand(InteractionHand interactionHand) {
        this.interactionHand = interactionHand;
    }

    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public BlockFace getFace() {
        return this.face;
    }

    public void setFace(BlockFace face) {
        this.face = face;
    }

    public Vector3f getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(Vector3f cursorPosition) {
        this.cursorPosition = cursorPosition;
    }

    public Optional<ItemStack> getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(Optional<ItemStack> itemStack) {
        this.itemStack = itemStack;
    }

    public Optional<Boolean> getInsideBlock() {
        return this.insideBlock;
    }

    public void setInsideBlock(Optional<Boolean> insideBlock) {
        this.insideBlock = insideBlock;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence2) {
        this.sequence = sequence2;
    }
}

