/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.handshaking.client;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.exception.PacketProcessException;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.ConnectionState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;

public class WrapperHandshakingClientHandshake
extends PacketWrapper<WrapperHandshakingClientHandshake> {
    private int protocolVersion;
    private ClientVersion clientVersion;
    private String serverAddress;
    private int serverPort;
    private ConnectionState nextConnectionState;

    public WrapperHandshakingClientHandshake(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperHandshakingClientHandshake(int protocolVersion, String serverAddress, int serverPort, ConnectionState nextConnectionState) {
        super(PacketType.Handshaking.Client.HANDSHAKE);
        this.protocolVersion = protocolVersion;
        this.clientVersion = ClientVersion.getById(protocolVersion);
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
        this.nextConnectionState = nextConnectionState;
    }

    @Override
    public void read() {
        try {
            this.protocolVersion = this.readVarInt();
            this.clientVersion = ClientVersion.getById(this.protocolVersion);
            this.serverAddress = this.readString(Short.MAX_VALUE);
            this.serverPort = this.readUnsignedShort();
            int nextStateIndex = this.readVarInt();
            this.nextConnectionState = ConnectionState.getById(nextStateIndex);
        }
        catch (Exception e) {
            throw new PacketProcessException(e);
        }
    }

    @Override
    public void write() {
        this.writeVarInt(this.protocolVersion);
        this.writeString(this.serverAddress, Short.MAX_VALUE);
        this.writeShort(this.serverPort);
        this.writeVarInt(this.nextConnectionState.ordinal());
    }

    @Override
    public void copy(WrapperHandshakingClientHandshake wrapper) {
        this.protocolVersion = wrapper.protocolVersion;
        this.clientVersion = wrapper.clientVersion;
        this.serverAddress = wrapper.serverAddress;
        this.serverPort = wrapper.serverPort;
        this.nextConnectionState = wrapper.nextConnectionState;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.clientVersion = ClientVersion.getById(protocolVersion);
    }

    @Override
    public ClientVersion getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public void setClientVersion(ClientVersion clientVersion) {
        this.clientVersion = clientVersion;
        this.protocolVersion = clientVersion.getProtocolVersion();
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public ConnectionState getNextConnectionState() {
        return this.nextConnectionState;
    }

    public void setNextConnectionState(ConnectionState nextConnectionState) {
        this.nextConnectionState = nextConnectionState;
    }
}

