/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.ProtocolPacketEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.VersionComparison;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.netty.buffer.UnpooledByteBufAllocationHelper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.chat.ChatType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.chat.ChatTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.chat.LastSeenMessages;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.chat.RemoteChatSession;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.chat.filter.FilterMask;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.chat.filter.FilterMaskType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.chat.message.ChatMessage_v1_19_1;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.data.EntityDataType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.villager.VillagerData;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.codec.NBTCodec;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.GameMode;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.PublicProfileKey;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.User;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.recipe.data.MerchantOffer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.Dimension;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.WorldBlockPosition;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.resources.ResourceLocation;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.AdventureSerializer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.StringUtil;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.crypto.MinecraftEncryptionUtil;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.crypto.SaltSignature;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.crypto.SignatureData;
import ac.grim.grimac.shaded.jetbrains.annotations.ApiStatus;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.shaded.kyori.adventure.text.Component;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;

public class PacketWrapper<T extends PacketWrapper> {
    @Nullable
    public Object buffer;
    protected ClientVersion clientVersion;
    protected ServerVersion serverVersion;
    private int packetID;
    @Nullable
    protected User user;
    private static final int MODERN_MESSAGE_LENGTH = 262144;
    private static final int LEGACY_MESSAGE_LENGTH = Short.MAX_VALUE;

    public PacketWrapper(ClientVersion clientVersion, ServerVersion serverVersion, int packetID) {
        if (packetID == -1) {
            throw new IllegalArgumentException("Packet does not exist on this protocol version!");
        }
        this.clientVersion = clientVersion;
        this.serverVersion = serverVersion;
        this.buffer = null;
        this.packetID = packetID;
    }

    public PacketWrapper(PacketReceiveEvent event) {
        this(event, true);
    }

    public PacketWrapper(PacketReceiveEvent event, boolean readData) {
        this.clientVersion = event.getUser().getClientVersion();
        this.serverVersion = event.getServerVersion();
        this.user = event.getUser();
        this.buffer = event.getByteBuf();
        this.packetID = event.getPacketId();
        if (readData) {
            this.readEvent(event);
        }
    }

    public PacketWrapper(PacketSendEvent event) {
        this(event, true);
    }

    public PacketWrapper(PacketSendEvent event, boolean readData) {
        this.clientVersion = event.getUser().getClientVersion();
        this.serverVersion = event.getServerVersion();
        this.buffer = event.getByteBuf();
        this.packetID = event.getPacketId();
        this.user = event.getUser();
        if (readData) {
            this.readEvent(event);
        }
    }

    public PacketWrapper(int packetID, ClientVersion clientVersion) {
        this(clientVersion, PacketEvents.getAPI().getServerManager().getVersion(), packetID);
    }

    public PacketWrapper(int packetID) {
        this(ClientVersion.UNKNOWN, PacketEvents.getAPI().getServerManager().getVersion(), packetID);
    }

    public PacketWrapper(PacketTypeCommon packetType) {
        this(packetType.getId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()));
    }

    public static PacketWrapper<?> createUniversalPacketWrapper(Object byteBuf) {
        PacketWrapper wrapper = new PacketWrapper(ClientVersion.UNKNOWN, PacketEvents.getAPI().getServerManager().getVersion(), -2);
        wrapper.buffer = byteBuf;
        return wrapper;
    }

    public final void prepareForSend() {
        if (this.buffer == null || ByteBufHelper.refCnt(this.buffer) == 0) {
            this.buffer = UnpooledByteBufAllocationHelper.buffer();
        }
        this.writeVarInt(this.packetID);
        this.write();
    }

    public void read() {
    }

    public void write() {
    }

    public void copy(T wrapper) {
    }

    public final void readEvent(ProtocolPacketEvent<?> event) {
        PacketWrapper<?> last = event.getLastUsedWrapper();
        if (last != null) {
            this.copy(last);
        } else {
            this.read();
        }
        event.setLastUsedWrapper(this);
    }

    public ClientVersion getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(ClientVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(ServerVersion serverVersion) {
        this.serverVersion = serverVersion;
    }

    public Object getBuffer() {
        return this.buffer;
    }

    public int getPacketId() {
        return this.packetID;
    }

    public void setPacketId(int packetID) {
        this.packetID = packetID;
    }

    public int getMaxMessageLength() {
        return this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13) ? 262144 : Short.MAX_VALUE;
    }

    public void resetByteBuf() {
        ByteBufHelper.clear(this.buffer);
        this.writeVarInt(this.packetID);
    }

    public byte readByte() {
        return ByteBufHelper.readByte(this.buffer);
    }

    public void writeByte(int value) {
        ByteBufHelper.writeByte(this.buffer, value);
    }

    public short readUnsignedByte() {
        return ByteBufHelper.readUnsignedByte(this.buffer);
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public void writeBoolean(boolean value) {
        this.writeByte(value ? 1 : 0);
    }

    public int readInt() {
        return ByteBufHelper.readInt(this.buffer);
    }

    public void writeInt(int value) {
        ByteBufHelper.writeInt(this.buffer, value);
    }

    public int readVarInt() {
        byte currentByte;
        int value = 0;
        int length = 0;
        do {
            currentByte = this.readByte();
            value |= (currentByte & 0x7F) << length * 7;
            if (++length <= 5) continue;
            throw new RuntimeException("VarInt is too large. Must be smaller than 5 bytes.");
        } while ((currentByte & 0x80) == 128);
        return value;
    }

    public void writeVarInt(int value) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) break;
            this.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.writeByte(value);
    }

    public <K, V> Map<K, V> readMap(Reader<K> keyFunction, Reader<V> valueFunction) {
        int size = this.readVarInt();
        HashMap map = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = keyFunction.apply(this);
            Object value = valueFunction.apply(this);
            map.put(key, value);
        }
        return map;
    }

    public <K, V> void writeMap(Map<K, V> map, Writer<K> keyConsumer, Writer<V> valueConsumer) {
        this.writeVarInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            keyConsumer.accept(this, key);
            valueConsumer.accept(this, value);
        }
    }

    public VillagerData readVillagerData() {
        int villagerTypeId = this.readVarInt();
        int villagerProfessionId = this.readVarInt();
        int level = this.readVarInt();
        return new VillagerData(villagerTypeId, villagerProfessionId, level);
    }

    public void writeVillagerData(VillagerData data) {
        this.writeVarInt(data.getType().getId());
        this.writeVarInt(data.getProfession().getId());
        this.writeVarInt(data.getLevel());
    }

    @NotNull
    public ItemStack readItemStack() {
        int typeID;
        boolean v1_13_2 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13_2);
        if (v1_13_2 && !this.readBoolean()) {
            return ItemStack.EMPTY;
        }
        int n = typeID = v1_13_2 ? this.readVarInt() : (int)this.readShort();
        if (typeID < 0 && !v1_13_2) {
            return ItemStack.EMPTY;
        }
        ItemType type = ItemTypes.getById(this.serverVersion.toClientVersion(), typeID);
        byte amount = this.readByte();
        int legacyData = v1_13_2 ? -1 : (int)this.readShort();
        NBTCompound nbt = this.readNBT();
        return ItemStack.builder().type(type).amount(amount).nbt(nbt).legacyData(legacyData).build();
    }

    public void writeItemStack(ItemStack itemStack) {
        boolean v1_13_2;
        if (itemStack == null) {
            itemStack = ItemStack.EMPTY;
        }
        if (v1_13_2 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13_2)) {
            if (itemStack.isEmpty()) {
                this.writeBoolean(false);
            } else {
                this.writeBoolean(true);
                int typeID = itemStack.getType().getId(this.serverVersion.toClientVersion());
                this.writeVarInt(typeID);
                this.writeByte(itemStack.getAmount());
                this.writeNBT(itemStack.getNBT());
            }
        } else {
            int typeID = itemStack.isEmpty() ? -1 : itemStack.getType().getId(this.serverVersion.toClientVersion());
            this.writeShort(typeID);
            if (typeID >= 0) {
                this.writeByte(itemStack.getAmount());
                this.writeShort(itemStack.getLegacyData());
                this.writeNBT(itemStack.getNBT());
            }
        }
    }

    public NBTCompound readNBT() {
        return NBTCodec.readNBTFromBuffer(this.buffer, this.serverVersion);
    }

    public void writeNBT(NBTCompound nbt) {
        NBTCodec.writeNBTToBuffer(this.buffer, this.serverVersion, nbt);
    }

    public String readString() {
        return this.readString(Short.MAX_VALUE);
    }

    public String readString(int maxLen) {
        int j = this.readVarInt();
        if (j > maxLen * 4) {
            throw new RuntimeException("The received encoded string buffer length is longer than maximum allowed (" + j + " > " + maxLen * 4 + ")");
        }
        if (j < 0) {
            throw new RuntimeException("The received encoded string buffer length is less than zero! Weird string!");
        }
        String s = ByteBufHelper.toString(this.buffer, ByteBufHelper.readerIndex(this.buffer), j, StandardCharsets.UTF_8);
        ByteBufHelper.readerIndex(this.buffer, ByteBufHelper.readerIndex(this.buffer) + j);
        if (s.length() > maxLen) {
            throw new RuntimeException("The received string length is longer than maximum allowed (" + j + " > " + maxLen + ")");
        }
        return s;
    }

    public String readComponentJSON() {
        return this.readString(this.getMaxMessageLength());
    }

    public void writeString(String s) {
        this.writeString(s, Short.MAX_VALUE);
    }

    public void writeString(String s, int maxLen) {
        this.writeString(s, maxLen, true);
    }

    public void writeString(String s, int maxLen, boolean substr) {
        if (substr) {
            s = StringUtil.maximizeLength(s, maxLen);
        }
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        if (!substr && bytes.length > maxLen) {
            throw new IllegalStateException("String too big (was " + bytes.length + " bytes encoded, max " + maxLen + ")");
        }
        this.writeVarInt(bytes.length);
        ByteBufHelper.writeBytes(this.buffer, bytes);
    }

    public void writeComponentJSON(String json) {
        this.writeString(json, this.getMaxMessageLength());
    }

    public Component readComponent() {
        return AdventureSerializer.parseComponent(this.readComponentJSON());
    }

    public void writeComponent(Component component) {
        this.writeComponentJSON(AdventureSerializer.toJson(component));
    }

    public ResourceLocation readIdentifier(int maxLen) {
        return new ResourceLocation(this.readString(maxLen));
    }

    public ResourceLocation readIdentifier() {
        return this.readIdentifier(Short.MAX_VALUE);
    }

    public void writeIdentifier(ResourceLocation identifier, int maxLen) {
        this.writeString(identifier.toString(), maxLen);
    }

    public void writeIdentifier(ResourceLocation identifier) {
        this.writeIdentifier(identifier, Short.MAX_VALUE);
    }

    public int readUnsignedShort() {
        return ByteBufHelper.readUnsignedShort(this.buffer);
    }

    public short readShort() {
        return ByteBufHelper.readShort(this.buffer);
    }

    public void writeShort(int value) {
        ByteBufHelper.writeShort(this.buffer, value);
    }

    public int readVarShort() {
        int low = this.readUnsignedShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = this.readUnsignedByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    public void writeVarShort(int value) {
        int low = value & Short.MAX_VALUE;
        int high = (value & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        this.writeShort(low);
        if (high != 0) {
            this.writeByte(high);
        }
    }

    public long readLong() {
        return ByteBufHelper.readLong(this.buffer);
    }

    public void writeLong(long value) {
        ByteBufHelper.writeLong(this.buffer, value);
    }

    public long readVarLong() {
        byte b;
        long value = 0L;
        int size = 0;
        while (((b = this.readByte()) & 0x80) == 128) {
            value |= (long)(b & 0x7F) << size++ * 7;
        }
        return value | (long)(b & 0x7F) << size * 7;
    }

    public void writeVarLong(long l) {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((int)(l & 0x7FL) | 0x80);
            l >>>= 7;
        }
        this.writeByte((int)l);
    }

    public float readFloat() {
        return ByteBufHelper.readFloat(this.buffer);
    }

    public void writeFloat(float value) {
        ByteBufHelper.writeFloat(this.buffer, value);
    }

    public double readDouble() {
        return ByteBufHelper.readDouble(this.buffer);
    }

    public void writeDouble(double value) {
        ByteBufHelper.writeDouble(this.buffer, value);
    }

    public byte[] readRemainingBytes() {
        return this.readBytes(ByteBufHelper.readableBytes(this.buffer));
    }

    public byte[] readBytes(int size) {
        byte[] bytes = new byte[size];
        ByteBufHelper.readBytes(this.buffer, bytes);
        return bytes;
    }

    public void writeBytes(byte[] array) {
        ByteBufHelper.writeBytes(this.buffer, array);
    }

    public byte[] readByteArray(int maxLength) {
        int len = this.readVarInt();
        if (len > maxLength) {
            throw new RuntimeException("The received byte array length is longer than maximum allowed (" + len + " > " + maxLength + ")");
        }
        return this.readBytes(len);
    }

    public byte[] readByteArray() {
        return this.readByteArray(ByteBufHelper.readableBytes(this.buffer));
    }

    public void writeByteArray(byte[] array) {
        this.writeVarInt(array.length);
        this.writeBytes(array);
    }

    public int[] readVarIntArray() {
        int readableBytes = ByteBufHelper.readableBytes(this.buffer);
        int size = this.readVarInt();
        if (size > readableBytes) {
            throw new IllegalStateException("VarIntArray with size " + size + " is bigger than allowed " + readableBytes);
        }
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.readVarInt();
        }
        return array;
    }

    public void writeVarIntArray(int[] array) {
        this.writeVarInt(array.length);
        for (int i : array) {
            this.writeVarInt(i);
        }
    }

    public long[] readLongArray(int size) {
        long[] array = new long[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    public byte[] readByteArrayOfSize(int size) {
        byte[] array = new byte[size];
        ByteBufHelper.readBytes(this.buffer, array);
        return array;
    }

    public void writeByteArrayOfSize(byte[] array) {
        ByteBufHelper.writeBytes(this.buffer, array);
    }

    public int[] readVarIntArrayOfSize(int size) {
        int[] array = new int[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readVarInt();
        }
        return array;
    }

    public void writeVarIntArrayOfSize(int[] array) {
        for (int i : array) {
            this.writeVarInt(i);
        }
    }

    public long[] readLongArray() {
        int readableBytes = ByteBufHelper.readableBytes(this.buffer) / 8;
        int size = this.readVarInt();
        if (size > readableBytes) {
            throw new IllegalStateException("LongArray with size " + size + " is bigger than allowed " + readableBytes);
        }
        long[] array = new long[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    public void writeLongArray(long[] array) {
        this.writeVarInt(array.length);
        for (long l : array) {
            this.writeLong(l);
        }
    }

    public UUID readUUID() {
        long mostSigBits = this.readLong();
        long leastSigBits = this.readLong();
        return new UUID(mostSigBits, leastSigBits);
    }

    public void writeUUID(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    public Vector3i readBlockPosition() {
        long val = this.readLong();
        return new Vector3i(val, this.serverVersion);
    }

    public void writeBlockPosition(Vector3i pos) {
        long val = pos.getSerializedPosition(this.serverVersion);
        this.writeLong(val);
    }

    public GameMode readGameMode() {
        return GameMode.getById(this.readByte());
    }

    public void writeGameMode(@Nullable GameMode mode) {
        int id = mode == null ? -1 : mode.getId();
        this.writeByte(id);
    }

    public List<EntityData> readEntityMetadata() {
        ArrayList<EntityData> list = new ArrayList<EntityData>();
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            short index;
            boolean v1_10 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_10);
            while ((index = this.readUnsignedByte()) != 255) {
                int typeID = v1_10 ? this.readVarInt() : (int)this.readUnsignedByte();
                EntityDataType<?> type = EntityDataTypes.getById(this.serverVersion.toClientVersion(), typeID);
                Object value = type.getDataDeserializer().apply(this);
                list.add(new EntityData(index, type, value));
            }
        } else {
            byte data = this.readByte();
            while (data != 127) {
                int typeID = (data & 0xE0) >> 5;
                int index = data & 0x1F;
                EntityDataType<?> type = EntityDataTypes.getById(this.serverVersion.toClientVersion(), typeID);
                Object value = type.getDataDeserializer().apply(this);
                EntityData entityData = new EntityData(index, type, value);
                list.add(entityData);
                data = this.readByte();
            }
        }
        return list;
    }

    public void writeEntityMetadata(List<EntityData> list) {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            boolean v1_10 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_10);
            for (EntityData entityData : list) {
                this.writeByte(entityData.getIndex());
                if (v1_10) {
                    this.writeVarInt(entityData.getType().getId(this.serverVersion.toClientVersion()));
                } else {
                    this.writeByte(entityData.getType().getId(this.serverVersion.toClientVersion()));
                }
                entityData.getType().getDataSerializer().accept(this, entityData.getValue());
            }
            this.writeByte(255);
        } else {
            for (EntityData entityData : list) {
                int typeID = entityData.getType().getId(this.serverVersion.toClientVersion());
                int index = entityData.getIndex();
                int data = (typeID << 5 | index & 0x1F) & 0xFF;
                this.writeByte(data);
                entityData.getType().getDataSerializer().accept(this, entityData.getValue());
            }
            this.writeByte(127);
        }
    }

    public Dimension readDimension() {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_19)) {
            Dimension dimension = new Dimension(new NBTCompound());
            dimension.setDimensionName(this.readIdentifier().toString());
            return dimension;
        }
        return new Dimension(this.readNBT());
    }

    public void writeDimension(Dimension dimension) {
        boolean v1_19 = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_19);
        boolean v1_16_2 = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_16_2);
        if (v1_19 || !v1_16_2) {
            this.writeString(dimension.getDimensionName(), Short.MAX_VALUE);
        } else {
            this.writeNBT(dimension.getAttributes());
        }
    }

    public SaltSignature readSaltSignature() {
        return new SaltSignature(this.readLong(), this.readByteArray());
    }

    public void writeSaltSignature(SaltSignature signature) {
        this.writeLong(signature.getSalt());
        this.writeByteArray(signature.getSignature());
    }

    public PublicKey readPublicKey() {
        return MinecraftEncryptionUtil.publicKey(this.readByteArray(512));
    }

    public void writePublicKey(PublicKey publicKey) {
        this.writeByteArray(publicKey.getEncoded());
    }

    public PublicProfileKey readPublicProfileKey() {
        Instant expiresAt = this.readTimestamp();
        PublicKey key = this.readPublicKey();
        byte[] keySignature = this.readByteArray(4096);
        return new PublicProfileKey(expiresAt, key, keySignature);
    }

    public void writePublicProfileKey(PublicProfileKey key) {
        this.writeTimestamp(key.getExpiresAt());
        this.writePublicKey(key.getKey());
        this.writeByteArray(key.getKeySignature());
    }

    public RemoteChatSession readRemoteChatSession() {
        return new RemoteChatSession(this.readUUID(), this.readPublicProfileKey());
    }

    public void writeRemoteChatSession(RemoteChatSession chatSession) {
        this.writeUUID(chatSession.getSessionId());
        this.writePublicProfileKey(chatSession.getPublicProfileKey());
    }

    public Instant readTimestamp() {
        return Instant.ofEpochMilli(this.readLong());
    }

    public void writeTimestamp(Instant timestamp) {
        this.writeLong(timestamp.toEpochMilli());
    }

    public SignatureData readSignatureData() {
        return new SignatureData(this.readTimestamp(), this.readPublicKey(), this.readByteArray(4096));
    }

    public void writeSignatureData(SignatureData signatureData) {
        this.writeTimestamp(signatureData.getTimestamp());
        this.writePublicKey(signatureData.getPublicKey());
        this.writeByteArray(signatureData.getSignature());
    }

    public static <K> IntFunction<K> limitValue(IntFunction<K> function, int limit) {
        return i -> {
            if (i > limit) {
                throw new RuntimeException("Value " + i + " is larger than limit " + limit);
            }
            return function.apply(i);
        };
    }

    public WorldBlockPosition readWorldBlockPosition() {
        return new WorldBlockPosition(this.readIdentifier(), this.readBlockPosition());
    }

    public void writeWorldBlockPosition(WorldBlockPosition pos) {
        this.writeIdentifier(pos.getWorld());
        this.writeBlockPosition(pos.getBlockPosition());
    }

    public LastSeenMessages.Entry readLastSeenMessagesEntry() {
        return new LastSeenMessages.Entry(this.readUUID(), this.readByteArray());
    }

    public void writeLastMessagesEntry(LastSeenMessages.Entry entry) {
        this.writeUUID(entry.getUUID());
        this.writeByteArray(entry.getLastVerifier());
    }

    public LastSeenMessages.Update readLastSeenMessagesUpdate() {
        LastSeenMessages lastSeenMessages = this.readLastSeenMessages();
        LastSeenMessages.Entry lastReceived = (LastSeenMessages.Entry)this.readOptional(PacketWrapper::readLastSeenMessagesEntry);
        return new LastSeenMessages.Update(lastSeenMessages, lastReceived);
    }

    public void writeLastSeenMessagesUpdate(LastSeenMessages.Update update) {
        this.writeLastSeenMessages(update.getLastSeenMessages());
        this.writeOptional(update.getLastReceived(), PacketWrapper::writeLastMessagesEntry);
    }

    public LastSeenMessages readLastSeenMessages() {
        List entries = this.readCollection(PacketWrapper.limitValue(ArrayList::new, 5), PacketWrapper::readLastSeenMessagesEntry);
        return new LastSeenMessages(entries);
    }

    public void writeLastSeenMessages(LastSeenMessages lastSeenMessages) {
        this.writeCollection(lastSeenMessages.getEntries(), PacketWrapper::writeLastMessagesEntry);
    }

    public BitSet readBitSet() {
        return BitSet.valueOf(this.readLongArray());
    }

    public void writeBitSet(BitSet bitSet) {
        this.writeLongArray(bitSet.toLongArray());
    }

    public FilterMask readFilterMask() {
        FilterMaskType type = FilterMaskType.getById(this.readVarInt());
        switch (type) {
            case PARTIALLY_FILTERED: {
                return new FilterMask(this.readBitSet());
            }
            case PASS_THROUGH: {
                return FilterMask.PASS_THROUGH;
            }
            case FULLY_FILTERED: {
                return FilterMask.FULLY_FILTERED;
            }
        }
        return null;
    }

    public void writeFilterMask(FilterMask filterMask) {
        this.writeVarInt(filterMask.getType().getId());
        if (filterMask.getType() == FilterMaskType.PARTIALLY_FILTERED) {
            this.writeBitSet(filterMask.getMask());
        }
    }

    public MerchantOffer readMerchantOffer() {
        ItemStack buyItemPrimary = this.readItemStack();
        ItemStack sellItem = this.readItemStack();
        ItemStack buyItemSecondary = (ItemStack)this.readOptional(PacketWrapper::readItemStack);
        boolean tradeDisabled = this.readBoolean();
        int uses = this.readInt();
        int maxUses = this.readInt();
        int xp = this.readInt();
        int specialPrice = this.readInt();
        float priceMultiplier = this.readFloat();
        int demand = this.readInt();
        MerchantOffer data = MerchantOffer.of(buyItemPrimary, buyItemSecondary, sellItem, uses, maxUses, xp, specialPrice, priceMultiplier, demand);
        if (tradeDisabled) {
            data.setUses(data.getMaxUses());
        }
        return data;
    }

    public void writeMerchantOffer(MerchantOffer data) {
        this.writeItemStack(data.getFirstInputItem());
        this.writeItemStack(data.getOutputItem());
        ItemStack buyItemSecondary = data.getSecondInputItem();
        if (buyItemSecondary != null && buyItemSecondary.isEmpty()) {
            buyItemSecondary = null;
        }
        this.writeOptional(buyItemSecondary, PacketWrapper::writeItemStack);
        this.writeBoolean(data.getUses() >= data.getMaxUses());
        this.writeInt(data.getUses());
        this.writeInt(data.getMaxUses());
        this.writeInt(data.getXp());
        this.writeInt(data.getSpecialPrice());
        this.writeFloat(data.getPriceMultiplier());
        this.writeInt(data.getDemand());
    }

    public ChatMessage_v1_19_1.ChatTypeBoundNetwork readChatTypeBoundNetwork() {
        int id = this.readVarInt();
        ChatType type = ChatTypes.getById(this.getServerVersion().toClientVersion(), id);
        Component name = this.readComponent();
        Component targetName = (Component)this.readOptional(PacketWrapper::readComponent);
        return new ChatMessage_v1_19_1.ChatTypeBoundNetwork(type, name, targetName);
    }

    public void writeChatTypeBoundNetwork(ChatMessage_v1_19_1.ChatTypeBoundNetwork chatType) {
        this.writeVarInt(chatType.getType().getId(this.getServerVersion().toClientVersion()));
        this.writeComponent(chatType.getName());
        this.writeOptional(chatType.getTargetName(), PacketWrapper::writeComponent);
    }

    public <T extends Enum<T>> EnumSet<T> readEnumSet(Class<T> enumClazz) {
        Enum[] values = (Enum[])enumClazz.getEnumConstants();
        byte[] bytes = new byte[-Math.floorDiv(-values.length, 8)];
        ByteBufHelper.readBytes(this.getBuffer(), bytes);
        BitSet bitSet = BitSet.valueOf(bytes);
        EnumSet<T> set = EnumSet.noneOf(enumClazz);
        for (int i = 0; i < values.length; ++i) {
            if (!bitSet.get(i)) continue;
            set.add(values[i]);
        }
        return set;
    }

    public <T extends Enum<T>> void writeEnumSet(EnumSet<T> set, Class<T> enumClazz) {
        Enum[] values = (Enum[])enumClazz.getEnumConstants();
        BitSet bitSet = new BitSet(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (!set.contains(values[i])) continue;
            bitSet.set(i);
        }
        this.writeBytes(Arrays.copyOf(bitSet.toByteArray(), -Math.floorDiv(-values.length, 8)));
    }

    @ApiStatus.Experimental
    public <U, V, R> U readMultiVersional(VersionComparison version, ServerVersion target, Reader<V> first, Reader<R> second) {
        if (this.serverVersion.is(version, target)) {
            return (U)first.apply(this);
        }
        return (U)second.apply(this);
    }

    @ApiStatus.Experimental
    public <V> void writeMultiVersional(VersionComparison version, ServerVersion target, V value, Writer<V> first, Writer<V> second) {
        if (this.serverVersion.is(version, target)) {
            first.accept(this, value);
        } else {
            second.accept(this, value);
        }
    }

    public <R> R readOptional(Reader<R> reader) {
        return this.readBoolean() ? (R)reader.apply(this) : null;
    }

    public <V> void writeOptional(V value, Writer<V> writer) {
        if (value != null) {
            this.writeBoolean(true);
            writer.accept(this, value);
        } else {
            this.writeBoolean(false);
        }
    }

    public <K, C extends Collection<K>> C readCollection(IntFunction<C> function, Reader<K> reader) {
        int size = this.readVarInt();
        Collection collection = (Collection)function.apply(size);
        for (int i = 0; i < size; ++i) {
            collection.add(reader.apply(this));
        }
        return (C)collection;
    }

    public <K> void writeCollection(Collection<K> collection, Writer<K> writer) {
        this.writeVarInt(collection.size());
        for (K key : collection) {
            writer.accept(this, key);
        }
    }

    public <K> List<K> readList(Reader<K> reader) {
        return this.readCollection(ArrayList::new, reader);
    }

    public <K> void writeList(List<K> list, Writer<K> writer) {
        this.writeVarInt(list.size());
        for (K key : list) {
            writer.accept(this, key);
        }
    }

    @FunctionalInterface
    public static interface Writer<T>
    extends BiConsumer<PacketWrapper<?>, T> {
    }

    @FunctionalInterface
    public static interface Reader<T>
    extends Function<PacketWrapper<?>, T> {
    }
}

