/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.updatechecker;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.AdventureSerializer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.ColorUtil;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.PEVersion;
import ac.grim.grimac.shaded.gson.JsonObject;
import ac.grim.grimac.shaded.kyori.adventure.text.format.NamedTextColor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class UpdateChecker {
    public String checkLatestReleasedVersion() {
        try {
            URLConnection connection = new URL("https://api.github.com/repos/retrooper/packetevents/releases/latest").openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.0");
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String jsonResponse = reader.readLine();
            reader.close();
            JsonObject jsonObject = AdventureSerializer.getGsonSerializer().serializer().fromJson(jsonResponse, JsonObject.class);
            return jsonObject.get("name").getAsString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse packetevents version!", e);
        }
    }

    public UpdateCheckerStatus checkForUpdate() {
        PEVersion newVersion;
        PEVersion localVersion = PacketEvents.getAPI().getVersion();
        try {
            newVersion = new PEVersion(this.checkLatestReleasedVersion());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            newVersion = null;
        }
        if (newVersion != null && localVersion.isOlderThan(newVersion)) {
            PacketEvents.getAPI().getLogManager().warn("There is an update available for packetevents! Your build: (" + ColorUtil.toString(NamedTextColor.YELLOW) + localVersion + ColorUtil.toString(NamedTextColor.WHITE) + ") | Latest released build: (" + ColorUtil.toString(NamedTextColor.GREEN) + newVersion + ColorUtil.toString(NamedTextColor.RED) + ")");
            return UpdateCheckerStatus.OUTDATED;
        }
        if (newVersion != null && localVersion.isNewerThan(newVersion)) {
            PacketEvents.getAPI().getLogManager().info("You are on a dev or pre released build of packetevents. Your build: (" + ColorUtil.toString(NamedTextColor.AQUA) + localVersion + ColorUtil.toString(NamedTextColor.WHITE) + ") | Latest released build: (" + ColorUtil.toString(NamedTextColor.DARK_AQUA) + newVersion + ColorUtil.toString(NamedTextColor.WHITE) + ")");
            return UpdateCheckerStatus.PRE_RELEASE;
        }
        if (localVersion.equals(newVersion)) {
            PacketEvents.getAPI().getLogManager().info("You are on the latest released version of packetevents. (" + ColorUtil.toString(NamedTextColor.GREEN) + newVersion + ColorUtil.toString(NamedTextColor.WHITE) + ")");
            return UpdateCheckerStatus.UP_TO_DATE;
        }
        PacketEvents.getAPI().getLogManager().warn("Something went wrong while checking for an update. Your build: (" + localVersion + ")");
        return UpdateCheckerStatus.FAILED;
    }

    public void handleUpdateCheck() {
        Thread thread = new Thread(() -> {
            PacketEvents.getAPI().getLogManager().info("Checking for an update, please wait...");
            UpdateCheckerStatus status = this.checkForUpdate();
            int waitTimeInSeconds = 5;
            int maxRetryCount = 5;
            for (int retries = 0; retries < maxRetryCount && status == UpdateCheckerStatus.FAILED; ++retries) {
                PacketEvents.getAPI().getLogManager().warn("[Checking for an update again in " + waitTimeInSeconds + " seconds...");
                try {
                    Thread.sleep((long)waitTimeInSeconds * 1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                waitTimeInSeconds *= 2;
                status = this.checkForUpdate();
                if (retries != maxRetryCount - 1) continue;
                PacketEvents.getAPI().getLogManager().warn("packetevents failed to check for an update. No longer retrying.");
                break;
            }
        }, "packetevents-update-check-thread");
        thread.start();
    }

    public static enum UpdateCheckerStatus {
        OUTDATED,
        PRE_RELEASE,
        UP_TO_DATE,
        FAILED;

    }
}

