/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.reflection;

import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Reflection {
    public static Field[] getFields(Class<?> cls) {
        Field[] declaredFields;
        for (Field f : declaredFields = cls.getDeclaredFields()) {
            f.setAccessible(true);
        }
        return declaredFields;
    }

    public static Field getField(Class<?> cls, String name) {
        for (Field f : Reflection.getFields(cls)) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getField(cls.getSuperclass(), name);
        }
        return null;
    }

    public static Field getField(Class<?> cls, Class<?> dataType, int index) {
        if (dataType == null || cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Field f : Reflection.getFields(cls)) {
            if (!dataType.isAssignableFrom(f.getType()) || currentIndex++ != index) continue;
            return f;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getField(cls.getSuperclass(), dataType, index);
        }
        return null;
    }

    public static Field getField(Class<?> cls, Class<?> dataType, int index, boolean ignoreStatic) {
        if (dataType == null || cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Field f : Reflection.getFields(cls)) {
            if (!dataType.isAssignableFrom(f.getType()) || ignoreStatic && Modifier.isStatic(f.getModifiers()) || currentIndex++ != index) continue;
            return f;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getField(cls.getSuperclass(), dataType, index);
        }
        return null;
    }

    public static Field getField(Class<?> cls, int index) {
        try {
            return Reflection.getFields(cls)[index];
        }
        catch (Exception ex) {
            if (cls.getSuperclass() != null) {
                return Reflection.getFields(cls.getSuperclass())[index];
            }
            return null;
        }
    }

    public static List<Method> getMethods(Class<?> cls, String name, Class<?> ... params) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : cls.getDeclaredMethods()) {
            if (params != null && !Arrays.equals(m.getParameterTypes(), params) || !name.equals(m.getName())) continue;
            m.setAccessible(true);
            methods.add(m);
        }
        return methods;
    }

    public static Method getMethod(Class<?> cls, int index, Class<?> ... params) {
        int currentIndex = 0;
        for (Method m : cls.getDeclaredMethods()) {
            if (params != null && !Arrays.equals(m.getParameterTypes(), params) || index != currentIndex++) continue;
            m.setAccessible(true);
            return m;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethod(cls.getSuperclass(), index, params);
        }
        return null;
    }

    public static Method getMethod(Class<?> cls, Class<?> returning, int index, Class<?> ... params) {
        int currentIndex = 0;
        for (Method m : cls.getDeclaredMethods()) {
            if (!Arrays.equals(m.getParameterTypes(), params) || returning != null && !m.getReturnType().equals(returning) || index != currentIndex++) continue;
            m.setAccessible(true);
            return m;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethod(cls.getSuperclass(), null, index, params);
        }
        return null;
    }

    public static Method getMethod(Class<?> cls, String name, Class<?> returning, Class<?> ... params) {
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().equals(name) || !Arrays.equals(m.getParameterTypes(), params) || returning != null && !m.getReturnType().equals(returning)) continue;
            m.setAccessible(true);
            return m;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethod(cls.getSuperclass(), name, null, params);
        }
        return null;
    }

    public static Method getMethod(Class<?> cls, String name, int index) {
        if (cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().equals(name) || index != currentIndex++) continue;
            m.setAccessible(true);
            return m;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethod(cls.getSuperclass(), name, index);
        }
        return null;
    }

    public static Method getMethod(Class<?> cls, Class<?> returning, int index) {
        if (cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Method m : cls.getDeclaredMethods()) {
            if (returning != null && !m.getReturnType().equals(returning) || index != currentIndex++) continue;
            m.setAccessible(true);
            return m;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethod(cls.getSuperclass(), returning, index);
        }
        return null;
    }

    public static Method getMethodCheckContainsString(Class<?> cls, String nameContainsThisStr, Class<?> returning) {
        if (cls == null) {
            return null;
        }
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().contains(nameContainsThisStr) || returning != null && !m.getReturnType().equals(returning)) continue;
            m.setAccessible(true);
            return m;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethodCheckContainsString(cls.getSuperclass(), nameContainsThisStr, returning);
        }
        return null;
    }

    public static Method getMethod(Class<?> cls, String name, Class<?> returning) {
        if (cls == null) {
            return null;
        }
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().equals(name) || returning != null && !m.getReturnType().equals(returning)) continue;
            m.setAccessible(true);
            return m;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethod(cls.getSuperclass(), name, returning);
        }
        return null;
    }

    @Nullable
    public static Class<?> getClassByNameWithoutException(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

