/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.adventure;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.adventure.StyleSerializerExtended;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.adventure.TextColorWrapper;
import ac.grim.grimac.shaded.gson.Gson;
import ac.grim.grimac.shaded.gson.TypeAdapter;
import ac.grim.grimac.shaded.gson.TypeAdapterFactory;
import ac.grim.grimac.shaded.gson.reflect.TypeToken;
import ac.grim.grimac.shaded.kyori.adventure.key.Key;
import ac.grim.grimac.shaded.kyori.adventure.text.BlockNBTComponent;
import ac.grim.grimac.shaded.kyori.adventure.text.Component;
import ac.grim.grimac.shaded.kyori.adventure.text.event.ClickEvent;
import ac.grim.grimac.shaded.kyori.adventure.text.event.HoverEvent;
import ac.grim.grimac.shaded.kyori.adventure.text.format.Style;
import ac.grim.grimac.shaded.kyori.adventure.text.format.TextColor;
import ac.grim.grimac.shaded.kyori.adventure.text.format.TextDecoration;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class SerializerFactory
implements TypeAdapterFactory {
    static Method COMPONENT_SERIALIZER_CREATE_METHOD;
    static TypeAdapter<Key> KEY_SERIALIZER_INSTANCE;
    static TypeAdapter<ClickEvent.Action> CLICK_EVENT_ACTION_SERIALIZER_INSTANCE;
    static TypeAdapter<HoverEvent.Action<?>> HOVER_EVENT_ACTION_SERIALIZER_INSTANCE;
    static Method SHOW_ITEM_SERIALIZER_CREATE_METHOD;
    static Method SHOW_ENTITY_SERIALIZER_CREATE_METHOD;
    static TypeAdapter<TextColor> TEXT_COLOR_SERIALIZER_INSTANCE;
    static TypeAdapter<TextColor> TEXT_COLOR_SERIALIZER_DOWNSAMPLE_COLOR_INSTANCE;
    static TypeAdapter<TextDecoration> TEXT_DECORATION_SERIALIZER_INSTANCE;
    static TypeAdapter<BlockNBTComponent.Pos> BLOCK_NBT_POS_SERIALIZER_INSTANCE;
    private final boolean downsampleColors;
    private final boolean emitLegacyHover;

    SerializerFactory(boolean downsampleColors, boolean emitLegacyHover) {
        this.downsampleColors = downsampleColors;
        this.emitLegacyHover = emitLegacyHover;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class<T> rawType = type.getRawType();
        if (Component.class.isAssignableFrom(rawType)) {
            return (TypeAdapter)this.invokeSafe(COMPONENT_SERIALIZER_CREATE_METHOD, gson);
        }
        if (Key.class.isAssignableFrom(rawType)) {
            return KEY_SERIALIZER_INSTANCE;
        }
        if (Style.class.isAssignableFrom(rawType)) {
            return StyleSerializerExtended.create(this.emitLegacyHover, gson);
        }
        if (ClickEvent.Action.class.isAssignableFrom(rawType)) {
            return CLICK_EVENT_ACTION_SERIALIZER_INSTANCE;
        }
        if (HoverEvent.Action.class.isAssignableFrom(rawType)) {
            return HOVER_EVENT_ACTION_SERIALIZER_INSTANCE;
        }
        if (HoverEvent.ShowItem.class.isAssignableFrom(rawType)) {
            return (TypeAdapter)this.invokeSafe(SHOW_ITEM_SERIALIZER_CREATE_METHOD, gson);
        }
        if (HoverEvent.ShowEntity.class.isAssignableFrom(rawType)) {
            return (TypeAdapter)this.invokeSafe(SHOW_ENTITY_SERIALIZER_CREATE_METHOD, gson);
        }
        if (TextColorWrapper.class.isAssignableFrom(rawType)) {
            return TextColorWrapper.Serializer.INSTANCE;
        }
        if (TextColor.class.isAssignableFrom(rawType)) {
            return this.downsampleColors ? TEXT_COLOR_SERIALIZER_DOWNSAMPLE_COLOR_INSTANCE : TEXT_COLOR_SERIALIZER_INSTANCE;
        }
        if (TextDecoration.class.isAssignableFrom(rawType)) {
            return TEXT_DECORATION_SERIALIZER_INSTANCE;
        }
        if (BlockNBTComponent.Pos.class.isAssignableFrom(rawType)) {
            return BLOCK_NBT_POS_SERIALIZER_INSTANCE;
        }
        return null;
    }

    private Object invokeSafe(Method method, Object ... params) {
        try {
            return method.invoke(null, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            Class<?> COMPONENT_SERIALIZER = Class.forName("ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.gson.ComponentSerializerImpl");
            COMPONENT_SERIALIZER_CREATE_METHOD = COMPONENT_SERIALIZER.getDeclaredMethod("create", Gson.class);
            COMPONENT_SERIALIZER_CREATE_METHOD.setAccessible(true);
            Class<?> KEY_SERIALIZER = Class.forName("ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.gson.KeySerializer");
            Field KEY_SERIALIZER_INSTANCE_FIELD = KEY_SERIALIZER.getDeclaredField("INSTANCE");
            KEY_SERIALIZER_INSTANCE_FIELD.setAccessible(true);
            KEY_SERIALIZER_INSTANCE = (TypeAdapter)KEY_SERIALIZER_INSTANCE_FIELD.get(null);
            Class<?> CLICK_EVENT_ACTION_SERIALIZER = Class.forName("ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.gson.ClickEventActionSerializer");
            Field CLICK_EVENT_ACTION_SERIALIZER_INSTANCE_FIELD = CLICK_EVENT_ACTION_SERIALIZER.getDeclaredField("INSTANCE");
            CLICK_EVENT_ACTION_SERIALIZER_INSTANCE_FIELD.setAccessible(true);
            CLICK_EVENT_ACTION_SERIALIZER_INSTANCE = (TypeAdapter)CLICK_EVENT_ACTION_SERIALIZER_INSTANCE_FIELD.get(null);
            Class<?> HOVER_EVENT_ACTION_SERIALIZER = Class.forName("ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.gson.HoverEventActionSerializer");
            Field HOVER_EVENT_ACTION_SERIALIZER_INSTANCE_FIELD = HOVER_EVENT_ACTION_SERIALIZER.getDeclaredField("INSTANCE");
            HOVER_EVENT_ACTION_SERIALIZER_INSTANCE_FIELD.setAccessible(true);
            HOVER_EVENT_ACTION_SERIALIZER_INSTANCE = (TypeAdapter)HOVER_EVENT_ACTION_SERIALIZER_INSTANCE_FIELD.get(null);
            Class<?> SHOW_ITEM_SERIALIZER = Class.forName("ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.gson.ShowItemSerializer");
            SHOW_ITEM_SERIALIZER_CREATE_METHOD = SHOW_ITEM_SERIALIZER.getDeclaredMethod("create", Gson.class);
            SHOW_ITEM_SERIALIZER_CREATE_METHOD.setAccessible(true);
            Class<?> SHOW_ENTITY_SERIALIZER = Class.forName("ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.gson.ShowEntitySerializer");
            SHOW_ENTITY_SERIALIZER_CREATE_METHOD = SHOW_ENTITY_SERIALIZER.getDeclaredMethod("create", Gson.class);
            SHOW_ENTITY_SERIALIZER_CREATE_METHOD.setAccessible(true);
            Class<?> TEXT_COLOR_SERIALIZER = Class.forName("ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.gson.TextColorSerializer");
            Field TEXT_COLOR_SERIALIZER_INSTANCE_FIELD = TEXT_COLOR_SERIALIZER.getDeclaredField("INSTANCE");
            TEXT_COLOR_SERIALIZER_INSTANCE_FIELD.setAccessible(true);
            TEXT_COLOR_SERIALIZER_INSTANCE = (TypeAdapter)TEXT_COLOR_SERIALIZER_INSTANCE_FIELD.get(null);
            Class<?> TEXT_COLOR_SERIALIZER_DOWNSAMPLE_COLOR = Class.forName("ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.gson.TextColorSerializer");
            Field TEXT_COLOR_SERIALIZER_DOWNSAMPLE_COLOR_INSTANCE_FIELD = TEXT_COLOR_SERIALIZER_DOWNSAMPLE_COLOR.getDeclaredField("DOWNSAMPLE_COLOR");
            TEXT_COLOR_SERIALIZER_DOWNSAMPLE_COLOR_INSTANCE_FIELD.setAccessible(true);
            TEXT_COLOR_SERIALIZER_DOWNSAMPLE_COLOR_INSTANCE = (TypeAdapter)TEXT_COLOR_SERIALIZER_DOWNSAMPLE_COLOR_INSTANCE_FIELD.get(null);
            Class<?> TEXT_DECORATION_SERIALIZER = Class.forName("ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.gson.TextDecorationSerializer");
            Field TEXT_DECORATION_SERIALIZER_INSTANCE_FIELD = TEXT_DECORATION_SERIALIZER.getDeclaredField("INSTANCE");
            TEXT_DECORATION_SERIALIZER_INSTANCE_FIELD.setAccessible(true);
            TEXT_DECORATION_SERIALIZER_INSTANCE = (TypeAdapter)TEXT_DECORATION_SERIALIZER_INSTANCE_FIELD.get(null);
            Class<?> BLOCK_NBT_COMPONENT_POS_SERIALIZER = Class.forName("ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.gson.BlockNBTComponentPosSerializer");
            Field BLOCK_NBT_COMPONENT_POS_SERIALIZER_INSTANCE_FIELD = BLOCK_NBT_COMPONENT_POS_SERIALIZER.getDeclaredField("INSTANCE");
            BLOCK_NBT_COMPONENT_POS_SERIALIZER_INSTANCE_FIELD.setAccessible(true);
            BLOCK_NBT_POS_SERIALIZER_INSTANCE = (TypeAdapter)BLOCK_NBT_COMPONENT_POS_SERIALIZER_INSTANCE_FIELD.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

