/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.adventure;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.stats.Statistics;
import ac.grim.grimac.shaded.gson.Gson;
import ac.grim.grimac.shaded.gson.JsonElement;
import ac.grim.grimac.shaded.gson.JsonPrimitive;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.util.Codec;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.shaded.kyori.adventure.key.Key;
import ac.grim.grimac.shaded.kyori.adventure.nbt.CompoundBinaryTag;
import ac.grim.grimac.shaded.kyori.adventure.nbt.TagStringIO;
import ac.grim.grimac.shaded.kyori.adventure.nbt.api.BinaryTagHolder;
import ac.grim.grimac.shaded.kyori.adventure.text.Component;
import ac.grim.grimac.shaded.kyori.adventure.text.TextComponent;
import ac.grim.grimac.shaded.kyori.adventure.text.event.HoverEvent;
import java.io.IOException;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HoverSerializer {
    private static final TagStringIO SNBT_IO = TagStringIO.get();
    private static final Codec<CompoundBinaryTag, String, IOException, IOException> SNBT_CODEC = Codec.codec(SNBT_IO::asCompound, SNBT_IO::asString);
    static final String ITEM_TYPE = "id";
    static final String ITEM_COUNT = "Count";
    static final String ITEM_TAG = "tag";
    static final String ENTITY_NAME = "name";
    static final String ENTITY_TYPE = "type";
    static final String ENTITY_ID = "id";
    static final Pattern LEGACY_NAME_PATTERN = Pattern.compile("([A-Z][a-z]+)([A-Z][a-z]+)?");
    private final Gson gson;

    public HoverSerializer(Gson gson) {
        this.gson = gson;
    }

    public HoverEvent.ShowItem deserializeShowItem(JsonElement input, boolean legacy) throws IOException {
        if (legacy) {
            Component component = this.gson.fromJson(input, Component.class);
            HoverSerializer.assertTextComponent(component);
            CompoundBinaryTag contents = SNBT_CODEC.decode(((TextComponent)component).content());
            CompoundBinaryTag tag = contents.getCompound(ITEM_TAG);
            return HoverEvent.ShowItem.of(Key.key(contents.getString("id")), (int)contents.getByte(ITEM_COUNT, (byte)1), tag == CompoundBinaryTag.empty() ? null : BinaryTagHolder.encode(tag, SNBT_CODEC));
        }
        return this.gson.fromJson(input, HoverEvent.ShowItem.class);
    }

    public HoverEvent.ShowEntity deserializeShowEntity(JsonElement input, Codec.Decoder<Component, String, ? extends RuntimeException> componentCodec, boolean legacy) throws IOException {
        if (legacy) {
            Component component = this.gson.fromJson(input, Component.class);
            HoverSerializer.assertTextComponent(component);
            CompoundBinaryTag contents = SNBT_CODEC.decode(((TextComponent)component).content());
            String type = contents.getString(ENTITY_TYPE);
            Matcher matcher = LEGACY_NAME_PATTERN.matcher(type);
            if (matcher.matches()) {
                StringJoiner joiner = new StringJoiner("_");
                joiner.add(matcher.group(1));
                if (matcher.group(2) != null) {
                    joiner.add(matcher.group(2));
                }
                type = joiner.toString().toLowerCase(Locale.ROOT);
            }
            return HoverEvent.ShowEntity.of(Key.key(type), UUID.fromString(contents.getString("id")), componentCodec.decode(contents.getString(ENTITY_NAME)));
        }
        return this.gson.fromJson(input, HoverEvent.ShowEntity.class);
    }

    public Component deserializeShowAchievement(JsonElement input) throws IOException {
        HoverSerializer.assertStringValue(input);
        return Statistics.getById(input.getAsString()).display();
    }

    private static void assertStringValue(JsonElement element) {
        if (!element.isJsonPrimitive() || !((JsonPrimitive)element).isString()) {
            throw new IllegalArgumentException("Legacy events must be single Component instances");
        }
    }

    private static void assertTextComponent(Component component) {
        if (!(component instanceof TextComponent) || !component.children().isEmpty()) {
            throw new IllegalArgumentException("Legacy events must be single Component instances");
        }
    }

    @NotNull
    public Component serializeShowItem( @NotNull HoverEvent.ShowItem input) throws IOException {
        CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("id", input.item().asString())).putByte(ITEM_COUNT, (byte)input.count());
        BinaryTagHolder nbt = input.nbt();
        if (nbt != null) {
            builder.put(ITEM_TAG, nbt.get(SNBT_CODEC));
        }
        return Component.text(SNBT_CODEC.encode(builder.build()));
    }

    @NotNull
    public Component serializeShowEntity( @NotNull HoverEvent.ShowEntity input, Codec.Encoder<Component, String, ? extends RuntimeException> componentCodec) throws IOException {
        CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("id", input.id().toString())).putString(ENTITY_TYPE, input.type().asString());
        Component name = input.name();
        if (name != null) {
            builder.putString(ENTITY_NAME, componentCodec.encode(name));
        }
        return Component.text(SNBT_CODEC.encode(builder.build()));
    }
}

