/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.adventure;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.adventure.SerializerFactory;
import ac.grim.grimac.shaded.gson.Gson;
import ac.grim.grimac.shaded.gson.GsonBuilder;
import ac.grim.grimac.shaded.gson.JsonElement;
import ac.grim.grimac.shaded.gson.JsonParseException;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.gson.GsonComponentSerializer;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.shaded.kyori.adventure.text.Component;
import java.util.function.UnaryOperator;

public class GsonComponentSerializerExtended
implements GsonComponentSerializer {
    private final Gson serializer;
    private final UnaryOperator<GsonBuilder> populator;
    private final boolean downsampleColor;
    private final boolean emitLegacyHover;

    public GsonComponentSerializerExtended(boolean downsampleColor, boolean emitLegacyHover) {
        this.downsampleColor = downsampleColor;
        this.emitLegacyHover = emitLegacyHover;
        this.populator = builder -> {
            builder.registerTypeAdapterFactory(new SerializerFactory(downsampleColor, emitLegacyHover));
            return builder;
        };
        this.serializer = ((GsonBuilder)this.populator.apply(new GsonBuilder())).create();
    }

    @Override
    @NotNull
    public Gson serializer() {
        return this.serializer;
    }

    @Override
    @NotNull
    public UnaryOperator<GsonBuilder> populator() {
        return this.populator;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String string) {
        Component component = this.serializer().fromJson(string, Component.class);
        if (component == null) {
            throw new JsonParseException("Don't know how to turn " + string + " into a Component");
        }
        return component;
    }

    @Override
    @Nullable
    public Component deserializeOr(@Nullable String input, @Nullable Component fallback) {
        if (input == null) {
            return fallback;
        }
        Component component = this.serializer().fromJson(input, Component.class);
        if (component == null) {
            return fallback;
        }
        return component;
    }

    @Override
    @NotNull
    public String serialize(@NotNull Component component) {
        return this.serializer().toJson(component);
    }

    @Override
    @NotNull
    public Component deserializeFromTree(@NotNull JsonElement input) {
        Component component = this.serializer().fromJson(input, Component.class);
        if (component == null) {
            throw new JsonParseException("Don't know how to turn " + input + " into a Component");
        }
        return component;
    }

    @Override
    @NotNull
    public JsonElement serializeToTree(@NotNull Component component) {
        return this.serializer().toJsonTree(component);
    }

    @Override
    @NotNull
    public GsonComponentSerializer.Builder toBuilder() {
        return null;
    }
}

