/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.util;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.adventure.GsonComponentSerializerExtended;
import ac.grim.grimac.shaded.gson.JsonElement;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.gson.GsonComponentSerializer;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.adventure.serializer.legacy.LegacyComponentSerializer;
import ac.grim.grimac.shaded.kyori.adventure.text.Component;

public class AdventureSerializer {
    private static GsonComponentSerializer GSON;
    private static final LegacyComponentSerializer LEGACY;

    public static String asVanilla(Component component) {
        return LEGACY.serialize(component);
    }

    public static Component fromLegacyFormat(String legacyMessage) {
        return LEGACY.deserialize(legacyMessage);
    }

    public static GsonComponentSerializer getGsonSerializer() {
        if (GSON == null) {
            ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
            GSON = new GsonComponentSerializerExtended(version.isOlderThan(ServerVersion.V_1_16), version.isOlderThanOrEquals(ServerVersion.V_1_12_2));
        }
        return GSON;
    }

    public static LegacyComponentSerializer getLegacyGsonSerializer() {
        return LEGACY;
    }

    public static Component parseComponent(String json) {
        return AdventureSerializer.getGsonSerializer().deserialize(json);
    }

    public static Component parseJsonTree(JsonElement json) {
        return AdventureSerializer.getGsonSerializer().deserializeFromTree(json);
    }

    public static String toJson(Component component) {
        return (String)AdventureSerializer.getGsonSerializer().serialize(component);
    }

    public static JsonElement toJsonTree(Component component) {
        return AdventureSerializer.getGsonSerializer().serializeToTree(component);
    }

    static {
        LEGACY = LegacyComponentSerializer.builder().build();
    }
}

