/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.chunk.impl.v_1_18;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.stream.NetStreamInput;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.stream.NetStreamOutput;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.chunk.BaseChunk;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.chunk.palette.DataPalette;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.chunk.palette.PaletteType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;

public class Chunk_v1_18
implements BaseChunk {
    private static final int AIR = 0;
    private int blockCount;
    @NotNull
    private final DataPalette chunkData;
    @NotNull
    private final DataPalette biomeData;

    public Chunk_v1_18() {
        this(0, DataPalette.createForChunk(), DataPalette.createForBiome());
    }

    public Chunk_v1_18(int blockCount, @NotNull DataPalette chunkData, @NotNull DataPalette biomeData) {
        this.blockCount = blockCount;
        this.chunkData = chunkData;
        this.biomeData = biomeData;
    }

    public static Chunk_v1_18 read(NetStreamInput in) {
        short blockCount = in.readShort();
        DataPalette chunkPalette = DataPalette.read(in, PaletteType.CHUNK);
        DataPalette biomePalette = DataPalette.read(in, PaletteType.BIOME);
        return new Chunk_v1_18(blockCount, chunkPalette, biomePalette);
    }

    public static void write(NetStreamOutput out, Chunk_v1_18 section) {
        out.writeShort(section.blockCount);
        DataPalette.write(out, section.chunkData);
        DataPalette.write(out, section.biomeData);
    }

    @Override
    public WrappedBlockState get(ClientVersion version, int x, int y, int z) {
        return WrappedBlockState.getByGlobalId(version, this.chunkData.get(x, y, z));
    }

    @Override
    public void set(ClientVersion version, int x, int y, int z, int state) {
        int curr = this.chunkData.set(x, y, z, state);
        if (state != 0 && curr == 0) {
            ++this.blockCount;
        } else if (state == 0 && curr != 0) {
            --this.blockCount;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.blockCount == 0;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void setBlockCount(int blockCount) {
        this.blockCount = blockCount;
    }

    @NotNull
    public DataPalette getChunkData() {
        return this.chunkData;
    }

    @NotNull
    public DataPalette getBiomeData() {
        return this.biomeData;
    }
}

