/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;

public enum EquipmentSlot {
    MAIN_HAND(0),
    OFF_HAND(0),
    BOOTS(1),
    LEGGINGS(2),
    CHEST_PLATE(3),
    HELMET(4);

    private static final EquipmentSlot[] VALUES;
    private final byte legacyId;

    private EquipmentSlot(int legacyId) {
        this.legacyId = (byte)legacyId;
    }

    public int getId(ServerVersion version) {
        if (version.isOlderThan(ServerVersion.V_1_9)) {
            return this.legacyId;
        }
        return this.ordinal();
    }

    @Nullable
    public static EquipmentSlot getById(ServerVersion version, int id) {
        for (EquipmentSlot slot : VALUES) {
            if (slot.getId(version) != id) continue;
            return slot;
        }
        return null;
    }

    static {
        VALUES = EquipmentSlot.values();
    }
}

