/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.enchantment.type;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.enchantment.type.EnchantmentType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.resources.ResourceLocation;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.TypesBuilder;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.TypesBuilderData;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;

public class EnchantmentTypes {
    private static final Map<String, EnchantmentType> ENCHANTMENT_TYPE_MAPPINGS = new HashMap<String, EnchantmentType>();
    private static final Map<Byte, Map<Integer, EnchantmentType>> ENCHANTMENT_TYPE_ID_MAPPINGS = new HashMap<Byte, Map<Integer, EnchantmentType>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("enchantment/enchantment_type_mappings", ClientVersion.V_1_12, ClientVersion.V_1_13, ClientVersion.V_1_14, ClientVersion.V_1_16, ClientVersion.V_1_19);
    public static final EnchantmentType ALL_DAMAGE_PROTECTION = EnchantmentTypes.define("protection");
    public static final EnchantmentType FIRE_PROTECTION = EnchantmentTypes.define("fire_protection");
    public static final EnchantmentType FALL_PROTECTION = EnchantmentTypes.define("feather_falling");
    public static final EnchantmentType BLAST_PROTECTION = EnchantmentTypes.define("blast_protection");
    public static final EnchantmentType PROJECTILE_PROTECTION = EnchantmentTypes.define("projectile_protection");
    public static final EnchantmentType RESPIRATION = EnchantmentTypes.define("respiration");
    public static final EnchantmentType AQUA_AFFINITY = EnchantmentTypes.define("aqua_affinity");
    public static final EnchantmentType THORNS = EnchantmentTypes.define("thorns");
    public static final EnchantmentType DEPTH_STRIDER = EnchantmentTypes.define("depth_strider");
    public static final EnchantmentType FROST_WALKER = EnchantmentTypes.define("frost_walker");
    public static final EnchantmentType BINDING_CURSE = EnchantmentTypes.define("binding_curse");
    public static final EnchantmentType SOUL_SPEED = EnchantmentTypes.define("soul_speed");
    public static final EnchantmentType SWIFT_SNEAK = EnchantmentTypes.define("swift_sneak");
    public static final EnchantmentType SHARPNESS = EnchantmentTypes.define("sharpness");
    public static final EnchantmentType SMITE = EnchantmentTypes.define("smite");
    public static final EnchantmentType BANE_OF_ARTHROPODS = EnchantmentTypes.define("bane_of_arthropods");
    public static final EnchantmentType KNOCKBACK = EnchantmentTypes.define("knockback");
    public static final EnchantmentType FIRE_ASPECT = EnchantmentTypes.define("fire_aspect");
    public static final EnchantmentType MOB_LOOTING = EnchantmentTypes.define("looting");
    public static final EnchantmentType SWEEPING_EDGE = EnchantmentTypes.define("sweeping");
    public static final EnchantmentType BLOCK_EFFICIENCY = EnchantmentTypes.define("efficiency");
    public static final EnchantmentType SILK_TOUCH = EnchantmentTypes.define("silk_touch");
    public static final EnchantmentType UNBREAKING = EnchantmentTypes.define("unbreaking");
    public static final EnchantmentType BLOCK_FORTUNE = EnchantmentTypes.define("fortune");
    public static final EnchantmentType POWER_ARROWS = EnchantmentTypes.define("power");
    public static final EnchantmentType PUNCH_ARROWS = EnchantmentTypes.define("punch");
    public static final EnchantmentType FLAMING_ARROWS = EnchantmentTypes.define("flame");
    public static final EnchantmentType INFINITY_ARROWS = EnchantmentTypes.define("infinity");
    public static final EnchantmentType FISHING_LUCK = EnchantmentTypes.define("luck_of_the_sea");
    public static final EnchantmentType FISHING_SPEED = EnchantmentTypes.define("lure");
    public static final EnchantmentType LOYALTY = EnchantmentTypes.define("loyalty");
    public static final EnchantmentType IMPALING = EnchantmentTypes.define("impaling");
    public static final EnchantmentType RIPTIDE = EnchantmentTypes.define("riptide");
    public static final EnchantmentType CHANNELING = EnchantmentTypes.define("channeling");
    public static final EnchantmentType MULTISHOT = EnchantmentTypes.define("multishot");
    public static final EnchantmentType QUICK_CHARGE = EnchantmentTypes.define("quick_charge");
    public static final EnchantmentType PIERCING = EnchantmentTypes.define("piercing");
    public static final EnchantmentType MENDING = EnchantmentTypes.define("mending");
    public static final EnchantmentType VANISHING_CURSE = EnchantmentTypes.define("vanishing_curse");

    public static EnchantmentType define(String key) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        EnchantmentType enchantmentType = new EnchantmentType(){
            private final int[] ids;
            {
                this.ids = data.getData();
            }

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                int index = TYPES_BUILDER.getDataIndex(version);
                return this.ids[index];
            }

            public boolean equals(Object obj) {
                if (obj instanceof EnchantmentType) {
                    return this.getName() == ((EnchantmentType)obj).getName();
                }
                return false;
            }
        };
        ENCHANTMENT_TYPE_MAPPINGS.put(enchantmentType.getName().toString(), enchantmentType);
        for (ClientVersion version : TYPES_BUILDER.getVersions()) {
            int index = TYPES_BUILDER.getDataIndex(version);
            Map typeIdMap = ENCHANTMENT_TYPE_ID_MAPPINGS.computeIfAbsent((byte)index, k -> new HashMap());
            typeIdMap.put(enchantmentType.getId(version), enchantmentType);
        }
        return enchantmentType;
    }

    @Nullable
    public static EnchantmentType getByName(String name) {
        return ENCHANTMENT_TYPE_MAPPINGS.get(name);
    }

    @Nullable
    public static EnchantmentType getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, EnchantmentType> typeIdMap = ENCHANTMENT_TYPE_ID_MAPPINGS.get((byte)index);
        return typeIdMap.get(id);
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

