/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.chat;

import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class LastSeenMessages {
    public static final LastSeenMessages EMPTY = new LastSeenMessages(new ArrayList<Entry>());
    private final List<Entry> entries;

    public LastSeenMessages(List<Entry> entries) {
        this.entries = entries;
    }

    public void updateHash(DataOutput output) throws IOException {
        for (Entry entry : this.entries) {
            UUID uuid = entry.getUUID();
            byte[] lastVerifier = entry.getLastVerifier();
            output.writeByte(70);
            output.writeLong(uuid.getMostSignificantBits());
            output.writeLong(uuid.getLeastSignificantBits());
            output.write(lastVerifier);
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public static class Update {
        private final LastSeenMessages lastSeenMessages;
        @Nullable
        private final Entry lastReceived;

        public Update(LastSeenMessages lastSeenMessages, @Nullable Entry lastReceived) {
            this.lastSeenMessages = lastSeenMessages;
            this.lastReceived = lastReceived;
        }

        public LastSeenMessages getLastSeenMessages() {
            return this.lastSeenMessages;
        }

        @Nullable
        public Entry getLastReceived() {
            return this.lastReceived;
        }
    }

    public static class Entry {
        private final UUID uuid;
        private final byte[] signature;

        public Entry(UUID uuid, byte[] lastVerifier) {
            this.uuid = uuid;
            this.signature = lastVerifier;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public byte[] getLastVerifier() {
            return this.signature;
        }
    }
}

