/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.event;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.CancellableEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PlayerEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.UserEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.exception.PacketProcessException;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.netty.buffer.UnpooledByteBufAllocationHelper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.ConnectionState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.PacketSide;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.User;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public abstract class ProtocolPacketEvent<T>
extends PacketEvent
implements PlayerEvent<T>,
CancellableEvent,
UserEvent {
    private final Object channel;
    private final ConnectionState connectionState;
    private final User user;
    private final T player;
    private Object byteBuf;
    private final int packetID;
    private final PacketTypeCommon packetType;
    private ServerVersion serverVersion;
    private boolean cancel;
    private PacketWrapper<?> lastUsedWrapper;
    private List<Runnable> postTasks = null;
    private boolean cloned;

    public ProtocolPacketEvent(PacketSide packetSide, Object channel, User user, T player, Object byteBuf, boolean autoProtocolTranslation) throws PacketProcessException {
        this.channel = channel;
        this.user = user;
        this.player = player;
        this.serverVersion = autoProtocolTranslation || user.getClientVersion() == null ? PacketEvents.getAPI().getServerManager().getVersion() : user.getClientVersion().toServerVersion();
        this.byteBuf = byteBuf;
        int size = ByteBufHelper.readableBytes(byteBuf);
        if (size == 0) {
            throw new PacketProcessException("Trying to process a packet, but it has no content. (Size=0)");
        }
        try {
            this.packetID = ByteBufHelper.readVarInt(byteBuf);
        }
        catch (Exception e) {
            throw new PacketProcessException("Failed to read the Packet ID of a packet. (Size: " + size + ")");
        }
        ClientVersion version = this.serverVersion.toClientVersion();
        this.packetType = PacketType.getById(packetSide, user.getConnectionState(), version, this.packetID);
        if (this.packetType == null) {
            throw new PacketProcessException("Failed to map the Packet ID " + this.packetID + " to a PacketType constant. Bound: " + (Object)((Object)packetSide.getOpposite()) + ", Connection state: " + (Object)((Object)user.getConnectionState()) + ", Server version: " + this.serverVersion.getReleaseName());
        }
        this.connectionState = user.getConnectionState();
    }

    public ProtocolPacketEvent(int packetID, PacketTypeCommon packetType, ServerVersion serverVersion, Object channel, User user, T player, Object byteBuf) {
        this.channel = channel;
        this.user = user;
        this.player = player;
        this.serverVersion = serverVersion;
        this.byteBuf = byteBuf;
        this.packetID = packetID;
        this.packetType = packetType;
        this.connectionState = user.getConnectionState();
        this.cloned = true;
    }

    public boolean isClone() {
        return this.cloned;
    }

    public Object getChannel() {
        return this.channel;
    }

    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)ChannelHelper.remoteAddress(this.channel);
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public T getPlayer() {
        return this.player;
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    @Deprecated
    public ClientVersion getClientVersion() {
        return this.user.getClientVersion();
    }

    @Deprecated
    public void setClientVersion(@NotNull ClientVersion clientVersion) {
        PacketEvents.getAPI().getLogManager().debug("Setting client version with deprecated method " + clientVersion.getReleaseName());
        this.user.setClientVersion(clientVersion);
    }

    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(@NotNull ServerVersion serverVersion) {
        this.serverVersion = serverVersion;
    }

    public Object getByteBuf() {
        return this.byteBuf;
    }

    public void setByteBuf(Object byteBuf) {
        this.byteBuf = byteBuf;
    }

    @Deprecated
    public int getPacketId() {
        return this.packetID;
    }

    public PacketTypeCommon getPacketType() {
        return this.packetType;
    }

    @Deprecated
    public String getPacketName() {
        return ((Enum)((Object)this.packetType)).name();
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public void setCancelled(boolean val) {
        this.cancel = val;
    }

    @Nullable
    public PacketWrapper<?> getLastUsedWrapper() {
        return this.lastUsedWrapper;
    }

    public void setLastUsedWrapper(@Nullable PacketWrapper<?> lastUsedWrapper) {
        this.lastUsedWrapper = lastUsedWrapper;
    }

    public List<Runnable> getPostTasks() {
        if (this.postTasks == null) {
            this.postTasks = new ArrayList<Runnable>();
        }
        return this.postTasks;
    }

    public boolean hasPostTasks() {
        return this.postTasks != null && !this.postTasks.isEmpty();
    }

    public ProtocolPacketEvent<?> clone() {
        return this instanceof PacketReceiveEvent ? ((PacketReceiveEvent)this).clone() : ((PacketSendEvent)this).clone();
    }

    public void cleanUp() {
        if (this.isClone()) {
            ByteBufHelper.release(this.byteBuf);
        }
    }

    public Object getFullBufferClone() {
        byte[] data = ByteBufHelper.copyBytes(this.getByteBuf());
        Object buffer = UnpooledByteBufAllocationHelper.buffer();
        ByteBufHelper.writeVarInt(buffer, this.getPacketId());
        ByteBufHelper.writeBytes(buffer, data);
        return buffer;
    }
}

