/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.event;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketListener;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketListenerAbstract;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketListenerCommon;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketListenerPriority;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.ProtocolPacketEvent;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class EventManager {
    private final Map<Byte, HashSet<PacketListenerCommon>> listenersMap = new ConcurrentHashMap<Byte, HashSet<PacketListenerCommon>>();

    public void callEvent(PacketEvent event) {
        this.callEvent(event, null);
    }

    public void callEvent(PacketEvent event, @Nullable Runnable postCallListenerAction) {
        for (byte priority = PacketListenerPriority.LOWEST.getId(); priority <= PacketListenerPriority.MONITOR.getId(); priority = (byte)(priority + 1)) {
            HashSet<PacketListenerCommon> listeners = this.listenersMap.get(priority);
            if (listeners == null) continue;
            for (PacketListenerCommon listener : listeners) {
                try {
                    event.call(listener);
                }
                catch (Throwable t) {
                    PacketEvents.getAPI().getLogger().log(Level.WARNING, "PacketEvents caught an unhandled exception while calling your listener.", t);
                }
                if (postCallListenerAction == null) continue;
                postCallListenerAction.run();
            }
        }
        if (event instanceof ProtocolPacketEvent && PacketEvents.getAPI().getSettings().shouldListenersReadOnly()) {
            ((ProtocolPacketEvent)event).setLastUsedWrapper(null);
        }
    }

    public PacketListenerCommon registerListener(PacketListener listener, PacketListenerPriority priority) {
        PacketListenerAbstract packetListenerAbstract = listener.asAbstract(priority);
        return this.registerListener(packetListenerAbstract);
    }

    public PacketListenerCommon registerListener(PacketListenerCommon listener) {
        byte priority = listener.getPriority().getId();
        HashSet<PacketListenerCommon> listenerSet = this.listenersMap.get(priority);
        if (listenerSet == null) {
            listenerSet = new HashSet();
        }
        listenerSet.add(listener);
        this.listenersMap.put(priority, listenerSet);
        return listener;
    }

    public PacketListenerCommon[] registerListeners(PacketListenerCommon ... listeners) {
        for (PacketListenerCommon listener : listeners) {
            this.registerListener(listener);
        }
        return listeners;
    }

    public void unregisterListener(PacketListenerCommon listener) {
        HashSet<PacketListenerCommon> listenerSet = this.listenersMap.get(listener.getPriority().getId());
        if (listenerSet == null) {
            return;
        }
        listenerSet.remove(listener);
    }

    public void unregisterListeners(PacketListenerCommon ... listeners) {
        for (PacketListenerCommon listener : listeners) {
            this.unregisterListener(listener);
        }
    }

    public void unregisterAllListeners() {
        this.listenersMap.clear();
    }
}

