/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.predictionengine.predictions.rideable;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.predictionengine.predictions.PredictionEngine;
import ac.grim.grimac.predictionengine.predictions.PredictionEngineNormal;
import ac.grim.grimac.utils.data.VectorData;
import ac.grim.grimac.utils.data.packetentity.PacketEntityHorse;
import ac.grim.grimac.utils.nmsutil.JumpPower;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.util.Vector;

public class PredictionEngineRideableUtils {
    public static Set<VectorData> handleJumps(GrimPlayer player, Set<VectorData> possibleVectors) {
        if (!(player.compensatedEntities.getSelf().getRiding() instanceof PacketEntityHorse)) {
            return possibleVectors;
        }
        PacketEntityHorse horse = (PacketEntityHorse)player.compensatedEntities.getSelf().getRiding();
        float f = player.vehicleData.vehicleHorizontal * 0.5f;
        float f1 = player.vehicleData.vehicleForward;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        if (player.vehicleData.horseJump > 0.0f && !player.vehicleData.horseJumping && player.lastOnGround) {
            double d0 = horse.jumpStrength * (double)player.vehicleData.horseJump * (double)JumpPower.getPlayerJumpFactor(player);
            double d1 = player.compensatedEntities.getJumpAmplifier() != null ? d0 + (double)((float)(player.compensatedEntities.getJumpAmplifier() + 1) * 0.1f) : d0;
            player.vehicleData.horseJumping = true;
            float f2 = player.trigHandler.sin(player.xRot * ((float)Math.PI / 180));
            float f3 = player.trigHandler.cos(player.xRot * ((float)Math.PI / 180));
            for (VectorData vectorData : possibleVectors) {
                vectorData.vector.setY(d1);
                if (!(f1 > 0.0f)) continue;
                vectorData.vector.add(new Vector((double)(-0.4f * f2 * player.vehicleData.horseJump), 0.0, (double)(0.4f * f3 * player.vehicleData.horseJump)));
            }
            player.vehicleData.horseJump = 0.0f;
        }
        if (player.lastOnGround) {
            player.vehicleData.horseJump = 0.0f;
            player.vehicleData.horseJumping = false;
        }
        return possibleVectors;
    }

    public static List<VectorData> applyInputsToVelocityPossibilities(Vector movementVector, GrimPlayer player, Set<VectorData> possibleVectors, float speed) {
        ArrayList<VectorData> returnVectors = new ArrayList<VectorData>();
        for (VectorData possibleLastTickOutput : possibleVectors) {
            VectorData result = new VectorData(possibleLastTickOutput.vector.clone().add(new PredictionEngine().getMovementResultFromInput(player, movementVector, speed, player.xRot)), possibleLastTickOutput, VectorData.VectorType.InputResult);
            result = result.returnNewModified(result.vector.clone().multiply(player.stuckSpeedMultiplier), VectorData.VectorType.StuckMultiplier);
            result = result.returnNewModified(new PredictionEngineNormal().handleOnClimbable(result.vector.clone(), player), VectorData.VectorType.Climbable);
            returnVectors.add(result);
            result = new VectorData(possibleLastTickOutput.vector.clone(), possibleLastTickOutput, VectorData.VectorType.InputResult);
            result = result.returnNewModified(result.vector.clone().multiply(player.stuckSpeedMultiplier), VectorData.VectorType.StuckMultiplier);
            result = result.returnNewModified(new PredictionEngineNormal().handleOnClimbable(result.vector.clone(), player), VectorData.VectorType.Climbable);
            returnVectors.add(result);
        }
        return returnVectors;
    }
}

