/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.predictionengine.predictions;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.predictionengine.predictions.PredictionEngine;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.utils.data.VectorData;
import ac.grim.grimac.utils.enums.FluidTag;
import ac.grim.grimac.utils.nmsutil.Collisions;
import ac.grim.grimac.utils.nmsutil.FluidFallingAdjustedMovement;
import ac.grim.grimac.utils.nmsutil.ReachUtils;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.util.Vector;

public class PredictionEngineWater
extends PredictionEngine {
    boolean isFalling;
    double playerGravity;
    float swimmingSpeed;
    float swimmingFriction;
    double lastY;

    public static void staticVectorEndOfTick(GrimPlayer player, Vector vector, float swimmingFriction, double playerGravity, boolean isFalling) {
        vector.multiply(new Vector(swimmingFriction, 0.8f, swimmingFriction));
        Vector fluidVector = FluidFallingAdjustedMovement.getFluidFallingAdjustedMovement(player, playerGravity, isFalling, vector);
        vector.setX(fluidVector.getX());
        vector.setY(fluidVector.getY());
        vector.setZ(fluidVector.getZ());
    }

    public static Set<VectorData> transformSwimmingVectors(GrimPlayer player, Set<VectorData> base) {
        HashSet<VectorData> swimmingVelocities = new HashSet<VectorData>();
        if ((player.wasEyeInWater || player.fluidOnEyes == FluidTag.WATER || player.isSwimming || player.wasSwimming) && player.compensatedEntities.getSelf().getRiding() == null) {
            for (VectorData vector : base) {
                double d = ReachUtils.getLook(player, player.xRot, player.yRot).getY();
                double d5 = d < -0.2 ? 0.085 : 0.06;
                swimmingVelocities.add(vector.returnNewModified(new Vector(vector.vector.getX(), vector.vector.getY() + (d - vector.vector.getY()) * d5, vector.vector.getZ()), VectorData.VectorType.SwimmingSpace));
                swimmingVelocities.add(vector.returnNewModified(vector.vector, VectorData.VectorType.SurfaceSwimming));
            }
            return swimmingVelocities;
        }
        return base;
    }

    public void guessBestMovement(float swimmingSpeed, GrimPlayer player, boolean isFalling, double playerGravity, float swimmingFriction, double lastY) {
        this.isFalling = isFalling;
        this.playerGravity = playerGravity;
        this.swimmingSpeed = swimmingSpeed;
        this.swimmingFriction = swimmingFriction;
        this.lastY = lastY;
        super.guessBestMovement(swimmingSpeed, player);
    }

    @Override
    public void addJumpsToPossibilities(GrimPlayer player, Set<VectorData> existingVelocities) {
        for (VectorData vector : new HashSet<VectorData>(existingVelocities)) {
            existingVelocities.add(vector.returnNewModified(vector.vector.clone().add(new Vector(0.0f, 0.04f, 0.0f)), VectorData.VectorType.Jump));
            if (!player.slightlyTouchingWater || !player.lastOnGround || player.onGround) continue;
            Vector withJump = vector.vector.clone();
            super.doJump(player, withJump);
            existingVelocities.add(new VectorData(withJump, vector, VectorData.VectorType.Jump));
        }
    }

    @Override
    public void endOfTick(GrimPlayer player, double playerGravity) {
        super.endOfTick(player, playerGravity);
        for (VectorData vector : player.getPossibleVelocitiesMinusKnockback()) {
            PredictionEngineWater.staticVectorEndOfTick(player, vector.vector, this.swimmingFriction, playerGravity, this.isFalling);
        }
    }

    @Override
    public Set<VectorData> fetchPossibleStartTickVectors(GrimPlayer player) {
        if (player.lastWasClimbing == 0.0 && player.pointThreeEstimator.isNearClimbable() && (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14) || !Collisions.isEmpty(player, player.boundingBox.copy().expand(player.clientVelocity.getX(), 0.0, player.clientVelocity.getZ()).expand(0.5, -1.0E-7, 0.5)))) {
            player.lastWasClimbing = FluidFallingAdjustedMovement.getFluidFallingAdjustedMovement(player, this.playerGravity, this.isFalling, player.clientVelocity.clone().setY(0.1600000023841858)).getY();
        }
        Set<VectorData> baseVelocities = super.fetchPossibleStartTickVectors(player);
        return PredictionEngineWater.transformSwimmingVectors(player, baseVelocities);
    }
}

