/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.predictionengine.predictions;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.predictionengine.predictions.PredictionEngine;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.utils.data.VectorData;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.nmsutil.Collisions;
import ac.grim.grimac.utils.nmsutil.JumpPower;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.util.Vector;

public class PredictionEngineNormal
extends PredictionEngine {
    public static void staticVectorEndOfTick(GrimPlayer player, Vector vector) {
        double d9 = vector.getY();
        if (player.compensatedEntities.getLevitationAmplifier() != null) {
            d9 += (0.05 * (double)(player.compensatedEntities.getLevitationAmplifier() + 1) - vector.getY()) * 0.2;
            player.fallDistance = 0.0;
        } else if (player.hasGravity) {
            d9 -= player.gravity;
        }
        vector.setX(vector.getX() * (double)player.friction);
        vector.setY(d9 * (double)0.98f);
        vector.setZ(vector.getZ() * (double)player.friction);
    }

    @Override
    public void addJumpsToPossibilities(GrimPlayer player, Set<VectorData> existingVelocities) {
        for (VectorData vector : new HashSet<VectorData>(existingVelocities)) {
            Vector jump = vector.vector.clone();
            if (!player.isFlying) {
                if ((player.compensatedEntities.getJumpAmplifier() == null || player.compensatedEntities.getJumpAmplifier() >= 0) && player.onGround || !player.lastOnGround) {
                    return;
                }
                JumpPower.jumpFromGround(player, jump);
            } else {
                jump.add(new Vector(0.0f, player.flySpeed * 3.0f, 0.0f));
                if (!player.wasFlying) {
                    Vector edgeCaseJump = jump.clone();
                    JumpPower.jumpFromGround(player, edgeCaseJump);
                    existingVelocities.add(vector.returnNewModified(edgeCaseJump, VectorData.VectorType.Jump));
                }
            }
            existingVelocities.add(vector.returnNewModified(jump, VectorData.VectorType.Jump));
        }
    }

    @Override
    public void endOfTick(GrimPlayer player, double d) {
        super.endOfTick(player, d);
        boolean walkingOnPowderSnow = false;
        if (!player.compensatedEntities.getSelf().inVehicle() && player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_17) && player.compensatedWorld.getStateTypeAt(player.x, player.y, player.z) == StateTypes.POWDER_SNOW) {
            ItemStack boots = player.getInventory().getBoots();
            walkingOnPowderSnow = boots != null && boots.getType() == ItemTypes.LEATHER_BOOTS;
        }
        player.isClimbing = Collisions.onClimbable(player, player.x, player.y, player.z);
        if (player.lastWasClimbing == 0.0 && (player.pointThreeEstimator.isNearClimbable() || player.isClimbing) && (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14) || !Collisions.isEmpty(player, player.boundingBox.copy().expand(player.clientVelocity.getX(), 0.0, player.clientVelocity.getZ()).expand(0.5, -1.0E-7, 0.5))) || walkingOnPowderSnow) {
            Vector ladder = player.clientVelocity.clone().setY(0.2);
            PredictionEngineNormal.staticVectorEndOfTick(player, ladder);
            player.lastWasClimbing = ladder.getY();
        }
        for (VectorData vector : player.getPossibleVelocitiesMinusKnockback()) {
            PredictionEngineNormal.staticVectorEndOfTick(player, vector.vector);
        }
    }

    @Override
    public Vector handleOnClimbable(Vector vector, GrimPlayer player) {
        if (player.isClimbing) {
            player.fallDistance = 0.0;
            vector.setX(GrimMath.clamp(vector.getX(), -0.15f, 0.15f));
            vector.setZ(GrimMath.clamp(vector.getZ(), -0.15f, 0.15f));
            vector.setY(Math.max(vector.getY(), (double)-0.15f));
            if (vector.getY() < 0.0 && player.compensatedWorld.getStateTypeAt(player.lastX, player.lastY, player.lastZ) != StateTypes.SCAFFOLDING && player.isSneaking && !player.isFlying) {
                vector.setY(0.0);
            }
        }
        return vector;
    }
}

