/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.predictionengine.predictions;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.predictionengine.predictions.PredictionEngine;
import ac.grim.grimac.predictionengine.predictions.PredictionEngineNormal;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.utils.data.VectorData;
import ac.grim.grimac.utils.nmsutil.ReachUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.util.Vector;

public class PredictionEngineElytra
extends PredictionEngine {
    @Override
    public List<VectorData> applyInputsToVelocityPossibilities(GrimPlayer player, Set<VectorData> possibleVectors, float speed) {
        ArrayList<VectorData> results = new ArrayList<VectorData>();
        Vector currentLook = ReachUtils.getLook(player, player.xRot, player.yRot);
        for (VectorData data : possibleVectors) {
            Vector elytraResult = PredictionEngineElytra.getElytraMovement(player, data.vector.clone(), currentLook).multiply(player.stuckSpeedMultiplier).multiply(new Vector(0.99f, 0.98f, 0.99f));
            results.add(data.returnNewModified(elytraResult, VectorData.VectorType.InputResult));
            player.trigHandler.toggleShitMath();
            elytraResult = PredictionEngineElytra.getElytraMovement(player, data.vector.clone(), ReachUtils.getLook(player, player.xRot, player.yRot)).multiply(player.stuckSpeedMultiplier).multiply(new Vector(0.99f, 0.98f, 0.99f));
            player.trigHandler.toggleShitMath();
            results.add(data.returnNewModified(elytraResult, VectorData.VectorType.InputResult));
        }
        return results;
    }

    public static Vector getElytraMovement(GrimPlayer player, Vector vector, Vector lookVector) {
        double d5;
        float yRotRadians = player.yRot * ((float)Math.PI / 180);
        double horizontalSqrt = Math.sqrt(lookVector.getX() * lookVector.getX() + lookVector.getZ() * lookVector.getZ());
        double horizontalLength = vector.clone().setY(0).length();
        double length = lookVector.length();
        double vertCosRotation = player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_18_2) ? Math.cos(yRotRadians) : (double)player.trigHandler.cos(yRotRadians);
        vertCosRotation = (float)(vertCosRotation * vertCosRotation * Math.min(1.0, length / 0.4));
        double recalculatedGravity = 0.08;
        if (player.clientVelocity.getY() <= 0.0 && player.compensatedEntities.getSlowFallingAmplifier() != null) {
            recalculatedGravity = 0.01;
        }
        vector.add(new Vector(0.0, recalculatedGravity * (-1.0 + vertCosRotation * 0.75), 0.0));
        if (vector.getY() < 0.0 && horizontalSqrt > 0.0) {
            d5 = vector.getY() * -0.1 * vertCosRotation;
            vector.add(new Vector(lookVector.getX() * d5 / horizontalSqrt, d5, lookVector.getZ() * d5 / horizontalSqrt));
        }
        if (yRotRadians < 0.0f && horizontalSqrt > 0.0) {
            d5 = horizontalLength * (double)(-player.trigHandler.sin(yRotRadians)) * 0.04;
            vector.add(new Vector(-lookVector.getX() * d5 / horizontalSqrt, d5 * 3.2, -lookVector.getZ() * d5 / horizontalSqrt));
        }
        if (horizontalSqrt > 0.0) {
            vector.add(new Vector((lookVector.getX() / horizontalSqrt * horizontalLength - vector.getX()) * 0.1, 0.0, (lookVector.getZ() / horizontalSqrt * horizontalLength - vector.getZ()) * 0.1));
        }
        return vector;
    }

    @Override
    public void addJumpsToPossibilities(GrimPlayer player, Set<VectorData> existingVelocities) {
        new PredictionEngineNormal().addJumpsToPossibilities(player, existingVelocities);
    }
}

