/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.predictionengine.movementtick;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.predictionengine.movementtick.MovementTickerRideable;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.defaulttags.BlockTags;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import ac.grim.grimac.utils.data.packetentity.PacketEntityStrider;
import ac.grim.grimac.utils.nmsutil.BlockProperties;
import org.bukkit.util.Vector;

public class MovementTickerStrider
extends MovementTickerRideable {
    public MovementTickerStrider(GrimPlayer player) {
        super(player);
        this.movementInput = new Vector(0, 0, 1);
    }

    public static void floatStrider(GrimPlayer player) {
        if (player.wasTouchingLava) {
            if (MovementTickerStrider.isAbove(player) && player.compensatedWorld.getLavaFluidLevelAt((int)Math.floor(player.x), (int)Math.floor(player.y + 1.0), (int)Math.floor(player.z)) == 0.0) {
                player.onGround = true;
            } else {
                player.clientVelocity.multiply(0.5).add(new Vector(0.0, 0.05, 0.0));
            }
        }
    }

    public static boolean isAbove(GrimPlayer player) {
        return player.y > Math.floor(player.y) + 0.5 - (double)1.0E-5f;
    }

    @Override
    public void livingEntityAIStep() {
        super.livingEntityAIStep();
        ((PacketEntityStrider)this.player.compensatedEntities.getSelf().getRiding()).isShaking = true;
        StateType posMaterial = this.player.compensatedWorld.getStateTypeAt(this.player.x, this.player.y, this.player.z);
        StateType belowMaterial = BlockProperties.getOnBlock(this.player, this.player.x, this.player.y, this.player.z);
        ((PacketEntityStrider)this.player.compensatedEntities.getSelf().getRiding()).isShaking = !BlockTags.STRIDER_WARM_BLOCKS.contains(posMaterial) && !BlockTags.STRIDER_WARM_BLOCKS.contains(belowMaterial) && !this.player.wasTouchingLava;
    }

    @Override
    public float getSteeringSpeed() {
        PacketEntityStrider strider = (PacketEntityStrider)this.player.compensatedEntities.getSelf().getRiding();
        return strider.movementSpeedAttribute * (strider.isShaking ? 0.23f : 0.55f);
    }

    @Override
    public boolean canStandOnLava() {
        return true;
    }
}

