/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.predictionengine;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.enums.FluidTag;
import ac.grim.grimac.utils.enums.Pose;
import ac.grim.grimac.utils.latency.CompensatedEntities;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.nmsutil.BlockProperties;
import ac.grim.grimac.utils.nmsutil.CheckIfChunksLoaded;
import ac.grim.grimac.utils.nmsutil.Collisions;
import ac.grim.grimac.utils.nmsutil.FluidTypeFlowing;
import ac.grim.grimac.utils.nmsutil.GetBoundingBox;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class PlayerBaseTick {
    GrimPlayer player;

    public PlayerBaseTick(GrimPlayer player) {
        this.player = player;
    }

    public static boolean canEnterPose(GrimPlayer player, Pose pose, double x, double y, double z) {
        return Collisions.isEmpty(player, PlayerBaseTick.getBoundingBoxForPose(pose, x, y, z).expand(-1.0E-7));
    }

    protected static SimpleCollisionBox getBoundingBoxForPose(Pose pose, double x, double y, double z) {
        float radius = pose.width / 2.0f;
        return new SimpleCollisionBox(x - (double)radius, y, z - (double)radius, x + (double)radius, y + (double)pose.height, z + (double)radius, false);
    }

    public void doBaseTick() {
        this.player.baseTickAddition = new Vector();
        this.player.baseTickWaterPushing = new Vector();
        if (this.player.isFlying && this.player.isSneaking && !this.player.compensatedEntities.getSelf().inVehicle()) {
            Vector flyingShift = new Vector(0.0f, this.player.flySpeed * -3.0f, 0.0f);
            this.player.baseTickAddVector(flyingShift);
            this.player.trackBaseTickAddition(flyingShift);
        }
        this.updateInWaterStateAndDoFluidPushing();
        this.updateFluidOnEyes();
        this.updateSwimming();
        if (this.player.wasTouchingLava) {
            this.player.fallDistance *= 0.5;
        }
        if (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_13) && this.player.wasTouchingWater && this.player.isSneaking && !this.player.isFlying && !this.player.compensatedEntities.getSelf().inVehicle()) {
            Vector waterPushVector = new Vector(0.0f, -0.04f, 0.0f);
            this.player.baseTickAddVector(waterPushVector);
            this.player.trackBaseTickAddition(waterPushVector);
        }
        if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_13_2)) {
            this.player.isSlowMovement = this.player.isSneaking;
        } else {
            boolean bl = this.player.isSlowMovement = !this.player.wasFlying && !this.player.isSwimming && PlayerBaseTick.canEnterPose(this.player, Pose.CROUCHING, this.player.lastX, this.player.lastY, this.player.lastZ) && (this.player.wasSneaking || !this.player.isInBed && !PlayerBaseTick.canEnterPose(this.player, Pose.STANDING, this.player.lastX, this.player.lastY, this.player.lastZ)) || (this.player.pose == Pose.SWIMMING || !this.player.isGliding && this.player.pose == Pose.FALL_FLYING) && !this.player.wasTouchingWater;
            if (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14) && this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_14_4)) {
                boolean bl2 = this.player.isSlowMovement = this.player.isSlowMovement || this.player.isSneaking;
            }
        }
        if (this.player.compensatedEntities.getSelf().inVehicle()) {
            this.player.isSlowMovement = false;
        }
        if (!this.player.compensatedEntities.getSelf().inVehicle()) {
            this.moveTowardsClosestSpace(this.player.lastX - (this.player.boundingBox.maxX - this.player.boundingBox.minX) * 0.35, this.player.lastZ + (this.player.boundingBox.maxZ - this.player.boundingBox.minZ) * 0.35);
            this.moveTowardsClosestSpace(this.player.lastX - (this.player.boundingBox.maxX - this.player.boundingBox.minX) * 0.35, this.player.lastZ - (this.player.boundingBox.maxZ - this.player.boundingBox.minZ) * 0.35);
            this.moveTowardsClosestSpace(this.player.lastX + (this.player.boundingBox.maxX - this.player.boundingBox.minX) * 0.35, this.player.lastZ - (this.player.boundingBox.maxZ - this.player.boundingBox.minZ) * 0.35);
            this.moveTowardsClosestSpace(this.player.lastX + (this.player.boundingBox.maxX - this.player.boundingBox.minX) * 0.35, this.player.lastZ + (this.player.boundingBox.maxZ - this.player.boundingBox.minZ) * 0.35);
        }
        float f = BlockProperties.getBlockSpeedFactor(this.player);
        this.player.blockSpeedMultiplier = new Vector((double)f, 1.0, (double)f);
        if (this.player.getClientVersion().isOlderThan(ClientVersion.V_1_14)) {
            this.updatePlayerSize();
        }
    }

    private void updateFluidOnEyes() {
        this.player.wasEyeInWater = this.player.isEyeInFluid(FluidTag.WATER);
        this.player.fluidOnEyes = null;
        double d0 = this.player.lastY + this.player.getEyeHeight() - 0.1111111119389534;
        if (this.player.compensatedEntities.getSelf().getRiding() != null && EntityTypes.isTypeInstanceOf(this.player.compensatedEntities.getSelf().getRiding().type, EntityTypes.BOAT) && !this.player.vehicleData.boatUnderwater && this.player.boundingBox.maxY >= d0 && this.player.boundingBox.minY <= d0) {
            return;
        }
        double d1 = (double)((float)Math.floor(d0)) + this.player.compensatedWorld.getWaterFluidLevelAt(this.player.lastX, d0, this.player.lastZ);
        if (d1 > d0) {
            this.player.fluidOnEyes = FluidTag.WATER;
            if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_15_2)) {
                this.player.wasEyeInWater = true;
            }
            return;
        }
        if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_15_2)) {
            this.player.wasEyeInWater = false;
        }
        if ((d1 = (double)((float)Math.floor(d0)) + this.player.compensatedWorld.getWaterFluidLevelAt(this.player.lastX, d0, this.player.lastZ)) > d0) {
            this.player.fluidOnEyes = FluidTag.LAVA;
        }
    }

    public void updateInWaterStateAndDoFluidPushing() {
        double d;
        this.updateInWaterStateAndDoWaterCurrentPushing();
        double d2 = d = this.player.bukkitPlayer != null && this.player.bukkitPlayer.getWorld().getEnvironment() == World.Environment.NETHER ? 0.007 : 0.0023333333333333335;
        if (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_16)) {
            this.player.wasTouchingLava = this.updateFluidHeightAndDoFluidPushing(FluidTag.LAVA, d);
        } else if (this.player.getClientVersion().isOlderThan(ClientVersion.V_1_14)) {
            SimpleCollisionBox playerBox = this.player.boundingBox.copy().expand(-0.1f, -0.4f, -0.1f);
            this.player.wasTouchingLava = this.player.compensatedWorld.containsLava(playerBox);
        }
    }

    public void updatePowderSnow() {
        int i;
        if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_16_4)) {
            return;
        }
        this.player.compensatedEntities.getSelf().playerSpeed.getModifiers().removeIf(modifier -> modifier.getUUID().equals(CompensatedEntities.SNOW_MODIFIER_UUID));
        StateType type = BlockProperties.getOnBlock(this.player, this.player.x, this.player.y, this.player.z);
        if (!type.isAir() && (i = this.player.powderSnowFrozenTicks) > 0) {
            int ticksToFreeze = 140;
            float percentFrozen = (float)Math.min(i, ticksToFreeze) / (float)ticksToFreeze;
            float percentFrozenReducedToSpeed = -0.05f * percentFrozen;
            this.player.compensatedEntities.getSelf().playerSpeed.getModifiers().add(new WrapperPlayServerUpdateAttributes.PropertyModifier(CompensatedEntities.SNOW_MODIFIER_UUID, percentFrozenReducedToSpeed, WrapperPlayServerUpdateAttributes.PropertyModifier.Operation.ADDITION));
        }
    }

    public void updatePlayerPose() {
        if (PlayerBaseTick.canEnterPose(this.player, Pose.SWIMMING, this.player.x, this.player.y, this.player.z)) {
            Pose pose = this.player.isGliding ? Pose.FALL_FLYING : (this.player.isInBed ? Pose.SLEEPING : (this.player.isSwimming ? Pose.SWIMMING : (this.player.isRiptidePose ? Pose.SPIN_ATTACK : (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) && this.player.getClientVersion().isOlderThan(ClientVersion.V_1_14) && this.player.isSneaking ? Pose.NINE_CROUCHING : (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14) && this.player.isSneaking && !this.player.isFlying ? Pose.CROUCHING : Pose.STANDING)))));
            if (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14) && !this.player.compensatedEntities.getSelf().inVehicle() && !PlayerBaseTick.canEnterPose(this.player, pose, this.player.x, this.player.y, this.player.z)) {
                pose = PlayerBaseTick.canEnterPose(this.player, Pose.CROUCHING, this.player.x, this.player.y, this.player.z) ? Pose.CROUCHING : Pose.SWIMMING;
            }
            this.player.pose = pose;
            this.player.boundingBox = PlayerBaseTick.getBoundingBoxForPose(this.player.pose, this.player.x, this.player.y, this.player.z);
        }
    }

    public void updatePlayerSize() {
        Pose pose = this.player.isGliding ? Pose.FALL_FLYING : (this.player.isInBed ? Pose.SLEEPING : (!this.player.isSwimming && !this.player.isRiptidePose ? (this.player.isSneaking && this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? Pose.NINE_CROUCHING : Pose.STANDING) : Pose.SWIMMING));
        if (pose != this.player.pose) {
            boolean collides;
            Pose oldPose = this.player.pose;
            this.player.pose = pose;
            SimpleCollisionBox box = GetBoundingBox.getCollisionBoxForPlayer(this.player, this.player.lastX, this.player.lastY, this.player.lastZ);
            boolean bl = collides = !Collisions.isEmpty(this.player, box);
            if (collides) {
                this.player.pose = oldPose;
                return;
            }
        }
        this.player.boundingBox = GetBoundingBox.getCollisionBoxForPlayer(this.player, this.player.lastX, this.player.lastY, this.player.lastZ);
    }

    public void updateSwimming() {
        if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_12_2)) {
            this.player.isSwimming = false;
        } else if (this.player.isFlying) {
            this.player.isSwimming = false;
        } else if (this.player.compensatedEntities.getSelf().inVehicle()) {
            this.player.isSwimming = false;
        } else if (this.player.isSwimming) {
            this.player.isSwimming = this.player.lastSprinting && this.player.wasTouchingWater;
        } else {
            boolean feetInWater = this.player.getClientVersion().isOlderThan(ClientVersion.V_1_17) || this.player.compensatedWorld.getWaterFluidLevelAt(this.player.lastX, this.player.lastY, this.player.lastZ) > 0.0;
            this.player.isSwimming = this.player.lastSprinting && this.player.wasEyeInWater && this.player.wasTouchingWater && feetInWater;
        }
    }

    private void moveTowardsClosestSpace(double xPosition, double zPosition) {
        this.player.boundingBox = this.player.boundingBox.expand(0.03, 0.0, 0.03);
        if (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14)) {
            this.moveTowardsClosestSpaceModern(xPosition, zPosition);
        } else {
            this.moveTowardsClosestSpaceLegacy(xPosition, zPosition);
        }
        this.player.boundingBox = this.player.boundingBox.expand(-0.03, 0.0, -0.03);
    }

    private void moveTowardsClosestSpaceLegacy(double x, double z) {
        boolean suffocates;
        int floorX = GrimMath.floor(x);
        int floorZ = GrimMath.floor(z);
        int floorY = GrimMath.floor(this.player.lastY + 0.5);
        double d0 = x - (double)floorX;
        double d1 = z - (double)floorZ;
        if (this.player.isSwimming) {
            SimpleCollisionBox blockPos = new SimpleCollisionBox(floorX, floorY, floorZ, (double)floorX + 1.0, floorY + 1, (double)floorZ + 1.0, false).expand(-1.0E-7);
            suffocates = Collisions.suffocatesAt(this.player, blockPos);
        } else {
            boolean bl = suffocates = !this.clearAbove(floorX, floorY, floorZ);
        }
        if (suffocates) {
            int i = -1;
            double d2 = 9999.0;
            if (this.clearAbove(floorX - 1, floorY, floorZ) && d0 < d2) {
                d2 = d0;
                i = 0;
            }
            if (this.clearAbove(floorX + 1, floorY, floorZ) && 1.0 - d0 < d2) {
                d2 = 1.0 - d0;
                i = 1;
            }
            if (this.clearAbove(floorX, floorY, floorZ - 1) && d1 < d2) {
                d2 = d1;
                i = 4;
            }
            if (this.clearAbove(floorX, floorY, floorZ + 1) && 1.0 - d1 < d2) {
                i = 5;
            }
            if (i == 0) {
                this.player.uncertaintyHandler.xNegativeUncertainty -= 0.1;
                this.player.uncertaintyHandler.xPositiveUncertainty += 0.1;
                this.player.pointThreeEstimator.setPushing(true);
            }
            if (i == 1) {
                this.player.uncertaintyHandler.xNegativeUncertainty -= 0.1;
                this.player.uncertaintyHandler.xPositiveUncertainty += 0.1;
                this.player.pointThreeEstimator.setPushing(true);
            }
            if (i == 4) {
                this.player.uncertaintyHandler.zNegativeUncertainty -= 0.1;
                this.player.uncertaintyHandler.zPositiveUncertainty += 0.1;
                this.player.pointThreeEstimator.setPushing(true);
            }
            if (i == 5) {
                this.player.uncertaintyHandler.zNegativeUncertainty -= 0.1;
                this.player.uncertaintyHandler.zPositiveUncertainty += 0.1;
                this.player.pointThreeEstimator.setPushing(true);
            }
        }
    }

    private void moveTowardsClosestSpaceModern(double xPosition, double zPosition) {
        int blockZ;
        int blockX = (int)Math.floor(xPosition);
        if (!this.suffocatesAt(blockX, blockZ = (int)Math.floor(zPosition))) {
            return;
        }
        double relativeXMovement = xPosition - (double)blockX;
        double relativeZMovement = zPosition - (double)blockZ;
        BlockFace direction = null;
        double lowestValue = Double.MAX_VALUE;
        for (BlockFace direction2 : new BlockFace[]{BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH}) {
            boolean doesSuffocate;
            double d7 = direction2 == BlockFace.WEST || direction2 == BlockFace.EAST ? relativeXMovement : relativeZMovement;
            double d6 = direction2 == BlockFace.EAST || direction2 == BlockFace.SOUTH ? 1.0 - d7 : d7;
            switch (direction2) {
                case EAST: {
                    doesSuffocate = this.suffocatesAt(blockX + 1, blockZ);
                    break;
                }
                case WEST: {
                    doesSuffocate = this.suffocatesAt(blockX - 1, blockZ);
                    break;
                }
                case NORTH: {
                    doesSuffocate = this.suffocatesAt(blockX, blockZ - 1);
                    break;
                }
                default: {
                    doesSuffocate = this.suffocatesAt(blockX, blockZ + 1);
                }
            }
            if (d6 >= lowestValue || doesSuffocate) continue;
            lowestValue = d6;
            direction = direction2;
        }
        if (direction != null) {
            if (direction == BlockFace.WEST || direction == BlockFace.EAST) {
                this.player.uncertaintyHandler.xPositiveUncertainty += 0.15;
                this.player.uncertaintyHandler.xNegativeUncertainty -= 0.15;
                this.player.pointThreeEstimator.setPushing(true);
            } else {
                this.player.uncertaintyHandler.zPositiveUncertainty += 0.15;
                this.player.uncertaintyHandler.zNegativeUncertainty -= 0.15;
                this.player.pointThreeEstimator.setPushing(true);
            }
        }
    }

    public void updateInWaterStateAndDoWaterCurrentPushing() {
        boolean bl = this.player.wasTouchingWater = this.updateFluidHeightAndDoFluidPushing(FluidTag.WATER, 0.014) && (this.player.compensatedEntities.getSelf().getRiding() == null || !EntityTypes.isTypeInstanceOf(this.player.compensatedEntities.getSelf().getRiding().type, EntityTypes.BOAT));
        if (this.player.wasTouchingWater) {
            this.player.fallDistance = 0.0;
        }
    }

    public boolean updateFluidHeightAndDoFluidPushing(FluidTag tag, double multiplier) {
        if (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_13)) {
            return this.updateFluidHeightAndDoFluidPushingModern(tag, multiplier);
        }
        return this.updateFluidHeightAndDoFluidPushingLegacy(tag, multiplier);
    }

    public boolean updateFluidHeightAndDoFluidPushingLegacy(FluidTag tag, double multiplier) {
        int ceilZ;
        SimpleCollisionBox aABB = this.player.boundingBox.copy().expand(0.0, -0.4, 0.0).expand(-0.001);
        int floorX = GrimMath.floor(aABB.minX);
        int ceilX = GrimMath.ceil(aABB.maxX);
        int floorY = GrimMath.floor(aABB.minY);
        int ceilY = GrimMath.ceil(aABB.maxY);
        int floorZ = GrimMath.floor(aABB.minZ);
        if (CheckIfChunksLoaded.isChunksUnloadedAt(this.player, floorX, floorY, floorZ, ceilX, ceilY, ceilZ = GrimMath.ceil(aABB.maxZ))) {
            return false;
        }
        boolean hasPushed = false;
        Vector vec3 = new Vector();
        for (int x = floorX; x < ceilX; ++x) {
            for (int y = floorY; y < ceilY; ++y) {
                for (int z = floorZ; z < ceilZ; ++z) {
                    double fluidHeight = tag == FluidTag.WATER ? this.player.compensatedWorld.getWaterFluidLevelAt(x, y, z) : this.player.compensatedWorld.getLavaFluidLevelAt(x, y, z);
                    if (fluidHeight == 0.0) continue;
                    double d0 = (double)(y + 1) - fluidHeight;
                    if (this.player.isFlying || !((double)ceilY >= d0)) continue;
                    hasPushed = true;
                    vec3.add(FluidTypeFlowing.getFlow(this.player, x, y, z));
                }
            }
        }
        if (tag == FluidTag.WATER && vec3.lengthSquared() > 0.0) {
            vec3.normalize();
            vec3.multiply(multiplier);
            this.player.baseTickAddWaterPushing(vec3);
            this.player.baseTickAddVector(vec3);
        }
        return hasPushed;
    }

    public boolean updateFluidHeightAndDoFluidPushingModern(FluidTag tag, double multiplier) {
        int ceilZ;
        SimpleCollisionBox aABB = this.player.boundingBox.copy().expand(-0.001);
        int floorX = GrimMath.floor(aABB.minX);
        int ceilX = GrimMath.ceil(aABB.maxX);
        int floorY = GrimMath.floor(aABB.minY);
        int ceilY = GrimMath.ceil(aABB.maxY);
        int floorZ = GrimMath.floor(aABB.minZ);
        if (CheckIfChunksLoaded.isChunksUnloadedAt(this.player, floorX, floorY, floorZ, ceilX, ceilY, ceilZ = GrimMath.ceil(aABB.maxZ))) {
            return false;
        }
        double d2 = 0.0;
        boolean hasTouched = false;
        Vector vec3 = new Vector();
        int n7 = 0;
        for (int x = floorX; x < ceilX; ++x) {
            for (int y = floorY; y < ceilY; ++y) {
                for (int z = floorZ; z < ceilZ; ++z) {
                    double d;
                    double fluidHeight = tag == FluidTag.WATER ? this.player.compensatedWorld.getWaterFluidLevelAt(x, y, z) : this.player.compensatedWorld.getLavaFluidLevelAt(x, y, z);
                    if (this.player.getClientVersion().isOlderThan(ClientVersion.V_1_14)) {
                        fluidHeight = Math.min(fluidHeight, 0.8888888888888888);
                    }
                    if (fluidHeight == 0.0) continue;
                    double fluidHeightToWorld = (double)y + fluidHeight;
                    if (d < aABB.minY) continue;
                    hasTouched = true;
                    d2 = Math.max(fluidHeightToWorld - aABB.minY, d2);
                    if (this.player.isFlying) continue;
                    Vector vec32 = FluidTypeFlowing.getFlow(this.player, x, y, z);
                    if (d2 < 0.4) {
                        vec32 = vec32.multiply(d2);
                    }
                    vec3 = vec3.add(vec32);
                    ++n7;
                }
            }
        }
        if (vec3.lengthSquared() > 0.0) {
            if (n7 > 0) {
                vec3 = vec3.multiply(1.0 / (double)n7);
            }
            if (this.player.compensatedEntities.getSelf().inVehicle()) {
                vec3 = vec3.normalize();
            }
            if (tag != FluidTag.LAVA || this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_16)) {
                vec3 = vec3.multiply(multiplier);
                this.player.baseTickAddWaterPushing(vec3);
                if (Math.abs(this.player.clientVelocity.getX()) < 0.003 && Math.abs(this.player.clientVelocity.getZ()) < 0.003 && vec3.length() < 0.0045000000000000005) {
                    vec3 = vec3.normalize().multiply(0.0045000000000000005);
                }
                this.player.baseTickAddVector(vec3);
            }
        }
        if (tag == FluidTag.LAVA) {
            boolean bl = this.player.slightlyTouchingLava = hasTouched && d2 <= 0.4;
        }
        if (tag == FluidTag.WATER) {
            this.player.slightlyTouchingWater = hasTouched && d2 <= 0.4;
        }
        return hasTouched;
    }

    private boolean suffocatesAt(int x, int z) {
        SimpleCollisionBox axisAlignedBB = new SimpleCollisionBox(x, this.player.boundingBox.minY, z, (double)x + 1.0, this.player.boundingBox.maxY, (double)z + 1.0, false).expand(-1.0E-7);
        return Collisions.suffocatesAt(this.player, axisAlignedBB);
    }

    private boolean clearAbove(int x, int y, int z) {
        return !Collisions.doesBlockSuffocate(this.player, x, y, z) && !Collisions.doesBlockSuffocate(this.player, x, y + 1, z);
    }
}

