/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.predictionengine;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.impl.movement.EntityControl;
import ac.grim.grimac.checks.type.PositionCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.predictionengine.PlayerBaseTick;
import ac.grim.grimac.predictionengine.movementtick.MovementTickerHorse;
import ac.grim.grimac.predictionengine.movementtick.MovementTickerPig;
import ac.grim.grimac.predictionengine.movementtick.MovementTickerPlayer;
import ac.grim.grimac.predictionengine.movementtick.MovementTickerStrider;
import ac.grim.grimac.predictionengine.predictions.PredictionEngineNormal;
import ac.grim.grimac.predictionengine.predictions.rideable.BoatPredictionEngine;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.enchantment.type.EnchantmentTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.GameMode;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.defaulttags.BlockTags;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.utils.anticheat.update.PositionUpdate;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.VectorData;
import ac.grim.grimac.utils.data.packetentity.PacketEntityHorse;
import ac.grim.grimac.utils.data.packetentity.PacketEntityRideable;
import ac.grim.grimac.utils.data.packetentity.PacketEntityTrackXRot;
import ac.grim.grimac.utils.enums.Pose;
import ac.grim.grimac.utils.latency.CompensatedWorld;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.math.VectorUtils;
import ac.grim.grimac.utils.nmsutil.BoundingBoxSize;
import ac.grim.grimac.utils.nmsutil.Collisions;
import ac.grim.grimac.utils.nmsutil.GetBoundingBox;
import ac.grim.grimac.utils.nmsutil.Materials;
import ac.grim.grimac.utils.nmsutil.Riptide;
import org.bukkit.util.Vector;

public class MovementCheckRunner
extends Check
implements PositionCheck {
    public static double predictionNanos = 300000.0;
    public static double longPredictionNanos = 300000.0;

    public MovementCheckRunner(GrimPlayer player) {
        super(player);
    }

    public void processAndCheckMovementPacket(PositionUpdate data) {
        if (this.player.getSetbackTeleportUtil().insideUnloadedChunk()) {
            this.player.lastOnGround = this.player.clientClaimsLastOnGround;
            if (this.player.compensatedEntities.getSelf().inVehicle() && (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_9) || this.player.getClientVersion().isOlderThan(ClientVersion.V_1_9))) {
                return;
            }
            if (!data.isTeleport()) {
                this.player.getSetbackTeleportUtil().executeForceResync();
                return;
            }
        }
        long start = System.nanoTime();
        this.check(data);
        long length = System.nanoTime() - start;
        if (!this.player.disableGrim) {
            predictionNanos = predictionNanos * 499.0 / 500.0 + (double)length / 500.0;
            longPredictionNanos = longPredictionNanos * 19999.0 / 20000.0 + (double)length / 20000.0;
        }
    }

    private void handleTeleport(PositionUpdate update) {
        this.player.lastX = this.player.x;
        this.player.lastY = this.player.y;
        this.player.lastZ = this.player.z;
        if (!this.player.compensatedEntities.getSelf().inVehicle()) {
            if (update.getTeleportData() == null || !update.getTeleportData().isRelativeX()) {
                this.player.clientVelocity.setX(0);
            }
            if (update.getTeleportData() == null || !update.getTeleportData().isRelativeY()) {
                this.player.clientVelocity.setY(0);
                this.player.lastWasClimbing = 0.0;
                this.player.canSwimHop = false;
            }
            if (update.getTeleportData() == null || !update.getTeleportData().isRelativeZ()) {
                this.player.clientVelocity.setZ(0);
            }
        }
        this.player.uncertaintyHandler.lastTeleportTicks.reset();
        this.player.checkManager.getExplosionHandler().forceExempt();
        this.player.checkManager.getKnockbackHandler().forceExempt();
        this.player.boundingBox = GetBoundingBox.getCollisionBoxForPlayer(this.player, this.player.x, this.player.y, this.player.z);
        this.player.getSetbackTeleportUtil().onPredictionComplete(new PredictionComplete(0.0, update, true));
        this.player.uncertaintyHandler.lastHorizontalOffset = 0.0;
        this.player.uncertaintyHandler.lastVerticalOffset = 0.0;
    }

    private void check(PositionUpdate update) {
        if (update.isTeleport()) {
            this.handleTeleport(update);
            return;
        }
        ++this.player.movementPackets;
        this.player.onGround = update.isOnGround();
        if (!this.player.isFlying && this.player.isSneaking && Collisions.isAboveGround(this.player)) {
            boolean isSouth;
            double posX = Math.max(0.05, GrimMath.clamp(this.player.actualMovement.getX(), -16.0, 16.0) + 0.05);
            double posZ = Math.max(0.05, GrimMath.clamp(this.player.actualMovement.getZ(), -16.0, 16.0) + 0.05);
            double negX = Math.min(-0.05, GrimMath.clamp(this.player.actualMovement.getX(), -16.0, 16.0) - 0.05);
            double negZ = Math.min(-0.05, GrimMath.clamp(this.player.actualMovement.getZ(), -16.0, 16.0) - 0.05);
            Vector NE = Collisions.maybeBackOffFromEdge(new Vector(posX, 0.0, negZ), this.player, true);
            Vector NW = Collisions.maybeBackOffFromEdge(new Vector(negX, 0.0, negZ), this.player, true);
            Vector SE = Collisions.maybeBackOffFromEdge(new Vector(posX, 0.0, posZ), this.player, true);
            Vector SW = Collisions.maybeBackOffFromEdge(new Vector(negX, 0.0, posZ), this.player, true);
            boolean isEast = NE.getX() != posX || SE.getX() != posX;
            boolean isWest = NW.getX() != negX || SW.getX() != negX;
            boolean isNorth = NE.getZ() != negZ || NW.getZ() != negZ;
            boolean bl = isSouth = SE.getZ() != posZ || SW.getZ() != posZ;
            if (isEast) {
                this.player.uncertaintyHandler.lastStuckEast.reset();
            }
            if (isWest) {
                this.player.uncertaintyHandler.lastStuckWest.reset();
            }
            if (isNorth) {
                this.player.uncertaintyHandler.lastStuckNorth.reset();
            }
            if (isSouth) {
                this.player.uncertaintyHandler.lastStuckSouth.reset();
            }
            if (isEast || isWest || isSouth || isNorth) {
                this.player.uncertaintyHandler.stuckOnEdge.reset();
            }
        }
        this.player.compensatedWorld.tickPlayerInPistonPushingArea();
        this.player.compensatedEntities.tick();
        if (this.player.vehicleData.wasVehicleSwitch || this.player.vehicleData.lastDummy) {
            this.player.uncertaintyHandler.lastVehicleSwitch.reset();
        }
        if (this.player.vehicleData.lastDummy) {
            this.player.clientVelocity.multiply(0.98);
        }
        if (this.player.vehicleData.wasVehicleSwitch || this.player.vehicleData.lastDummy) {
            update.setTeleport(true);
            this.player.vehicleData.lastDummy = false;
            this.player.vehicleData.wasVehicleSwitch = false;
            if (this.player.compensatedEntities.getSelf().getRiding() != null) {
                Vector pos = new Vector(this.player.x, this.player.y, this.player.z);
                SimpleCollisionBox interTruePositions = this.player.compensatedEntities.getSelf().getRiding().getPossibleCollisionBoxes();
                float width = BoundingBoxSize.getWidth(this.player, this.player.compensatedEntities.getSelf().getRiding());
                float height = BoundingBoxSize.getHeight(this.player, this.player.compensatedEntities.getSelf().getRiding());
                interTruePositions.expand(-width, 0.0, -width);
                interTruePositions.expandMax(0.0, -height, 0.0);
                Vector cutTo = VectorUtils.cutBoxToVector(pos, interTruePositions);
                this.player.lastX = cutTo.getX();
                this.player.lastY = cutTo.getY();
                this.player.lastZ = cutTo.getZ();
                this.player.boundingBox = GetBoundingBox.getCollisionBoxForPlayer(this.player, this.player.lastX, this.player.lastY, this.player.lastZ);
            } else {
                Vector vector = new Vector(this.player.lastX, this.player.lastY, this.player.lastZ);
                Vector vector2 = new Vector(this.player.x, this.player.y, this.player.z);
                if (vector.distance(vector2) > 3.0) {
                    this.player.getSetbackTeleportUtil().executeForceResync();
                }
                this.handleTeleport(update);
                if (this.player.isClimbing) {
                    Vector ladder = this.player.clientVelocity.clone().setY(0.2);
                    PredictionEngineNormal.staticVectorEndOfTick(this.player, ladder);
                    this.player.lastWasClimbing = ladder.getY();
                }
                return;
            }
        }
        if (this.player.isInBed != this.player.lastInBed) {
            update.setTeleport(true);
        }
        this.player.lastInBed = this.player.isInBed;
        if (this.player.isInBed) {
            return;
        }
        if (!this.player.compensatedEntities.getSelf().inVehicle()) {
            this.player.speed = this.player.compensatedEntities.getPlayerMovementSpeed();
            if (this.player.hasGravity != this.player.playerEntityHasGravity) {
                this.player.pointThreeEstimator.updatePlayerGravity();
            }
            this.player.hasGravity = this.player.playerEntityHasGravity;
        }
        if (this.player.compensatedEntities.getSelf().inVehicle()) {
            this.player.checkManager.getExplosionHandler().forceExempt();
            this.player.compensatedEntities.getSelf().getRiding().setPositionRaw(GetBoundingBox.getPacketEntityBoundingBox(this.player, this.player.x, this.player.y, this.player.z, this.player.compensatedEntities.getSelf().getRiding()));
            if (this.player.compensatedEntities.getSelf().getRiding() instanceof PacketEntityTrackXRot) {
                PacketEntityTrackXRot boat = (PacketEntityTrackXRot)this.player.compensatedEntities.getSelf().getRiding();
                boat.packetYaw = this.player.xRot;
                boat.interpYaw = this.player.xRot;
                boat.steps = 0;
            }
            if (this.player.hasGravity != this.player.compensatedEntities.getSelf().getRiding().hasGravity) {
                this.player.pointThreeEstimator.updatePlayerGravity();
            }
            this.player.hasGravity = this.player.compensatedEntities.getSelf().getRiding().hasGravity;
            if (this.player.compensatedEntities.getSelf().getRiding() instanceof PacketEntityRideable) {
                boolean correctOffhand;
                EntityControl control = this.player.checkManager.getPostPredictionCheck(EntityControl.class);
                ItemType requiredItem = this.player.compensatedEntities.getSelf().getRiding().type == EntityTypes.PIG ? ItemTypes.CARROT_ON_A_STICK : ItemTypes.WARPED_FUNGUS_ON_A_STICK;
                ItemStack mainHand = this.player.getInventory().getHeldItem();
                ItemStack offHand = this.player.getInventory().getOffHand();
                boolean correctMainHand = mainHand.getType() == requiredItem;
                boolean bl = correctOffhand = offHand.getType() == requiredItem;
                if (!correctMainHand && !correctOffhand) {
                    control.flagAndAlert();
                } else {
                    control.rewardPlayer();
                }
            }
        }
        if (this.player.isFlying) {
            this.player.fallDistance = 0.0;
            this.player.uncertaintyHandler.lastFlyingTicks.reset();
        }
        this.player.isClimbing = Collisions.onClimbable(this.player, this.player.lastX, this.player.lastY, this.player.lastZ);
        this.player.clientControlledVerticalCollision = Math.abs(this.player.y % 0.015625) < 1.0E-5;
        this.player.actualMovement = new Vector(this.player.x - this.player.lastX, this.player.y - this.player.lastY, this.player.z - this.player.lastZ);
        if (this.player.isSprinting != this.player.lastSprinting) {
            this.player.compensatedEntities.hasSprintingAttributeEnabled = this.player.isSprinting;
        }
        boolean oldFlying = this.player.isFlying;
        boolean oldGliding = this.player.isGliding;
        boolean oldSprinting = this.player.isSprinting;
        boolean oldSneaking = this.player.isSneaking;
        if (this.player.compensatedEntities.getSelf().inVehicle()) {
            this.player.isFlying = false;
            this.player.isGliding = false;
            this.player.isSprinting = false;
            this.player.isSneaking = false;
            if (this.player.compensatedEntities.getSelf().getRiding().type != EntityTypes.PIG && this.player.compensatedEntities.getSelf().getRiding().type != EntityTypes.STRIDER) {
                this.player.isClimbing = false;
            }
        }
        if (!this.player.compensatedEntities.getSelf().inVehicle()) {
            this.player.speed = this.player.speed + (this.player.compensatedEntities.hasSprintingAttributeEnabled ? this.player.speed * (double)0.3f : 0.0);
        }
        boolean clientClaimsRiptide = this.player.packetStateData.tryingToRiptide;
        if (this.player.packetStateData.tryingToRiptide) {
            boolean isInWater;
            long currentTime = System.currentTimeMillis();
            boolean bl = isInWater = this.player.compensatedWorld.isRaining || Collisions.hasMaterial(this.player, this.player.boundingBox.copy().expand(0.1f), block -> Materials.isWater(CompensatedWorld.blockVersion, (WrappedBlockState)block.getFirst()));
            if (currentTime - this.player.packetStateData.lastRiptide < 450L || !isInWater) {
                this.player.packetStateData.tryingToRiptide = false;
            }
            this.player.packetStateData.lastRiptide = currentTime;
        }
        SimpleCollisionBox steppingOnBB = GetBoundingBox.getCollisionBoxForPlayer(this.player, this.player.x, this.player.y, this.player.z).expand(0.03).offset(0.0, -1.0, 0.0);
        Collisions.hasMaterial(this.player, steppingOnBB, pair -> {
            WrappedBlockState data = (WrappedBlockState)pair.getFirst();
            if (data.getType() == StateTypes.SLIME_BLOCK && this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8)) {
                this.player.uncertaintyHandler.isSteppingOnSlime = true;
                this.player.uncertaintyHandler.isSteppingOnBouncyBlock = true;
            }
            if (data.getType() == StateTypes.HONEY_BLOCK) {
                if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_14) && this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8)) {
                    this.player.uncertaintyHandler.isSteppingOnBouncyBlock = true;
                }
                this.player.uncertaintyHandler.isSteppingOnHoney = true;
            }
            if (BlockTags.BEDS.contains(data.getType()) && this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8)) {
                this.player.uncertaintyHandler.isSteppingOnBouncyBlock = true;
            }
            if (BlockTags.ICE.contains(data.getType())) {
                this.player.uncertaintyHandler.isSteppingOnIce = true;
            }
            if (data.getType() == StateTypes.BUBBLE_COLUMN) {
                this.player.uncertaintyHandler.isSteppingNearBubbleColumn = true;
            }
            if (data.getType() == StateTypes.SCAFFOLDING) {
                this.player.uncertaintyHandler.isSteppingNearScaffolding = true;
            }
            return false;
        });
        this.player.uncertaintyHandler.thisTickSlimeBlockUncertainty = this.player.uncertaintyHandler.nextTickSlimeBlockUncertainty;
        this.player.uncertaintyHandler.nextTickSlimeBlockUncertainty = 0.0;
        SimpleCollisionBox expandedBB = GetBoundingBox.getBoundingBoxFromPosAndSize(this.player.lastX, this.player.lastY, this.player.lastZ, 0.001f, 0.001f);
        if (this.player.actualMovement.lengthSquared() < 2500.0) {
            expandedBB.expandToAbsoluteCoordinates(this.player.x, this.player.y, this.player.z);
        }
        expandedBB.expand(Pose.STANDING.width / 2.0f, 0.0, Pose.STANDING.width / 2.0f);
        expandedBB.expandMax(0.0, Pose.STANDING.height, 0.0);
        boolean isGlitchy = this.player.uncertaintyHandler.isNearGlitchyBlock;
        this.player.uncertaintyHandler.isNearGlitchyBlock = this.player.getClientVersion().isOlderThan(ClientVersion.V_1_9) && Collisions.hasMaterial(this.player, expandedBB.copy().expand(0.2), checkData -> BlockTags.ANVIL.contains(((WrappedBlockState)checkData.getFirst()).getType()) || ((WrappedBlockState)checkData.getFirst()).getType() == StateTypes.CHEST || ((WrappedBlockState)checkData.getFirst()).getType() == StateTypes.TRAPPED_CHEST);
        this.player.uncertaintyHandler.isOrWasNearGlitchyBlock = isGlitchy || this.player.uncertaintyHandler.isNearGlitchyBlock;
        this.player.uncertaintyHandler.checkForHardCollision();
        if (this.player.isFlying != this.player.wasFlying) {
            this.player.uncertaintyHandler.lastFlyingStatusChange.reset();
        }
        if (!(this.player.compensatedEntities.getSelf().inVehicle() || Math.abs(this.player.x) != 2.9999999E7 && Math.abs(this.player.z) != 2.9999999E7)) {
            this.player.uncertaintyHandler.lastThirtyMillionHardBorder.reset();
        }
        if (this.player.isFlying && this.player.getClientVersion().isOlderThan(ClientVersion.V_1_13) && this.player.compensatedWorld.containsLiquid(this.player.boundingBox)) {
            this.player.uncertaintyHandler.lastUnderwaterFlyingHack.reset();
        }
        boolean couldBeStuckSpeed = Collisions.checkStuckSpeed(this.player, 0.03);
        boolean couldLeaveStuckSpeed = this.player.isPointThree() && Collisions.checkStuckSpeed(this.player, -0.03);
        boolean bl = this.player.uncertaintyHandler.claimingLeftStuckSpeed = !this.player.compensatedEntities.getSelf().inVehicle() && this.player.stuckSpeedMultiplier.getX() < 1.0 && !couldLeaveStuckSpeed;
        if (couldBeStuckSpeed) {
            this.player.uncertaintyHandler.lastStuckSpeedMultiplier.reset();
        }
        this.player.startTickClientVel = this.player.clientVelocity;
        boolean wasChecked = false;
        if (this.player.compensatedEntities.getSelf().isDead || this.player.compensatedEntities.getSelf().getRiding() != null && this.player.compensatedEntities.getSelf().getRiding().isDead) {
            this.player.predictedVelocity = new VectorData(new Vector(), VectorData.VectorType.Dead);
            this.player.clientVelocity = new Vector();
        } else if (this.player.disableGrim || PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_8) && this.player.gamemode == GameMode.SPECTATOR || this.player.isFlying) {
            this.player.predictedVelocity = new VectorData(this.player.actualMovement, VectorData.VectorType.Spectator);
            this.player.clientVelocity = this.player.actualMovement.clone();
            this.player.gravity = 0.0;
            this.player.friction = 0.91f;
            PredictionEngineNormal.staticVectorEndOfTick(this.player, this.player.clientVelocity);
        } else if (this.player.compensatedEntities.getSelf().getRiding() == null) {
            wasChecked = true;
            ItemStack boots = this.player.getInventory().getBoots();
            this.player.depthStriderLevel = this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_8) ? (float)boots.getEnchantmentLevel(EnchantmentTypes.DEPTH_STRIDER, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()) : 0.0f;
            if (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_19)) {
                ItemStack leggings = this.player.getInventory().getLeggings();
                this.player.sneakingSpeedMultiplier = GrimMath.clampFloat(0.3f + (float)leggings.getEnchantmentLevel(EnchantmentTypes.SWIFT_SNEAK, this.player.getClientVersion()) * 0.15f, 0.0f, 1.0f);
            } else {
                this.player.sneakingSpeedMultiplier = 0.3f;
            }
            this.player.verticalCollision = false;
            if (this.player.lastOnGround && this.player.packetStateData.tryingToRiptide && !this.player.compensatedEntities.getSelf().inVehicle()) {
                Vector pushingMovement = Collisions.collide(this.player, 0.0, 1.1999999284744263, 0.0);
                this.player.verticalCollision = pushingMovement.getY() != 1.1999999284744263;
                double currentY = this.player.clientVelocity.getY();
                if (this.likelyGroundRiptide(pushingMovement)) {
                    this.player.uncertaintyHandler.thisTickSlimeBlockUncertainty = Math.abs(Riptide.getRiptideVelocity(this.player).getY()) + (currentY > 0.0 ? currentY : 0.0);
                    this.player.uncertaintyHandler.nextTickSlimeBlockUncertainty = Math.abs(Riptide.getRiptideVelocity(this.player).getY()) + (currentY > 0.0 ? currentY : 0.0);
                    this.player.lastOnGround = false;
                    this.player.lastY += pushingMovement.getY();
                    new PlayerBaseTick(this.player).updatePlayerPose();
                    this.player.boundingBox = GetBoundingBox.getPlayerBoundingBox(this.player, this.player.lastX, this.player.lastY, this.player.lastZ);
                    this.player.actualMovement = new Vector(this.player.x - this.player.lastX, this.player.y - this.player.lastY, this.player.z - this.player.lastZ);
                    this.player.couldSkipTick = true;
                    Collisions.handleInsideBlocks(this.player);
                }
            }
            new PlayerBaseTick(this.player).doBaseTick();
            new MovementTickerPlayer(this.player).livingEntityAIStep();
            new PlayerBaseTick(this.player).updatePowderSnow();
            new PlayerBaseTick(this.player).updatePlayerPose();
        } else if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9) && this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9)) {
            wasChecked = true;
            if (EntityTypes.isTypeInstanceOf(this.player.compensatedEntities.getSelf().getRiding().type, EntityTypes.BOAT)) {
                new PlayerBaseTick(this.player).doBaseTick();
                new BoatPredictionEngine(this.player).guessBestMovement(0.1f, this.player);
            } else if (this.player.compensatedEntities.getSelf().getRiding() instanceof PacketEntityHorse) {
                new PlayerBaseTick(this.player).doBaseTick();
                new MovementTickerHorse(this.player).livingEntityAIStep();
            } else if (this.player.compensatedEntities.getSelf().getRiding().type == EntityTypes.PIG) {
                new PlayerBaseTick(this.player).doBaseTick();
                new MovementTickerPig(this.player).livingEntityAIStep();
            } else if (this.player.compensatedEntities.getSelf().getRiding().type == EntityTypes.STRIDER) {
                new PlayerBaseTick(this.player).doBaseTick();
                new MovementTickerStrider(this.player).livingEntityAIStep();
                MovementTickerStrider.floatStrider(this.player);
                Collisions.handleInsideBlocks(this.player);
            } else {
                wasChecked = false;
            }
        }
        double offset = this.player.predictedVelocity.vector.distance(this.player.actualMovement);
        offset = this.player.uncertaintyHandler.reduceOffset(offset);
        if (this.player.packetStateData.tryingToRiptide != clientClaimsRiptide) {
            this.player.getSetbackTeleportUtil().executeForceResync();
        }
        if (this.player.getSetbackTeleportUtil().getRequiredSetBack() != null && this.player.getSetbackTeleportUtil().getRequiredSetBack().getTicksComplete() == 1) {
            Vector setbackVel = this.player.getSetbackTeleportUtil().getRequiredSetBack().getVelocity();
            if (this.player.predictedVelocity.isJump() && (setbackVel != null && setbackVel.getY() >= 0.0 || !Collisions.slowCouldPointThreeHitGround(this.player, this.player.lastX, this.player.lastY, this.player.lastZ))) {
                this.player.getSetbackTeleportUtil().executeForceResync();
            }
            if (!this.player.predictedVelocity.isKnockback() && this.player.getSetbackTeleportUtil().getRequiredSetBack().getVelocity() != null) {
                this.player.getSetbackTeleportUtil().executeForceResync();
            }
        }
        if (this.player.getSetbackTeleportUtil().blockOffsets) {
            offset = 0.0;
        }
        if (this.player.skippedTickInActualMovement || !wasChecked) {
            this.player.uncertaintyHandler.lastPointThree.reset();
        }
        this.player.checkManager.onPredictionFinish(new PredictionComplete(offset, update, wasChecked));
        if (!wasChecked) {
            this.player.checkManager.getExplosionHandler().forceExempt();
            this.player.checkManager.getKnockbackHandler().forceExempt();
        }
        this.player.lastOnGround = this.player.onGround;
        this.player.lastSprinting = this.player.isSprinting;
        this.player.lastSprintingForSpeed = this.player.isSprinting;
        this.player.wasFlying = this.player.isFlying;
        this.player.wasGliding = this.player.isGliding;
        this.player.wasSwimming = this.player.isSwimming;
        this.player.wasSneaking = this.player.isSneaking;
        this.player.packetStateData.tryingToRiptide = false;
        if (this.player.compensatedEntities.getSelf().inVehicle()) {
            this.player.isFlying = oldFlying;
            this.player.isGliding = oldGliding;
            this.player.isSprinting = oldSprinting;
            this.player.isSneaking = oldSneaking;
        }
        --this.player.riptideSpinAttackTicks;
        if (this.player.predictedVelocity.isTrident()) {
            this.player.riptideSpinAttackTicks = 20;
        }
        this.player.uncertaintyHandler.lastMovementWasZeroPointZeroThree = !this.player.compensatedEntities.getSelf().inVehicle() && this.player.skippedTickInActualMovement;
        this.player.uncertaintyHandler.lastMovementWasUnknown003VectorReset = !this.player.compensatedEntities.getSelf().inVehicle() && this.player.couldSkipTick && this.player.predictedVelocity.isKnockback();
        this.player.couldSkipTick = false;
        this.player.uncertaintyHandler.wasZeroPointThreeVertically = !this.player.compensatedEntities.getSelf().inVehicle() && (this.player.uncertaintyHandler.lastMovementWasZeroPointZeroThree && this.player.pointThreeEstimator.controlsVerticalMovement() || !this.player.pointThreeEstimator.canPredictNextVerticalMovement() || !this.player.pointThreeEstimator.isWasAlwaysCertain());
        this.player.uncertaintyHandler.lastPacketWasGroundPacket = this.player.uncertaintyHandler.onGroundUncertain;
        this.player.uncertaintyHandler.onGroundUncertain = false;
        this.player.vehicleData.vehicleForward = (float)Math.min(0.98, Math.max(-0.98, (double)this.player.vehicleData.nextVehicleForward));
        this.player.vehicleData.vehicleHorizontal = (float)Math.min(0.98, Math.max(-0.98, (double)this.player.vehicleData.nextVehicleHorizontal));
        this.player.vehicleData.horseJump = this.player.vehicleData.nextHorseJump;
        this.player.vehicleData.nextHorseJump = 0.0f;
        this.player.minPlayerAttackSlow = 0;
        this.player.maxPlayerAttackSlow = 0;
        this.player.likelyKB = null;
        this.player.firstBreadKB = null;
        this.player.firstBreadExplosion = null;
        this.player.likelyExplosions = null;
        this.player.trigHandler.setOffset(offset);
        this.player.pointThreeEstimator.endOfTickTick();
    }

    private boolean likelyGroundRiptide(Vector pushingMovement) {
        double riptideYResult = Riptide.getRiptideVelocity(this.player).getY();
        double riptideDiffToBase = Math.abs(this.player.actualMovement.getY() - riptideYResult);
        double riptideDiffToGround = Math.abs(this.player.actualMovement.getY() - riptideYResult - pushingMovement.getY());
        return riptideDiffToGround < riptideDiffToBase;
    }
}

