/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.player;

import ac.grim.grimac.AbstractCheck;
import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.GrimUser;
import ac.grim.grimac.checks.impl.aim.processor.AimProcessor;
import ac.grim.grimac.checks.impl.misc.ClientBrand;
import ac.grim.grimac.events.packets.CheckManagerListener;
import ac.grim.grimac.manager.ActionManager;
import ac.grim.grimac.manager.CheckManager;
import ac.grim.grimac.manager.LastInstanceManager;
import ac.grim.grimac.manager.PunishmentManager;
import ac.grim.grimac.manager.SetbackTeleportUtil;
import ac.grim.grimac.predictionengine.MovementCheckRunner;
import ac.grim.grimac.predictionengine.PointThreeEstimator;
import ac.grim.grimac.predictionengine.UncertaintyHandler;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.ConnectionState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.GameMode;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.User;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.Dimension;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDisconnect;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityVelocity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPing;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowConfirmation;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.viaversion.ViaVersionUtil;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.shaded.kyori.adventure.text.Component;
import ac.grim.grimac.utils.anticheat.LogUtil;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.BlockPlaceSnapshot;
import ac.grim.grimac.utils.data.PacketStateData;
import ac.grim.grimac.utils.data.Pair;
import ac.grim.grimac.utils.data.TrackerData;
import ac.grim.grimac.utils.data.VectorData;
import ac.grim.grimac.utils.data.VehicleData;
import ac.grim.grimac.utils.data.VelocityData;
import ac.grim.grimac.utils.enums.FluidTag;
import ac.grim.grimac.utils.enums.Pose;
import ac.grim.grimac.utils.latency.CompensatedEntities;
import ac.grim.grimac.utils.latency.CompensatedFireworks;
import ac.grim.grimac.utils.latency.CompensatedInventory;
import ac.grim.grimac.utils.latency.CompensatedWorld;
import ac.grim.grimac.utils.latency.LatencyUtils;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.math.TrigHandler;
import ac.grim.grimac.utils.nmsutil.BlockProperties;
import ac.grim.grimac.utils.nmsutil.GetBoundingBox;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class GrimPlayer
implements GrimUser {
    public UUID playerUUID;
    public final User user;
    public int entityID;
    @Nullable
    public Player bukkitPlayer;
    public final Queue<Pair<Short, Long>> transactionsSent = new ConcurrentLinkedQueue<Pair<Short, Long>>();
    public final List<Short> didWeSendThatTrans = Collections.synchronizedList(new ArrayList());
    private final AtomicInteger transactionIDCounter = new AtomicInteger(0);
    public AtomicInteger lastTransactionSent = new AtomicInteger(0);
    public AtomicInteger lastTransactionReceived = new AtomicInteger(0);
    public CheckManager checkManager;
    public ActionManager actionManager;
    public PunishmentManager punishmentManager;
    public MovementCheckRunner movementCheckRunner;
    public Vector clientVelocity = new Vector();
    PacketTracker packetTracker;
    private long transactionPing = 0L;
    public long lastTransSent = 0L;
    public long lastTransReceived = 0L;
    private long playerClockAtLeast = System.nanoTime();
    public double lastWasClimbing = 0.0;
    public boolean canSwimHop = false;
    public int riptideSpinAttackTicks = 0;
    public int powderSnowFrozenTicks = 0;
    public boolean hasGravity = true;
    public boolean playerEntityHasGravity = true;
    public VectorData predictedVelocity = new VectorData(new Vector(), VectorData.VectorType.Normal);
    public Vector actualMovement = new Vector();
    public Vector stuckSpeedMultiplier = new Vector(1, 1, 1);
    public Vector blockSpeedMultiplier = new Vector(1, 1, 1);
    public UncertaintyHandler uncertaintyHandler;
    public double gravity;
    public float friction;
    public double speed;
    public Vector3d filterMojangStupidityOnMojangStupidity = new Vector3d();
    public double x;
    public double y;
    public double z;
    public double lastX;
    public double lastY;
    public double lastZ;
    public float xRot;
    public float yRot;
    public float lastXRot;
    public float lastYRot;
    public boolean onGround;
    public boolean lastOnGround;
    public boolean isSneaking;
    public boolean wasSneaking;
    public boolean isSprinting;
    public boolean lastSprinting;
    public boolean lastSprintingForSpeed;
    public boolean isFlying;
    public boolean canFly;
    public boolean wasFlying;
    public boolean isSwimming;
    public boolean wasSwimming;
    public boolean isClimbing;
    public boolean isGliding;
    public boolean wasGliding;
    public boolean isRiptidePose = false;
    public double fallDistance;
    public SimpleCollisionBox boundingBox;
    public Pose pose = Pose.STANDING;
    public boolean isSlowMovement = false;
    public boolean isInBed = false;
    public boolean lastInBed = false;
    public int food = 20;
    public float depthStriderLevel;
    public float sneakingSpeedMultiplier = 0.3f;
    public float flySpeed;
    public VehicleData vehicleData = new VehicleData();
    public boolean clientClaimsLastOnGround;
    public boolean wasTouchingWater = false;
    public boolean wasTouchingLava = false;
    public boolean slightlyTouchingLava = false;
    public boolean slightlyTouchingWater = false;
    public boolean wasEyeInWater = false;
    public FluidTag fluidOnEyes;
    public boolean verticalCollision;
    public boolean clientControlledVerticalCollision;
    public boolean couldSkipTick = false;
    public boolean skippedTickInActualMovement = false;
    public LastInstanceManager lastInstanceManager;
    public CompensatedFireworks compensatedFireworks;
    public CompensatedWorld compensatedWorld;
    public CompensatedEntities compensatedEntities;
    public LatencyUtils latencyUtils;
    public PointThreeEstimator pointThreeEstimator;
    public TrigHandler trigHandler;
    public PacketStateData packetStateData;
    public Vector baseTickAddition = new Vector();
    public Vector baseTickWaterPushing = new Vector();
    public Vector startTickClientVel = new Vector();
    public int movementPackets = 0;
    public VelocityData firstBreadKB = null;
    public VelocityData likelyKB = null;
    public VelocityData firstBreadExplosion = null;
    public VelocityData likelyExplosions = null;
    public int minPlayerAttackSlow = 0;
    public int maxPlayerAttackSlow = 0;
    public GameMode gamemode;
    public Dimension dimension;
    public Vector3d bedPosition;
    public long lastBlockPlaceUseItem = 0L;
    public AtomicInteger cancelledPackets = new AtomicInteger(0);
    public int totalFlyingPacketsSent;
    public Queue<BlockPlaceSnapshot> placeUseItemPackets = new LinkedBlockingQueue<BlockPlaceSnapshot>();
    public boolean disableGrim = false;
    public boolean noModifyPacketPermission = false;
    public boolean noSetbackPermission = false;
    private int spamThreshold = 100;

    public void onPacketCancel() {
        if (this.cancelledPackets.incrementAndGet() > this.spamThreshold) {
            LogUtil.info("Disconnecting " + this.getName() + " for spamming invalid packets, packets cancelled within a second " + this.cancelledPackets);
            this.disconnect(Component.translatable("disconnect.closed"));
            this.cancelledPackets.set(0);
        }
    }

    public GrimPlayer(User user) {
        this.user = user;
        this.playerUUID = user.getUUID();
        this.onReload();
        this.boundingBox = GetBoundingBox.getBoundingBoxFromPosAndSize(this.x, this.y, this.z, 0.6f, 1.8f);
        this.compensatedFireworks = new CompensatedFireworks(this);
        this.lastInstanceManager = new LastInstanceManager(this);
        this.checkManager = new CheckManager(this);
        this.actionManager = new ActionManager(this);
        this.punishmentManager = new PunishmentManager(this);
        this.movementCheckRunner = new MovementCheckRunner(this);
        this.compensatedWorld = new CompensatedWorld(this);
        this.compensatedEntities = new CompensatedEntities(this);
        this.latencyUtils = new LatencyUtils(this);
        this.trigHandler = new TrigHandler(this);
        this.uncertaintyHandler = new UncertaintyHandler(this);
        this.pointThreeEstimator = new PointThreeEstimator(this);
        this.packetStateData = new PacketStateData();
        this.uncertaintyHandler.collidingEntities.add(0);
    }

    public Set<VectorData> getPossibleVelocities() {
        HashSet<VectorData> set = new HashSet<VectorData>();
        if (this.firstBreadKB != null) {
            set.add(new VectorData(this.firstBreadKB.vector.clone(), VectorData.VectorType.Knockback).returnNewModified(VectorData.VectorType.FirstBreadKnockback));
        }
        if (this.likelyKB != null) {
            set.add(new VectorData(this.likelyKB.vector.clone(), VectorData.VectorType.Knockback));
        }
        set.addAll(this.getPossibleVelocitiesMinusKnockback());
        return set;
    }

    public Set<VectorData> getPossibleVelocitiesMinusKnockback() {
        HashSet<VectorData> possibleMovements = new HashSet<VectorData>();
        possibleMovements.add(new VectorData(this.clientVelocity, VectorData.VectorType.Normal));
        if (this.canSwimHop && !this.onGround) {
            possibleMovements.add(new VectorData(this.clientVelocity.clone().setY(0.3f), VectorData.VectorType.Swimhop));
        }
        if (this.riptideSpinAttackTicks >= 0 && Collections.max(this.uncertaintyHandler.collidingEntities) > 0) {
            possibleMovements.add(new VectorData(this.clientVelocity.clone().multiply(-0.2), VectorData.VectorType.Trident));
        }
        if (this.lastWasClimbing != 0.0) {
            possibleMovements.add(new VectorData(this.clientVelocity.clone().setY(this.lastWasClimbing + this.baseTickAddition.getY()), VectorData.VectorType.Climbable));
        }
        for (VectorData data : new HashSet(possibleMovements)) {
            for (BlockFace direction : this.uncertaintyHandler.slimePistonBounces) {
                if (direction.getModX() != 0) {
                    possibleMovements.add(data.returnNewModified(data.vector.clone().setX(direction.getModX()), VectorData.VectorType.SlimePistonBounce));
                    continue;
                }
                if (direction.getModY() != 0) {
                    possibleMovements.add(data.returnNewModified(data.vector.clone().setY(direction.getModY()), VectorData.VectorType.SlimePistonBounce));
                    continue;
                }
                if (direction.getModZ() == 0) continue;
                possibleMovements.add(data.returnNewModified(data.vector.clone().setZ(direction.getModZ()), VectorData.VectorType.SlimePistonBounce));
            }
        }
        return possibleMovements;
    }

    public boolean addTransactionResponse(short id) {
        Pair<Short, Long> data = null;
        boolean hasID = false;
        for (Pair pair : this.transactionsSent) {
            if ((Short)pair.getFirst() != id) continue;
            hasID = true;
            break;
        }
        if (hasID) {
            if (this.packetTracker != null) {
                this.packetTracker.setIntervalPackets(this.packetTracker.getIntervalPackets() - 1L);
            }
            while ((data = this.transactionsSent.poll()) != null) {
                this.lastTransactionReceived.incrementAndGet();
                this.lastTransReceived = System.currentTimeMillis();
                this.transactionPing = System.nanoTime() - data.getSecond();
                this.playerClockAtLeast = data.getSecond();
                if (data.getFirst() != id) continue;
            }
            CheckManagerListener.handleQueuedPlaces(this, false, 0.0f, 0.0f, System.currentTimeMillis());
            this.latencyUtils.handleNettySyncTransaction(this.lastTransactionReceived.get());
        }
        return data != null && (Short)data.getFirst() == id;
    }

    public void baseTickAddWaterPushing(Vector vector) {
        this.baseTickWaterPushing.add(vector);
    }

    public void baseTickAddVector(Vector vector) {
        this.clientVelocity.add(vector);
    }

    public void trackBaseTickAddition(Vector vector) {
        this.baseTickAddition.add(vector);
    }

    public float getMaxUpStep() {
        if (this.compensatedEntities.getSelf().getRiding() == null) {
            return 0.6f;
        }
        if (EntityTypes.isTypeInstanceOf(this.compensatedEntities.getSelf().getRiding().type, EntityTypes.BOAT)) {
            return 0.0f;
        }
        return 1.0f;
    }

    public void sendTransaction() {
        this.sendTransaction(false);
    }

    public void sendTransaction(boolean async) {
        if (this.user.getConnectionState() != ConnectionState.PLAY) {
            return;
        }
        if (this.disableGrim && (double)(System.nanoTime() - this.getPlayerClockAtLeast()) > 1.5E10) {
            return;
        }
        this.lastTransSent = System.currentTimeMillis();
        short transactionID = (short)(-1 * (this.transactionIDCounter.getAndIncrement() & Short.MAX_VALUE));
        try {
            this.addTransactionSend(transactionID);
            PacketWrapper packet = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_17) ? new WrapperPlayServerPing(transactionID) : new WrapperPlayServerWindowConfirmation(0, transactionID, false);
            if (async) {
                ChannelHelper.runInEventLoop(this.user.getChannel(), () -> this.user.writePacket(packet));
            } else {
                this.user.writePacket(packet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addTransactionSend(short id) {
        this.didWeSendThatTrans.add(id);
    }

    public boolean isEyeInFluid(FluidTag tag) {
        return this.fluidOnEyes == tag;
    }

    public double getEyeHeight() {
        return this.pose.eyeHeight;
    }

    public void timedOut() {
        this.disconnect(Component.translatable("disconnect.timeout"));
    }

    public void disconnect(Component reason) {
        try {
            this.user.sendPacket(new WrapperPlayServerDisconnect(reason));
        }
        catch (Exception ignored) {
            LogUtil.warn("Failed to send disconnect packet to disconnect " + this.user.getProfile().getName() + "! Disconnecting anyways.");
        }
        this.user.closeConnection();
    }

    public void pollData() {
        if (this.lastTransSent != 0L && this.lastTransSent + 80L < System.currentTimeMillis()) {
            this.sendTransaction(true);
        }
        if ((double)(System.nanoTime() - this.getPlayerClockAtLeast()) > (double)GrimAPI.INSTANCE.getConfigManager().getMaxPingTransaction() * 1.0E9) {
            this.timedOut();
        }
        if (!GrimAPI.INSTANCE.getPlayerDataManager().shouldCheck(this.user)) {
            GrimAPI.INSTANCE.getPlayerDataManager().remove(this.user);
        }
        if (this.packetTracker == null && ViaVersionUtil.isAvailable() && this.playerUUID != null) {
            UserConnection connection = Via.getManager().getConnectionManager().getConnectedClient(this.playerUUID);
            PacketTracker packetTracker = this.packetTracker = connection != null ? connection.getPacketTracker() : null;
        }
        if (this.playerUUID != null && this.bukkitPlayer == null) {
            this.bukkitPlayer = Bukkit.getPlayer((UUID)this.playerUUID);
            this.updatePermissions();
        }
    }

    public void updateVelocityMovementSkipping() {
        if (!this.couldSkipTick) {
            this.couldSkipTick = this.pointThreeEstimator.determineCanSkipTick(BlockProperties.getFrictionInfluencedSpeed((float)(this.speed * (this.isSprinting ? 1.3 : 1.0)), this), this.getPossibleVelocitiesMinusKnockback());
        }
        HashSet<VectorData> knockback = new HashSet<VectorData>();
        if (this.firstBreadKB != null) {
            knockback.add(new VectorData(this.firstBreadKB.vector, VectorData.VectorType.Knockback));
        }
        if (this.likelyKB != null) {
            knockback.add(new VectorData(this.likelyKB.vector, VectorData.VectorType.Knockback));
        }
        boolean kbPointThree = this.pointThreeEstimator.determineCanSkipTick(BlockProperties.getFrictionInfluencedSpeed((float)(this.speed * (this.isSprinting ? 1.3 : 1.0)), this), knockback);
        this.checkManager.getKnockbackHandler().setPointThree(kbPointThree);
        HashSet<VectorData> explosion = new HashSet<VectorData>();
        if (this.firstBreadExplosion != null) {
            explosion.add(new VectorData(this.firstBreadExplosion.vector, VectorData.VectorType.Explosion));
        }
        if (this.likelyExplosions != null) {
            explosion.add(new VectorData(this.likelyExplosions.vector, VectorData.VectorType.Explosion));
        }
        boolean explosionPointThree = this.pointThreeEstimator.determineCanSkipTick(BlockProperties.getFrictionInfluencedSpeed((float)(this.speed * (this.isSprinting ? 1.3 : 1.0)), this), explosion);
        this.checkManager.getExplosionHandler().setPointThree(explosionPointThree);
        if (kbPointThree || explosionPointThree) {
            this.uncertaintyHandler.lastPointThree.reset();
        }
    }

    @Override
    public void updatePermissions() {
        if (this.bukkitPlayer == null) {
            return;
        }
        this.noModifyPacketPermission = this.bukkitPlayer.hasPermission("grim.nomodifypacket");
        this.noSetbackPermission = this.bukkitPlayer.hasPermission("grim.nosetback");
    }

    public void onReload() {
        this.spamThreshold = GrimAPI.INSTANCE.getConfigManager().getConfig().getIntElse("packet-spam-threshold", 100);
    }

    public boolean isPointThree() {
        return this.getClientVersion().isOlderThan(ClientVersion.V_1_18_2);
    }

    public double getMovementThreshold() {
        return this.isPointThree() ? 0.03 : 2.0E-4;
    }

    public ClientVersion getClientVersion() {
        ClientVersion ver = this.user.getClientVersion();
        if (ver == null) {
            return ClientVersion.getById(PacketEvents.getAPI().getServerManager().getVersion().getProtocolVersion());
        }
        return ver;
    }

    public boolean isTickingReliablyFor(int ticks) {
        return !this.uncertaintyHandler.lastPointThree.hasOccurredSince(ticks) || this.compensatedEntities.getSelf().inVehicle() || this.getClientVersion().isOlderThan(ClientVersion.V_1_9);
    }

    public boolean canThePlayerBeCloseToZeroMovement(int ticks) {
        return !this.uncertaintyHandler.lastPointThree.hasOccurredSince(ticks);
    }

    public CompensatedInventory getInventory() {
        return this.checkManager.getPacketCheck(CompensatedInventory.class);
    }

    public List<Double> getPossibleEyeHeights() {
        if (this.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_14)) {
            return Arrays.asList(0.4, 1.27, 1.62);
        }
        if (this.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9)) {
            return Arrays.asList(0.4, 1.54, 1.62);
        }
        return Arrays.asList(1.54f, 1.62f);
    }

    @Override
    public int getTransactionPing() {
        return GrimMath.floor((double)this.transactionPing / 1000000.0);
    }

    @Override
    public int getKeepAlivePing() {
        if (this.bukkitPlayer == null) {
            return -1;
        }
        return PacketEvents.getAPI().getPlayerManager().getPing(this.bukkitPlayer);
    }

    public long getPlayerClockAtLeast() {
        return this.playerClockAtLeast;
    }

    public SetbackTeleportUtil getSetbackTeleportUtil() {
        return this.checkManager.getSetbackUtil();
    }

    public boolean wouldCollisionResultFlagGroundSpoof(double inputY, double collisionY) {
        boolean calculatedOnGround;
        boolean verticalCollision = inputY != collisionY;
        boolean bl = calculatedOnGround = verticalCollision && inputY < 0.0;
        if (this.exemptOnGround()) {
            return false;
        }
        if (inputY == -1.0E-7 && collisionY > -1.0E-7 && collisionY <= 0.0) {
            return false;
        }
        return calculatedOnGround != this.onGround;
    }

    public boolean exemptOnGround() {
        return this.compensatedEntities.getSelf().inVehicle() || Collections.max(this.uncertaintyHandler.pistonX) != 0.0 || Collections.max(this.uncertaintyHandler.pistonY) != 0.0 || Collections.max(this.uncertaintyHandler.pistonZ) != 0.0 || this.uncertaintyHandler.isStepMovement || this.isFlying || this.compensatedEntities.getSelf().isDead || this.isInBed || this.lastInBed || this.uncertaintyHandler.lastFlyingStatusChange.hasOccurredSince(30) || this.uncertaintyHandler.lastHardCollidingLerpingEntity.hasOccurredSince(3) || this.uncertaintyHandler.isOrWasNearGlitchyBlock;
    }

    public void handleMountVehicle(int vehicleID) {
        this.compensatedEntities.serverPlayerVehicle = vehicleID;
        TrackerData data = this.compensatedEntities.getTrackedEntity(vehicleID);
        if (data != null && PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9) && this.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) && (EntityTypes.isTypeInstanceOf(data.getEntityType(), EntityTypes.BOAT) || EntityTypes.isTypeInstanceOf(data.getEntityType(), EntityTypes.ABSTRACT_HORSE) || data.getEntityType() == EntityTypes.PIG || data.getEntityType() == EntityTypes.STRIDER)) {
            this.user.writePacket(new WrapperPlayServerEntityVelocity(vehicleID, new Vector3d()));
        }
        this.sendTransaction();
        this.latencyUtils.addRealTimeTask(this.lastTransactionSent.get(), () -> {
            this.vehicleData.wasVehicleSwitch = true;
        });
    }

    public int getRidingVehicleId() {
        return this.compensatedEntities.getPacketEntityID(this.compensatedEntities.getSelf().getRiding());
    }

    public void handleDismountVehicle(PacketSendEvent event) {
        this.sendTransaction();
        this.compensatedEntities.serverPlayerVehicle = null;
        event.getTasksAfterSend().add(() -> {
            int ridingId;
            TrackerData data;
            if (this.compensatedEntities.getSelf().getRiding() != null && (data = this.compensatedEntities.serverPositionsMap.get(ridingId = this.getRidingVehicleId())) != null) {
                this.user.writePacket(new WrapperPlayServerEntityTeleport(ridingId, new Vector3d(data.getX(), data.getY(), data.getZ()), data.getXRot(), data.getYRot(), false));
            }
        });
        this.latencyUtils.addRealTimeTask(this.lastTransactionSent.get(), () -> {
            this.vehicleData.wasVehicleSwitch = true;
            if (this.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_14)) {
                this.compensatedEntities.hasSprintingAttributeEnabled = false;
            }
        });
    }

    public boolean canUseGameMasterBlocks() {
        return this.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_10) || this.gamemode == GameMode.CREATIVE && this.compensatedEntities.getSelf().getOpLevel() >= 2;
    }

    @Override
    public void runSafely(Runnable runnable2) {
        ChannelHelper.runInEventLoop(this.user.getChannel(), runnable2);
    }

    @Override
    public String getName() {
        return this.user.getName();
    }

    @Override
    public UUID getUniqueId() {
        return this.user.getProfile().getUUID();
    }

    @Override
    public String getBrand() {
        return this.checkManager.getPacketCheck(ClientBrand.class).getBrand();
    }

    @Override
    public String getVersionName() {
        return this.getClientVersion().getReleaseName();
    }

    @Override
    public double getHorizontalSensitivity() {
        return this.checkManager.getRotationCheck(AimProcessor.class).sensitivityX;
    }

    @Override
    public double getVerticalSensitivity() {
        return this.checkManager.getRotationCheck(AimProcessor.class).sensitivityY;
    }

    @Override
    public boolean isVanillaMath() {
        return this.trigHandler.isVanillaMath();
    }

    @Override
    public Collection<? extends AbstractCheck> getChecks() {
        return this.checkManager.allChecks.values();
    }
}

