/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.manager;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.manager.init.Initable;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class SpectateManager
implements Initable {
    private final Map<UUID, PreviousState> spectatingPlayers = new ConcurrentHashMap<UUID, PreviousState>();
    private final Set<UUID> hiddenPlayers = ConcurrentHashMap.newKeySet();
    private final Set<String> allowedWorlds = ConcurrentHashMap.newKeySet();
    private boolean checkWorld = false;

    @Override
    public void start() {
        this.allowedWorlds.clear();
        this.allowedWorlds.addAll(GrimAPI.INSTANCE.getConfigManager().getConfig().getStringListElse("spectators.allowed-worlds", new ArrayList<String>()));
        this.checkWorld = !this.allowedWorlds.isEmpty() && !new ArrayList<String>(this.allowedWorlds).get(0).isEmpty();
    }

    public boolean isSpectating(UUID uuid) {
        return this.spectatingPlayers.containsKey(uuid);
    }

    public boolean shouldHidePlayer(GrimPlayer receiver, WrapperPlayServerPlayerInfo.PlayerData playerData) {
        return playerData.getUser() != null && !Objects.equals(playerData.getUser().getUUID(), receiver.playerUUID) && (this.spectatingPlayers.containsKey(playerData.getUser().getUUID()) || this.hiddenPlayers.contains(playerData.getUser().getUUID())) && (receiver.playerUUID == null || !this.spectatingPlayers.containsKey(receiver.playerUUID) && !this.hiddenPlayers.contains(receiver.playerUUID)) && (!this.checkWorld || receiver.bukkitPlayer != null && this.allowedWorlds.contains(receiver.bukkitPlayer.getWorld().getName()));
    }

    public boolean enable(Player player) {
        if (this.spectatingPlayers.containsKey(player.getUniqueId())) {
            return false;
        }
        this.spectatingPlayers.put(player.getUniqueId(), new PreviousState(player.getGameMode(), player.getLocation()));
        return true;
    }

    public void onLogin(Player player) {
        this.hiddenPlayers.add(player.getUniqueId());
    }

    public void onQuit(Player player) {
        this.hiddenPlayers.remove(player.getUniqueId());
        this.handlePlayerStopSpectating(player.getUniqueId());
    }

    public void disable(Player player, boolean teleportBack) {
        PreviousState previousState = this.spectatingPlayers.get(player.getUniqueId());
        if (previousState != null) {
            if (teleportBack) {
                player.teleport(previousState.location);
            }
            player.setGameMode(previousState.gameMode);
        }
        this.handlePlayerStopSpectating(player.getUniqueId());
    }

    public void handlePlayerStopSpectating(UUID uuid) {
        this.spectatingPlayers.remove(uuid);
    }

    private static class PreviousState {
        private final GameMode gameMode;
        private final Location location;

        public PreviousState(GameMode gameMode, Location location) {
            this.gameMode = gameMode;
            this.location = location;
        }
    }
}

