/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.manager;

import ac.grim.grimac.AbstractCheck;
import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.checks.Check;
import ac.grim.grimac.events.CommandExecuteEvent;
import ac.grim.grimac.events.packets.ProxyAlertMessenger;
import ac.grim.grimac.manager.ParsedCommand;
import ac.grim.grimac.manager.PunishGroup;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.configuralize.DynamicConfig;
import ac.grim.grimac.utils.anticheat.LogUtil;
import ac.grim.grimac.utils.anticheat.MessageUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class PunishmentManager {
    GrimPlayer player;
    List<PunishGroup> groups = new ArrayList<PunishGroup>();

    public PunishmentManager(GrimPlayer player) {
        this.player = player;
        this.reload();
    }

    public void reload() {
        DynamicConfig config = GrimAPI.INSTANCE.getConfigManager().getConfig();
        List<String> punish = config.getStringListElse("Punishments", new ArrayList<String>());
        try {
            this.groups.clear();
            for (AbstractCheck abstractCheck : this.player.checkManager.allChecks.values()) {
                abstractCheck.setEnabled(false);
            }
            for (Object object : punish) {
                LinkedHashMap map = (LinkedHashMap)object;
                List checks = map.getOrDefault("checks", new ArrayList());
                List commands = map.getOrDefault("commands", new ArrayList());
                int removeViolationsAfter = map.getOrDefault("remove-violations-after", 300);
                ArrayList<ParsedCommand> parsed = new ArrayList<ParsedCommand>();
                ArrayList<AbstractCheck> checksList = new ArrayList<AbstractCheck>();
                ArrayList<AbstractCheck> excluded = new ArrayList<AbstractCheck>();
                for (String command : checks) {
                    command = command.toLowerCase(Locale.ROOT);
                    boolean exclude = false;
                    if (command.startsWith("!")) {
                        exclude = true;
                        command = command.substring(1);
                    }
                    for (AbstractCheck check3 : this.player.checkManager.allChecks.values()) {
                        if (check3.getCheckName() == null || !check3.getCheckName().toLowerCase(Locale.ROOT).contains(command) && !check3.getAlternativeName().toLowerCase(Locale.ROOT).contains(command)) continue;
                        if (exclude) {
                            excluded.add(check3);
                            continue;
                        }
                        checksList.add(check3);
                        check3.setEnabled(true);
                    }
                    for (AbstractCheck check2 : excluded) {
                        checksList.remove(check2);
                    }
                }
                for (String command : commands) {
                    String firstNum = command.substring(0, command.indexOf(":"));
                    String secondNum = command.substring(command.indexOf(":"), command.indexOf(" "));
                    int threshold = Integer.parseInt(firstNum);
                    int interval = Integer.parseInt(secondNum.substring(1));
                    String commandString = command.substring(command.indexOf(" ") + 1);
                    parsed.add(new ParsedCommand(threshold, interval, commandString));
                }
                this.groups.add(new PunishGroup(checksList, parsed, removeViolationsAfter));
            }
        }
        catch (Exception e) {
            LogUtil.error("Error while loading punishments.yml! This is likely your fault!");
            e.printStackTrace();
        }
    }

    private String replaceAlertPlaceholders(String original, PunishGroup group, Check check2, String alertString, String verbose) {
        String vl = group.violations.values().stream().filter(e -> e == check2).count() + "";
        original = original.replace("[alert]", alertString);
        original = original.replace("[proxy]", alertString);
        original = original.replace("%check_name%", check2.getCheckName());
        original = original.replace("%vl%", vl);
        original = original.replace("%verbose%", verbose);
        original = MessageUtil.format(original);
        original = GrimAPI.INSTANCE.getExternalAPI().replaceVariables(this.player, original, true);
        return original;
    }

    public boolean handleAlert(GrimPlayer player, String verbose, Check check2) {
        String alertString = GrimAPI.INSTANCE.getConfigManager().getConfig().getStringElse("alerts-format", "%prefix% &f%player% &bfailed &f%check_name% &f(x&c%vl%&f) &7%verbose%");
        boolean testMode = GrimAPI.INSTANCE.getConfigManager().getConfig().getBooleanElse("test-mode", false);
        boolean sentDebug = false;
        for (PunishGroup group : this.groups) {
            if (!group.getChecks().contains(check2)) continue;
            int violationCount = group.getViolations().size();
            for (ParsedCommand command : group.getCommands()) {
                boolean inInterval;
                String cmd = this.replaceAlertPlaceholders(command.getCommand(), group, check2, alertString, verbose);
                if (GrimAPI.INSTANCE.getAlertManager().getEnabledVerbose().size() > 0 && command.command.equals("[alert]")) {
                    sentDebug = true;
                    for (Player bukkitPlayer : GrimAPI.INSTANCE.getAlertManager().getEnabledVerbose()) {
                        bukkitPlayer.sendMessage(cmd);
                    }
                    if (GrimAPI.INSTANCE.getConfigManager().getConfig().getBooleanElse("verbose.print-to-console", false)) {
                        LogUtil.console(cmd);
                    }
                }
                if (violationCount < command.getThreshold()) continue;
                boolean bl = command.getInterval() == 0 ? command.executeCount == 0 : (inInterval = violationCount % command.getInterval() == 0);
                if (inInterval) {
                    CommandExecuteEvent executeEvent = new CommandExecuteEvent(player, check2, cmd);
                    Bukkit.getPluginManager().callEvent((Event)executeEvent);
                    if (executeEvent.isCancelled()) continue;
                    if (command.command.equals("[webhook]")) {
                        String vl = group.violations.values().stream().filter(e -> e == check2).count() + "";
                        GrimAPI.INSTANCE.getDiscordManager().sendAlert(player, verbose, check2.getCheckName(), vl);
                        continue;
                    }
                    if (command.command.equals("[proxy]")) {
                        String proxyAlertString = GrimAPI.INSTANCE.getConfigManager().getConfig().getStringElse("alerts-format-proxy", "%prefix% &f[&cproxy&f] &f%player% &bfailed &f%check_name% &f(x&c%vl%&f) &7%verbose%");
                        proxyAlertString = this.replaceAlertPlaceholders(command.getCommand(), group, check2, proxyAlertString, verbose);
                        ProxyAlertMessenger.sendPluginMessage(proxyAlertString);
                        continue;
                    }
                    if (command.command.equals("[alert]")) {
                        sentDebug = true;
                        if (testMode) {
                            player.user.sendMessage(cmd);
                            continue;
                        }
                        cmd = "grim sendalert " + cmd;
                    }
                    String finalCmd = cmd;
                    Bukkit.getScheduler().runTask((Plugin)GrimAPI.INSTANCE.getPlugin(), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCmd));
                }
                command.setExecuteCount(command.getExecuteCount() + 1);
            }
        }
        return sentDebug;
    }

    public void handleViolation(Check check2) {
        for (PunishGroup group : this.groups) {
            if (!group.getChecks().contains(check2)) continue;
            long currentTime = System.currentTimeMillis();
            group.violations.put(currentTime, check2);
            group.violations.entrySet().removeIf(time -> currentTime - (Long)time.getKey() > (long)group.removeViolationsAfter);
        }
    }
}

