/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.manager;

import ac.grim.grimac.AbstractCheck;
import ac.grim.grimac.checks.impl.aim.AimDuplicateLook;
import ac.grim.grimac.checks.impl.aim.AimModulo360;
import ac.grim.grimac.checks.impl.aim.processor.AimProcessor;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsA;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsB;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsC;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsD;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsE;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsF;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsG;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsH;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsI;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsJ;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsK;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsL;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsM;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsN;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsO;
import ac.grim.grimac.checks.impl.badpackets.BadPacketsP;
import ac.grim.grimac.checks.impl.baritone.Baritone;
import ac.grim.grimac.checks.impl.combat.Reach;
import ac.grim.grimac.checks.impl.crash.CrashA;
import ac.grim.grimac.checks.impl.crash.CrashB;
import ac.grim.grimac.checks.impl.crash.CrashC;
import ac.grim.grimac.checks.impl.crash.CrashD;
import ac.grim.grimac.checks.impl.crash.CrashE;
import ac.grim.grimac.checks.impl.exploit.ExploitA;
import ac.grim.grimac.checks.impl.exploit.ExploitB;
import ac.grim.grimac.checks.impl.groundspoof.NoFallA;
import ac.grim.grimac.checks.impl.misc.ClientBrand;
import ac.grim.grimac.checks.impl.misc.FastBreak;
import ac.grim.grimac.checks.impl.movement.EntityControl;
import ac.grim.grimac.checks.impl.movement.NegativeTimerCheck;
import ac.grim.grimac.checks.impl.movement.NoSlow;
import ac.grim.grimac.checks.impl.movement.PredictionRunner;
import ac.grim.grimac.checks.impl.movement.SetbackBlocker;
import ac.grim.grimac.checks.impl.movement.TimerCheck;
import ac.grim.grimac.checks.impl.movement.VehiclePredictionRunner;
import ac.grim.grimac.checks.impl.movement.VehicleTimer;
import ac.grim.grimac.checks.impl.post.PostCheck;
import ac.grim.grimac.checks.impl.prediction.DebugHandler;
import ac.grim.grimac.checks.impl.prediction.NoFallB;
import ac.grim.grimac.checks.impl.prediction.OffsetHandler;
import ac.grim.grimac.checks.impl.prediction.Phase;
import ac.grim.grimac.checks.impl.scaffolding.AirLiquidPlace;
import ac.grim.grimac.checks.impl.scaffolding.DuplicateRotPlace;
import ac.grim.grimac.checks.impl.scaffolding.FabricatedPlace;
import ac.grim.grimac.checks.impl.scaffolding.FarPlace;
import ac.grim.grimac.checks.impl.scaffolding.PositionPlace;
import ac.grim.grimac.checks.impl.scaffolding.RotationPlace;
import ac.grim.grimac.checks.impl.velocity.ExplosionHandler;
import ac.grim.grimac.checks.impl.velocity.KnockbackHandler;
import ac.grim.grimac.checks.type.BlockPlaceCheck;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.checks.type.PositionCheck;
import ac.grim.grimac.checks.type.PostPredictionCheck;
import ac.grim.grimac.checks.type.RotationCheck;
import ac.grim.grimac.checks.type.VehicleCheck;
import ac.grim.grimac.events.packets.PacketChangeGameState;
import ac.grim.grimac.events.packets.PacketEntityReplication;
import ac.grim.grimac.events.packets.PacketPlayerAbilities;
import ac.grim.grimac.events.packets.PacketWorldBorder;
import ac.grim.grimac.manager.LastInstanceManager;
import ac.grim.grimac.manager.SetbackTeleportUtil;
import ac.grim.grimac.manager.init.start.SuperDebug;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.predictionengine.GhostBlockDetector;
import ac.grim.grimac.predictionengine.SneakingEstimator;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.utils.anticheat.update.BlockPlace;
import ac.grim.grimac.utils.anticheat.update.PositionUpdate;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;
import ac.grim.grimac.utils.anticheat.update.RotationUpdate;
import ac.grim.grimac.utils.anticheat.update.VehiclePositionUpdate;
import ac.grim.grimac.utils.latency.CompensatedCooldown;
import ac.grim.grimac.utils.latency.CompensatedFireworks;
import ac.grim.grimac.utils.latency.CompensatedInventory;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;

public class CheckManager {
    ClassToInstanceMap<PacketCheck> packetChecks;
    ClassToInstanceMap<PositionCheck> positionCheck;
    ClassToInstanceMap<RotationCheck> rotationCheck;
    ClassToInstanceMap<VehicleCheck> vehicleCheck;
    ClassToInstanceMap<PacketCheck> prePredictionChecks;
    ClassToInstanceMap<BlockPlaceCheck> blockPlaceCheck;
    ClassToInstanceMap<PostPredictionCheck> postPredictionCheck;
    public ClassToInstanceMap<AbstractCheck> allChecks;

    public CheckManager(GrimPlayer player) {
        this.packetChecks = new ImmutableClassToInstanceMap.Builder().put(Reach.class, (Object)new Reach(player)).put(PacketEntityReplication.class, (Object)new PacketEntityReplication(player)).put(PacketChangeGameState.class, (Object)new PacketChangeGameState(player)).put(CompensatedInventory.class, (Object)new CompensatedInventory(player)).put(PacketPlayerAbilities.class, (Object)new PacketPlayerAbilities(player)).put(PacketWorldBorder.class, (Object)new PacketWorldBorder(player)).put(ClientBrand.class, (Object)new ClientBrand(player)).put(NoFallA.class, (Object)new NoFallA(player)).put(BadPacketsO.class, (Object)new BadPacketsO(player)).put(BadPacketsA.class, (Object)new BadPacketsA(player)).put(BadPacketsB.class, (Object)new BadPacketsB(player)).put(BadPacketsC.class, (Object)new BadPacketsC(player)).put(BadPacketsD.class, (Object)new BadPacketsD(player)).put(BadPacketsE.class, (Object)new BadPacketsE(player)).put(BadPacketsF.class, (Object)new BadPacketsF(player)).put(BadPacketsG.class, (Object)new BadPacketsG(player)).put(BadPacketsH.class, (Object)new BadPacketsH(player)).put(BadPacketsI.class, (Object)new BadPacketsI(player)).put(BadPacketsJ.class, (Object)new BadPacketsJ(player)).put(BadPacketsK.class, (Object)new BadPacketsK(player)).put(BadPacketsL.class, (Object)new BadPacketsL(player)).put(BadPacketsN.class, (Object)new BadPacketsN(player)).put(BadPacketsP.class, (Object)new BadPacketsP(player)).put(PostCheck.class, (Object)new PostCheck(player)).put(FastBreak.class, (Object)new FastBreak(player)).put(SetbackBlocker.class, (Object)new SetbackBlocker(player)).build();
        this.positionCheck = new ImmutableClassToInstanceMap.Builder().put(PredictionRunner.class, (Object)new PredictionRunner(player)).put(CompensatedCooldown.class, (Object)new CompensatedCooldown(player)).build();
        this.rotationCheck = new ImmutableClassToInstanceMap.Builder().put(AimProcessor.class, (Object)new AimProcessor(player)).put(AimModulo360.class, (Object)new AimModulo360(player)).put(AimDuplicateLook.class, (Object)new AimDuplicateLook(player)).put(Baritone.class, (Object)new Baritone(player)).build();
        this.vehicleCheck = new ImmutableClassToInstanceMap.Builder().put(VehiclePredictionRunner.class, (Object)new VehiclePredictionRunner(player)).build();
        this.postPredictionCheck = new ImmutableClassToInstanceMap.Builder().put(NegativeTimerCheck.class, (Object)new NegativeTimerCheck(player)).put(ExplosionHandler.class, (Object)new ExplosionHandler(player)).put(KnockbackHandler.class, (Object)new KnockbackHandler(player)).put(GhostBlockDetector.class, (Object)new GhostBlockDetector(player)).put(Phase.class, (Object)new Phase(player)).put(NoFallB.class, (Object)new NoFallB(player)).put(OffsetHandler.class, (Object)new OffsetHandler(player)).put(SuperDebug.class, (Object)new SuperDebug(player)).put(DebugHandler.class, (Object)new DebugHandler(player)).put(EntityControl.class, (Object)new EntityControl(player)).put(BadPacketsM.class, (Object)new BadPacketsM(player)).put(NoSlow.class, (Object)new NoSlow(player)).put(SetbackTeleportUtil.class, (Object)new SetbackTeleportUtil(player)).put(CompensatedFireworks.class, (Object)player.compensatedFireworks).put(SneakingEstimator.class, (Object)new SneakingEstimator(player)).put(LastInstanceManager.class, (Object)player.lastInstanceManager).build();
        this.blockPlaceCheck = new ImmutableClassToInstanceMap.Builder().put(AirLiquidPlace.class, (Object)new AirLiquidPlace(player)).put(FarPlace.class, (Object)new FarPlace(player)).put(FabricatedPlace.class, (Object)new FabricatedPlace(player)).put(PositionPlace.class, (Object)new PositionPlace(player)).put(RotationPlace.class, (Object)new RotationPlace(player)).put(DuplicateRotPlace.class, (Object)new DuplicateRotPlace(player)).build();
        this.prePredictionChecks = new ImmutableClassToInstanceMap.Builder().put(TimerCheck.class, (Object)new TimerCheck(player)).put(CrashA.class, (Object)new CrashA(player)).put(CrashB.class, (Object)new CrashB(player)).put(CrashC.class, (Object)new CrashC(player)).put(CrashD.class, (Object)new CrashD(player)).put(CrashE.class, (Object)new CrashE(player)).put(ExploitA.class, (Object)new ExploitA(player)).put(ExploitB.class, (Object)new ExploitB(player)).put(VehicleTimer.class, (Object)new VehicleTimer(player)).build();
        this.allChecks = new ImmutableClassToInstanceMap.Builder().putAll(this.packetChecks).putAll(this.positionCheck).putAll(this.rotationCheck).putAll(this.vehicleCheck).putAll(this.postPredictionCheck).putAll(this.blockPlaceCheck).putAll(this.prePredictionChecks).build();
    }

    public <T extends PositionCheck> T getPositionCheck(Class<T> check2) {
        return (T)((PositionCheck)this.positionCheck.get(check2));
    }

    public <T extends RotationCheck> T getRotationCheck(Class<T> check2) {
        return (T)((RotationCheck)this.rotationCheck.get(check2));
    }

    public <T extends VehicleCheck> T getVehicleCheck(Class<T> check2) {
        return (T)((VehicleCheck)this.vehicleCheck.get(check2));
    }

    public void onPrePredictionReceivePacket(PacketReceiveEvent packet) {
        this.prePredictionChecks.values().forEach(check2 -> check2.onPacketReceive(packet));
    }

    public void onPacketReceive(PacketReceiveEvent packet) {
        this.packetChecks.values().forEach(packetCheck -> packetCheck.onPacketReceive(packet));
        this.postPredictionCheck.values().forEach(postPredictionCheck -> postPredictionCheck.onPacketReceive(packet));
    }

    public void onPacketSend(PacketSendEvent packet) {
        this.prePredictionChecks.values().forEach(check2 -> check2.onPacketSend(packet));
        this.packetChecks.values().forEach(packetCheck -> packetCheck.onPacketSend(packet));
        this.postPredictionCheck.values().forEach(postPredictionCheck -> postPredictionCheck.onPacketSend(packet));
    }

    public void onPositionUpdate(PositionUpdate position) {
        this.positionCheck.values().forEach(positionCheck -> positionCheck.onPositionUpdate(position));
        this.packetChecks.values().forEach(packetCheck -> packetCheck.onPositionUpdate(position));
    }

    public void onRotationUpdate(RotationUpdate rotation) {
        this.rotationCheck.values().forEach(rotationCheck -> rotationCheck.process(rotation));
        this.blockPlaceCheck.values().forEach(blockPlaceCheck -> blockPlaceCheck.process(rotation));
    }

    public void onVehiclePositionUpdate(VehiclePositionUpdate update) {
        this.vehicleCheck.values().forEach(vehicleCheck -> vehicleCheck.process(update));
    }

    public void onPredictionFinish(PredictionComplete complete) {
        this.postPredictionCheck.values().forEach(predictionCheck -> predictionCheck.onPredictionComplete(complete));
    }

    public void onBlockPlace(BlockPlace place) {
        this.blockPlaceCheck.values().forEach(check2 -> check2.onBlockPlace(place));
    }

    public void onPostFlyingBlockPlace(BlockPlace place) {
        this.blockPlaceCheck.values().forEach(check2 -> check2.onPostFlyingBlockPlace(place));
    }

    public ExplosionHandler getExplosionHandler() {
        return this.getPostPredictionCheck(ExplosionHandler.class);
    }

    public <T extends PacketCheck> T getPacketCheck(Class<T> check2) {
        return (T)((PacketCheck)this.packetChecks.get(check2));
    }

    public <T extends PacketCheck> T getPrePredictionCheck(Class<T> check2) {
        return (T)((PacketCheck)this.prePredictionChecks.get(check2));
    }

    public PacketEntityReplication getEntityReplication() {
        return this.getPacketCheck(PacketEntityReplication.class);
    }

    public NoFallA getNoFall() {
        return this.getPacketCheck(NoFallA.class);
    }

    public KnockbackHandler getKnockbackHandler() {
        return this.getPostPredictionCheck(KnockbackHandler.class);
    }

    public CompensatedCooldown getCompensatedCooldown() {
        return this.getPositionCheck(CompensatedCooldown.class);
    }

    public NoSlow getNoSlow() {
        return this.getPostPredictionCheck(NoSlow.class);
    }

    public SetbackTeleportUtil getSetbackUtil() {
        return this.getPostPredictionCheck(SetbackTeleportUtil.class);
    }

    public DebugHandler getDebugHandler() {
        return this.getPostPredictionCheck(DebugHandler.class);
    }

    public OffsetHandler getOffsetHandler() {
        return this.getPostPredictionCheck(OffsetHandler.class);
    }

    public <T extends PostPredictionCheck> T getPostPredictionCheck(Class<T> check2) {
        return (T)((PostPredictionCheck)this.postPredictionCheck.get(check2));
    }
}

