/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.manager;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.utils.anticheat.MessageUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.bukkit.entity.Player;

public class AlertManager {
    private final Set<Player> enabledAlerts = new CopyOnWriteArraySet<Player>(new HashSet());
    private final Set<Player> enabledVerbose = new CopyOnWriteArraySet<Player>(new HashSet());

    public void toggleAlerts(Player player) {
        if (!this.enabledAlerts.remove(player)) {
            String alertString = GrimAPI.INSTANCE.getConfigManager().getConfig().getStringElse("alerts-enabled", "%prefix% &fAlerts enabled");
            alertString = MessageUtil.format(alertString);
            player.sendMessage(alertString);
            this.enabledAlerts.add(player);
        } else {
            String alertString = GrimAPI.INSTANCE.getConfigManager().getConfig().getStringElse("alerts-disabled", "%prefix% &fAlerts disabled");
            alertString = MessageUtil.format(alertString);
            player.sendMessage(alertString);
        }
    }

    public void toggleVerbose(Player player) {
        if (!this.enabledVerbose.remove(player)) {
            String alertString = GrimAPI.INSTANCE.getConfigManager().getConfig().getStringElse("verbose-enabled", "%prefix% &fVerbose enabled");
            alertString = MessageUtil.format(alertString);
            player.sendMessage(alertString);
            this.enabledVerbose.add(player);
        } else {
            String alertString = GrimAPI.INSTANCE.getConfigManager().getConfig().getStringElse("verbose-disabled", "%prefix% &fVerbose disabled");
            alertString = MessageUtil.format(alertString);
            player.sendMessage(alertString);
        }
    }

    public void handlePlayerQuit(Player player) {
        this.enabledAlerts.remove(player);
        this.enabledVerbose.remove(player);
    }

    public Set<Player> getEnabledAlerts() {
        return this.enabledAlerts;
    }

    public Set<Player> getEnabledVerbose() {
        return this.enabledVerbose;
    }
}

