/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.events.packets.patch;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerMultiBlockChange;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.math.GrimMath;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.plugin.Plugin;

public class ResyncWorldUtil {
    static HashMap<BlockData, Integer> blockDataToId = new HashMap();

    public static void resyncPositions(GrimPlayer player, SimpleCollisionBox box) {
        ResyncWorldUtil.resyncPositions(player, GrimMath.floor(box.minX), GrimMath.floor(box.minY), GrimMath.floor(box.minZ), GrimMath.ceil(box.maxX), GrimMath.ceil(box.maxY), GrimMath.ceil(box.maxZ));
    }

    public static void resyncPositions(GrimPlayer player, int minBlockX, int mY, int minBlockZ, int maxBlockX, int mxY, int maxBlockZ) {
        if (!(player.compensatedWorld.isChunkLoaded(minBlockX >> 4, minBlockZ >> 4) && player.compensatedWorld.isChunkLoaded(minBlockX >> 4, maxBlockZ >> 4) && player.compensatedWorld.isChunkLoaded(maxBlockX >> 4, minBlockZ >> 4) && player.compensatedWorld.isChunkLoaded(maxBlockX >> 4, maxBlockZ >> 4))) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)GrimAPI.INSTANCE.getPlugin(), () -> {
            boolean flat = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13);
            if (player.bukkitPlayer == null) {
                return;
            }
            if (!player.getSetbackTeleportUtil().hasAcceptedSpawnTeleport) {
                return;
            }
            if (!(player.bukkitPlayer.getWorld().isChunkLoaded(minBlockX >> 4, minBlockZ >> 4) && player.bukkitPlayer.getWorld().isChunkLoaded(minBlockX >> 4, maxBlockZ >> 4) && player.bukkitPlayer.getWorld().isChunkLoaded(maxBlockX >> 4, minBlockZ >> 4) && player.bukkitPlayer.getWorld().isChunkLoaded(maxBlockX >> 4, maxBlockZ >> 4))) {
                return;
            }
            int minSection = player.compensatedWorld.getMinHeight() >> 4;
            int minBlock = minSection << 4;
            int maxBlock = player.compensatedWorld.getMaxHeight() - 1;
            int minBlockY = Math.max(minBlock, mY);
            int maxBlockY = Math.min(maxBlock, mxY);
            int minChunkX = minBlockX >> 4;
            int maxChunkX = maxBlockX >> 4;
            int minChunkY = minBlockY >> 4;
            int maxChunkY = maxBlockY >> 4;
            int minChunkZ = minBlockZ >> 4;
            int maxChunkZ = maxBlockZ >> 4;
            for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
                int minZ = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                int maxZ = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                    int minX = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxX = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    Chunk chunk = player.bukkitPlayer.getWorld().getChunkAt(currChunkX, currChunkZ);
                    for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                        int minY = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                        int maxY = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                        int totalBlocks = (maxX - minX + 1) * (maxZ - minZ + 1) * (maxY - minY + 1);
                        WrapperPlayServerMultiBlockChange.EncodedBlock[] encodedBlocks = new WrapperPlayServerMultiBlockChange.EncodedBlock[totalBlocks];
                        int blockIndex = 0;
                        for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                            for (int currX = minX; currX <= maxX; ++currX) {
                                for (int currY = minY; currY <= maxY; ++currY) {
                                    Block block = chunk.getBlock(currX, currY | currChunkY << 4, currZ);
                                    int blockId = flat ? blockDataToId.computeIfAbsent(block.getBlockData(), data -> WrappedBlockState.getByString(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), data.getAsString(false)).getGlobalId()) : block.getType().getId() << 4 | block.getData();
                                    encodedBlocks[blockIndex++] = new WrapperPlayServerMultiBlockChange.EncodedBlock(blockId, currX, currY, currZ);
                                }
                            }
                        }
                        WrapperPlayServerMultiBlockChange packet = new WrapperPlayServerMultiBlockChange(new Vector3i(currChunkX, currChunkY, currChunkZ), true, encodedBlocks);
                        ChannelHelper.runInEventLoop(player.user.getChannel(), () -> player.user.sendPacket(packet));
                    }
                }
            }
        });
    }
}

