/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.events.packets;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketListenerAbstract;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketListenerPriority;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientSteerVehicle;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.data.packetentity.PacketEntityHorse;

public class PacketPlayerSteer
extends PacketListenerAbstract {
    public PacketPlayerSteer() {
        super(PacketListenerPriority.LOW);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.STEER_VEHICLE) {
            WrapperPlayClientSteerVehicle steer = new WrapperPlayClientSteerVehicle(event);
            GrimPlayer player = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
            if (player == null) {
                return;
            }
            float forwards = steer.getForward();
            float sideways = steer.getSideways();
            player.vehicleData.nextVehicleForward = forwards;
            player.vehicleData.nextVehicleHorizontal = sideways;
            PacketEntity riding = player.compensatedEntities.getSelf().getRiding();
            if (player.packetStateData.receivedSteerVehicle && riding != null) {
                if ((EntityTypes.isTypeInstanceOf(riding.type, EntityTypes.BOAT) || riding instanceof PacketEntityHorse) && riding.passengers.get(0) == player.compensatedEntities.getSelf() && player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) && PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
                    return;
                }
                player.compensatedWorld.tickPlayerInPistonPushingArea();
                player.compensatedEntities.tick();
                player.vehicleData.lastDummy = true;
                int controllingEntityId = player.compensatedEntities.getSelf().inVehicle() ? player.getRidingVehicleId() : player.entityID;
                player.firstBreadKB = player.checkManager.getKnockbackHandler().calculateFirstBreadKnockback(controllingEntityId, player.lastTransactionReceived.get());
                player.likelyKB = player.checkManager.getKnockbackHandler().calculateRequiredKB(controllingEntityId, player.lastTransactionReceived.get());
                if (player.firstBreadKB != null) {
                    player.clientVelocity = player.firstBreadKB.vector;
                }
                if (player.likelyKB != null) {
                    player.clientVelocity = player.likelyKB.vector;
                }
                player.firstBreadExplosion = player.checkManager.getExplosionHandler().getFirstBreadAddedExplosion(player.lastTransactionReceived.get());
                player.likelyExplosions = player.checkManager.getExplosionHandler().getPossibleExplosions(player.lastTransactionReceived.get());
                player.checkManager.getExplosionHandler().forceExempt();
                player.checkManager.getKnockbackHandler().forceExempt();
                player.lastX = player.x;
                player.lastY = player.y;
                player.lastZ = player.z;
                SimpleCollisionBox vehiclePos = player.compensatedEntities.getSelf().getRiding().getPossibleCollisionBoxes();
                player.x = (vehiclePos.minX + vehiclePos.maxX) / 2.0;
                player.y = (vehiclePos.minY + vehiclePos.maxY) / 2.0;
                player.z = (vehiclePos.minZ + vehiclePos.maxZ) / 2.0;
                if (player.isSprinting != player.lastSprinting) {
                    player.compensatedEntities.hasSprintingAttributeEnabled = player.isSprinting;
                }
                player.lastSprinting = player.isSprinting;
            }
            player.packetStateData.receivedSteerVehicle = true;
        }
    }
}

