/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.events.packets;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.checks.impl.movement.NoSlow;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketListenerAbstract;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketListenerPriority;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.enchantment.type.EnchantmentTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.DiggingAction;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.GameMode;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.InteractionHand;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientHeldItemChange;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientUseItem;

public class PacketPlayerDigging
extends PacketListenerAbstract {
    public PacketPlayerDigging() {
        super(PacketListenerPriority.LOW);
    }

    public static void handleUseItem(GrimPlayer player, ItemStack item, InteractionHand hand) {
        if (item != null) {
            ItemType material = item.getType();
            if (player.checkManager.getCompensatedCooldown().hasMaterial(material)) {
                player.packetStateData.slowedByUsingItem = false;
                return;
            }
            if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_15) || player.gamemode != GameMode.CREATIVE && material.hasAttribute(ItemTypes.ItemAttribute.EDIBLE) || material == ItemTypes.POTION || material == ItemTypes.MILK_BUCKET) {
                if (item.getType() == ItemTypes.SPLASH_POTION) {
                    return;
                }
                if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_9) && item.getLegacyData() > 16384) {
                    return;
                }
                if (material == ItemTypes.POTION || material == ItemTypes.MILK_BUCKET || material == ItemTypes.GOLDEN_APPLE || material == ItemTypes.ENCHANTED_GOLDEN_APPLE || material == ItemTypes.HONEY_BOTTLE || material == ItemTypes.SUSPICIOUS_STEW || material == ItemTypes.CHORUS_FRUIT) {
                    player.packetStateData.slowedByUsingItem = true;
                    player.packetStateData.eatingHand = hand;
                    return;
                }
                if (item.getType().hasAttribute(ItemTypes.ItemAttribute.EDIBLE) && (player.bukkitPlayer != null && player.food < 20 || player.gamemode == GameMode.CREATIVE)) {
                    player.packetStateData.slowedByUsingItem = true;
                    player.packetStateData.eatingHand = hand;
                    return;
                }
                player.packetStateData.slowedByUsingItem = false;
            }
            if (material == ItemTypes.SHIELD) {
                player.packetStateData.slowedByUsingItem = true;
                player.packetStateData.eatingHand = hand;
                return;
            }
            if (material == ItemTypes.CROSSBOW && item.getNBT().getBoolean("Charged")) {
                player.packetStateData.slowedByUsingItem = false;
                return;
            }
            if (material == ItemTypes.TRIDENT) {
                player.packetStateData.slowedByUsingItem = item.getEnchantmentLevel(EnchantmentTypes.RIPTIDE, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()) <= 0;
                player.packetStateData.eatingHand = hand;
            }
            if (material == ItemTypes.BOW || material == ItemTypes.CROSSBOW) {
                player.packetStateData.slowedByUsingItem = false;
            }
            if (material.hasAttribute(ItemTypes.ItemAttribute.SWORD)) {
                if (player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_8)) {
                    player.packetStateData.slowedByUsingItem = true;
                } else if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_9)) {
                    player.packetStateData.slowedByUsingItem = false;
                }
            }
        } else {
            player.packetStateData.slowedByUsingItem = false;
        }
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        GrimPlayer player;
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING) {
            player = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
            if (player == null) {
                return;
            }
            WrapperPlayClientPlayerDigging dig = new WrapperPlayClientPlayerDigging(event);
            if (dig.getAction() == DiggingAction.RELEASE_USE_ITEM) {
                player.packetStateData.slowedByUsingItem = false;
                player.packetStateData.slowedByUsingItemTransaction = player.lastTransactionReceived.get();
                if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13)) {
                    ItemStack main = player.getInventory().getHeldItem();
                    ItemStack off = player.getInventory().getOffHand();
                    int j = 0;
                    if (main.getType() == ItemTypes.TRIDENT) {
                        j = main.getEnchantmentLevel(EnchantmentTypes.RIPTIDE, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
                    } else if (off.getType() == ItemTypes.TRIDENT) {
                        j = off.getEnchantmentLevel(EnchantmentTypes.RIPTIDE, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
                    }
                    if (j > 0) {
                        player.packetStateData.tryingToRiptide = true;
                    }
                }
            }
        }
        if (event.getPacketType() == PacketType.Play.Client.HELD_ITEM_CHANGE) {
            player = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
            if (player == null) {
                return;
            }
            WrapperPlayClientHeldItemChange slot = new WrapperPlayClientHeldItemChange(event);
            if (slot.getSlot() > 8) {
                return;
            }
            if (player.packetStateData.lastSlotSelected != slot.getSlot()) {
                player.packetStateData.slowedByUsingItem = false;
                PacketEvents.getAPI().getProtocolManager().receivePacketSilently(player.user.getChannel(), new WrapperPlayClientPlayerDigging(DiggingAction.RELEASE_USE_ITEM, new Vector3i(), BlockFace.DOWN, 0));
                player.checkManager.getPostPredictionCheck(NoSlow.class).didSlotChangeLastTick = true;
            }
            player.packetStateData.lastSlotSelected = slot.getSlot();
        }
        if (event.getPacketType() == PacketType.Play.Client.USE_ITEM) {
            WrapperPlayClientUseItem place = new WrapperPlayClientUseItem(event);
            GrimPlayer player2 = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
            if (player2 == null) {
                return;
            }
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_8) && player2.gamemode == GameMode.SPECTATOR) {
                return;
            }
            player2.packetStateData.slowedByUsingItemTransaction = player2.lastTransactionReceived.get();
            ItemStack item = place.getHand() == InteractionHand.MAIN_HAND ? player2.getInventory().getHeldItem() : player2.getInventory().getOffHand();
            PacketPlayerDigging.handleUseItem(player2, item, place.getHand());
        }
    }
}

