/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.events.packets;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketListenerAbstract;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketListenerPriority;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPong;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientWindowConfirmation;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPing;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowConfirmation;
import ac.grim.grimac.utils.data.Pair;

public class PacketPingListener
extends PacketListenerAbstract {
    public PacketPingListener() {
        super(PacketListenerPriority.LOWEST);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        WrapperPlayClientPong pong;
        GrimPlayer player;
        WrapperPlayClientWindowConfirmation transaction;
        short id;
        if (event.getPacketType() == PacketType.Play.Client.WINDOW_CONFIRMATION && (id = (transaction = new WrapperPlayClientWindowConfirmation(event)).getActionId()) <= 0) {
            player = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
            if (player == null) {
                return;
            }
            if (player.addTransactionResponse(id)) {
                event.setCancelled(true);
            }
        }
        if (event.getPacketType() == PacketType.Play.Client.PONG && (id = (pong = new WrapperPlayClientPong(event)).getId()) == (short)id) {
            player = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
            if (player == null) {
                return;
            }
            if (player.addTransactionResponse(id)) {
                event.setCancelled(true);
            }
        }
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        WrapperPlayServerPing pong;
        GrimPlayer player;
        WrapperPlayServerWindowConfirmation confirmation;
        short id;
        if (event.getPacketType() == PacketType.Play.Server.WINDOW_CONFIRMATION && (id = (confirmation = new WrapperPlayServerWindowConfirmation(event)).getActionId()) <= 0) {
            player = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
            if (player == null) {
                return;
            }
            if (player.didWeSendThatTrans.remove((Object)id)) {
                player.transactionsSent.add(new Pair<Short, Long>(id, System.nanoTime()));
                player.lastTransactionSent.getAndIncrement();
            }
        }
        if (event.getPacketType() == PacketType.Play.Server.PING && (id = (pong = new WrapperPlayServerPing(event)).getId()) == (short)id) {
            player = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
            if (player == null) {
                return;
            }
            Short shortID = id;
            if (player.didWeSendThatTrans.remove(shortID)) {
                player.transactionsSent.add(new Pair<Short, Long>(shortID, System.nanoTime()));
                player.lastTransactionSent.getAndIncrement();
            }
        }
    }
}

