/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.events.packets;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.potion.PotionType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerFlying;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerAttachEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEffect;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMove;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMoveAndRotation;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRotation;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityStatus;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerRemoveEntityEffect;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetPassengers;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetSlot;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnLivingEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowItems;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.viaversion.ViaVersionUtil;
import ac.grim.grimac.utils.anticheat.LogUtil;
import ac.grim.grimac.utils.data.TrackerData;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.data.packetentity.PacketEntityHook;
import ac.grim.grimac.utils.data.packetentity.PacketEntityTrackXRot;
import java.util.ArrayList;
import java.util.List;

public class PacketEntityReplication
extends Check
implements PacketCheck {
    private boolean hasSentPreWavePacket = true;
    private final List<Integer> despawnedEntitiesThisTransaction = new ArrayList<Integer>();

    public PacketEntityReplication(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (WrapperPlayClientPlayerFlying.isFlying(event.getPacketType())) {
            if (this.player.packetStateData.lastPacketWasTeleport || this.player.packetStateData.lastPacketWasOnePointSeventeenDuplicate) {
                return;
            }
            boolean isTickingReliably = this.player.isTickingReliablyFor(3);
            PacketEntity playerVehicle = this.player.compensatedEntities.getSelf().getRiding();
            for (PacketEntity entity : this.player.compensatedEntities.entityMap.values()) {
                if (entity == playerVehicle && !this.player.vehicleData.lastDummy) {
                    entity.setPositionRaw(entity.getPossibleCollisionBoxes());
                    continue;
                }
                entity.onMovement(isTickingReliably);
            }
        }
        if (event.getPacketType() == PacketType.Play.Server.PING || event.getPacketType() == PacketType.Play.Server.WINDOW_CONFIRMATION) {
            this.despawnedEntitiesThisTransaction.clear();
        }
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        WrapperPlayServerWindowItems items;
        WrapperPlayServerSetSlot slot;
        PacketWrapper effect;
        PacketWrapper move;
        PacketWrapper packetOutEntity;
        if (event.getPacketType() == PacketType.Play.Server.SPAWN_LIVING_ENTITY) {
            packetOutEntity = new WrapperPlayServerSpawnLivingEntity(event);
            this.addEntity(((WrapperPlayServerSpawnLivingEntity)packetOutEntity).getEntityId(), ((WrapperPlayServerSpawnLivingEntity)packetOutEntity).getEntityType(), ((WrapperPlayServerSpawnLivingEntity)packetOutEntity).getPosition(), ((WrapperPlayServerSpawnLivingEntity)packetOutEntity).getYaw(), ((WrapperPlayServerSpawnLivingEntity)packetOutEntity).getPitch(), ((WrapperPlayServerSpawnLivingEntity)packetOutEntity).getEntityMetadata(), 0);
        }
        if (event.getPacketType() == PacketType.Play.Server.SPAWN_ENTITY) {
            packetOutEntity = new WrapperPlayServerSpawnEntity(event);
            this.addEntity(((WrapperPlayServerSpawnEntity)packetOutEntity).getEntityId(), ((WrapperPlayServerSpawnEntity)packetOutEntity).getEntityType(), ((WrapperPlayServerSpawnEntity)packetOutEntity).getPosition(), ((WrapperPlayServerSpawnEntity)packetOutEntity).getYaw(), ((WrapperPlayServerSpawnEntity)packetOutEntity).getPitch(), null, ((WrapperPlayServerSpawnEntity)packetOutEntity).getData());
        }
        if (event.getPacketType() == PacketType.Play.Server.SPAWN_PLAYER) {
            packetOutEntity = new WrapperPlayServerSpawnPlayer(event);
            this.addEntity(((WrapperPlayServerSpawnPlayer)packetOutEntity).getEntityId(), EntityTypes.PLAYER, ((WrapperPlayServerSpawnPlayer)packetOutEntity).getPosition(), ((WrapperPlayServerSpawnPlayer)packetOutEntity).getYaw(), ((WrapperPlayServerSpawnPlayer)packetOutEntity).getPitch(), ((WrapperPlayServerSpawnPlayer)packetOutEntity).getEntityMetadata(), 0);
        }
        if (event.getPacketType() == PacketType.Play.Server.ENTITY_RELATIVE_MOVE) {
            move = new WrapperPlayServerEntityRelativeMove(event);
            this.handleMoveEntity(event, ((WrapperPlayServerEntityRelativeMove)move).getEntityId(), ((WrapperPlayServerEntityRelativeMove)move).getDeltaX(), ((WrapperPlayServerEntityRelativeMove)move).getDeltaY(), ((WrapperPlayServerEntityRelativeMove)move).getDeltaZ(), null, null, true, true);
        }
        if (event.getPacketType() == PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION) {
            move = new WrapperPlayServerEntityRelativeMoveAndRotation(event);
            this.handleMoveEntity(event, ((WrapperPlayServerEntityRelativeMoveAndRotation)move).getEntityId(), ((WrapperPlayServerEntityRelativeMoveAndRotation)move).getDeltaX(), ((WrapperPlayServerEntityRelativeMoveAndRotation)move).getDeltaY(), ((WrapperPlayServerEntityRelativeMoveAndRotation)move).getDeltaZ(), Float.valueOf(((WrapperPlayServerEntityRelativeMoveAndRotation)move).getYaw() * 0.7111111f), Float.valueOf(((WrapperPlayServerEntityRelativeMoveAndRotation)move).getPitch() * 0.7111111f), true, true);
        }
        if (event.getPacketType() == PacketType.Play.Server.ENTITY_TELEPORT) {
            move = new WrapperPlayServerEntityTeleport(event);
            Vector3d pos = ((WrapperPlayServerEntityTeleport)move).getPosition();
            this.handleMoveEntity(event, ((WrapperPlayServerEntityTeleport)move).getEntityId(), pos.getX(), pos.getY(), pos.getZ(), Float.valueOf(((WrapperPlayServerEntityTeleport)move).getYaw()), Float.valueOf(((WrapperPlayServerEntityTeleport)move).getPitch()), false, true);
        }
        if (event.getPacketType() == PacketType.Play.Server.ENTITY_ROTATION) {
            move = new WrapperPlayServerEntityRotation(event);
            this.handleMoveEntity(event, ((WrapperPlayServerEntityRotation)move).getEntityId(), 0.0, 0.0, 0.0, Float.valueOf(((WrapperPlayServerEntityRotation)move).getYaw() * 0.7111111f), Float.valueOf(((WrapperPlayServerEntityRotation)move).getPitch() * 0.7111111f), true, false);
        }
        if (event.getPacketType() == PacketType.Play.Server.ENTITY_METADATA) {
            WrapperPlayServerEntityMetadata entityMetadata = new WrapperPlayServerEntityMetadata(event);
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> this.player.compensatedEntities.updateEntityMetadata(entityMetadata.getEntityId(), entityMetadata.getEntityMetadata()));
        }
        if (event.getPacketType() == PacketType.Play.Server.ENTITY_EFFECT) {
            effect = new WrapperPlayServerEntityEffect(event);
            PotionType type = ((WrapperPlayServerEntityEffect)effect).getPotionType();
            if (this.player.getClientVersion().isOlderThan(ClientVersion.V_1_9) && ViaVersionUtil.isAvailable() && type.getId() > 23) {
                event.setCancelled(true);
                return;
            }
            if (this.player.getClientVersion().isOlderThan(ClientVersion.V_1_13) && ViaVersionUtil.isAvailable() && type.getId() == 30) {
                event.setCancelled(true);
                return;
            }
            if (this.isDirectlyAffectingPlayer(this.player, ((WrapperPlayServerEntityEffect)effect).getEntityId())) {
                event.getTasksAfterSend().add(this.player::sendTransaction);
            }
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> this.lambda$onPacketSend$1((WrapperPlayServerEntityEffect)effect, type));
        }
        if (event.getPacketType() == PacketType.Play.Server.REMOVE_ENTITY_EFFECT) {
            effect = new WrapperPlayServerRemoveEntityEffect(event);
            if (this.isDirectlyAffectingPlayer(this.player, ((WrapperPlayServerRemoveEntityEffect)effect).getEntityId())) {
                event.getTasksAfterSend().add(this.player::sendTransaction);
            }
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> this.lambda$onPacketSend$2((WrapperPlayServerRemoveEntityEffect)effect));
        }
        if (event.getPacketType() == PacketType.Play.Server.UPDATE_ATTRIBUTES) {
            WrapperPlayServerUpdateAttributes attributes = new WrapperPlayServerUpdateAttributes(event);
            int entityID = attributes.getEntityId();
            if (this.isDirectlyAffectingPlayer(this.player, entityID)) {
                this.player.sendTransaction();
            }
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> this.player.compensatedEntities.updateAttributes(entityID, attributes.getProperties()));
        }
        if (event.getPacketType() == PacketType.Play.Server.ENTITY_STATUS) {
            WrapperPlayServerEntityStatus status = new WrapperPlayServerEntityStatus(event);
            if (status.getStatus() == 3) {
                PacketEntity entity = this.player.compensatedEntities.getEntity(status.getEntityId());
                if (entity == null) {
                    return;
                }
                entity.isDead = true;
            }
            if (status.getStatus() == 9) {
                if (status.getEntityId() != this.player.entityID) {
                    return;
                }
                this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                    this.player.packetStateData.slowedByUsingItem = false;
                });
                this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get() + 1, () -> {
                    this.player.packetStateData.slowedByUsingItem = false;
                });
            }
            if (status.getStatus() == 31) {
                PacketEntity hook = this.player.compensatedEntities.getEntity(status.getEntityId());
                if (!(hook instanceof PacketEntityHook)) {
                    return;
                }
                PacketEntityHook hookEntity = (PacketEntityHook)hook;
                if (hookEntity.attached == this.player.entityID) {
                    this.player.sendTransaction();
                    this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> this.player.uncertaintyHandler.fishingRodPulls.add(hookEntity.owner));
                }
            }
            if (status.getStatus() >= 24 && status.getStatus() <= 28 && status.getEntityId() == this.player.entityID) {
                this.player.compensatedEntities.getSelf().setOpLevel(status.getStatus() - 24);
            }
        }
        if (event.getPacketType() == PacketType.Play.Server.SET_SLOT && (slot = new WrapperPlayServerSetSlot(event)).getWindowId() == 0) {
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                if (slot.getSlot() - 36 == this.player.packetStateData.lastSlotSelected) {
                    this.player.packetStateData.slowedByUsingItem = false;
                }
            });
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get() + 1, () -> {
                if (slot.getSlot() - 36 == this.player.packetStateData.lastSlotSelected) {
                    this.player.packetStateData.slowedByUsingItem = false;
                }
            });
        }
        if (event.getPacketType() == PacketType.Play.Server.WINDOW_ITEMS && (items = new WrapperPlayServerWindowItems(event)).getWindowId() == 0) {
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                this.player.packetStateData.slowedByUsingItem = false;
            });
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get() + 1, () -> {
                this.player.packetStateData.slowedByUsingItem = false;
            });
        }
        if (event.getPacketType() == PacketType.Play.Server.OPEN_WINDOW) {
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                this.player.packetStateData.slowedByUsingItem = false;
            });
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get() + 1, () -> {
                this.player.packetStateData.slowedByUsingItem = false;
            });
        }
        if (event.getPacketType() == PacketType.Play.Server.OPEN_HORSE_WINDOW) {
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                this.player.packetStateData.slowedByUsingItem = false;
            });
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get() + 1, () -> {
                this.player.packetStateData.slowedByUsingItem = false;
            });
        }
        if (event.getPacketType() == PacketType.Play.Server.SET_PASSENGERS) {
            WrapperPlayServerSetPassengers mount = new WrapperPlayServerSetPassengers(event);
            int vehicleID = mount.getEntityId();
            int[] passengers = mount.getPassengers();
            this.handleMountVehicle(event, vehicleID, passengers);
        }
        if (event.getPacketType() == PacketType.Play.Server.ATTACH_ENTITY) {
            WrapperPlayServerAttachEntity attach = new WrapperPlayServerAttachEntity(event);
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
                return;
            }
            if (!attach.isLeash()) {
                int vehicleID = attach.getHoldingId();
                int attachID = attach.getAttachedId();
                TrackerData trackerData = this.player.compensatedEntities.getTrackedEntity(attachID);
                if (trackerData != null) {
                    if (vehicleID == -1) {
                        vehicleID = trackerData.getLegacyPointEightMountedUpon();
                        this.handleMountVehicle(event, vehicleID, new int[0]);
                        return;
                    }
                    trackerData.setLegacyPointEightMountedUpon(vehicleID);
                    this.handleMountVehicle(event, vehicleID, new int[]{attachID});
                } else {
                    LogUtil.warn("Server sent an invalid attach entity packet for entity " + attach.getHoldingId() + " with passenger " + attach.getAttachedId() + "! The client ignores this.");
                }
            }
        }
        if (event.getPacketType() == PacketType.Play.Server.DESTROY_ENTITIES) {
            int[] destroyEntityIds;
            WrapperPlayServerDestroyEntities destroy = new WrapperPlayServerDestroyEntities(event);
            for (int entityID : destroyEntityIds = destroy.getEntityIds()) {
                this.despawnedEntitiesThisTransaction.add(entityID);
                this.player.compensatedEntities.serverPositionsMap.remove(entityID);
                if (this.player.compensatedEntities.serverPlayerVehicle == null || this.player.compensatedEntities.serverPlayerVehicle != entityID) continue;
                this.player.compensatedEntities.serverPlayerVehicle = null;
            }
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get() + 1, () -> {
                for (int integer : destroyEntityIds) {
                    this.player.compensatedEntities.removeEntity(integer);
                    this.player.compensatedFireworks.removeFirework(integer);
                }
            });
        }
    }

    private void handleMountVehicle(PacketSendEvent event, int vehicleID, int[] passengers) {
        boolean wasInVehicle = this.player.getRidingVehicleId() == vehicleID;
        boolean inThisVehicle = false;
        for (int passenger : passengers) {
            boolean bl = inThisVehicle = passenger == this.player.entityID;
            if (inThisVehicle) break;
        }
        if (inThisVehicle && !wasInVehicle) {
            this.player.handleMountVehicle(vehicleID);
        }
        if (!inThisVehicle && wasInVehicle) {
            this.player.handleDismountVehicle(event);
        }
        this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
            PacketEntity vehicle = this.player.compensatedEntities.getEntity(vehicleID);
            if (vehicle == null) {
                return;
            }
            for (PacketEntity passenger : new ArrayList<PacketEntity>(vehicle.passengers)) {
                passenger.eject();
            }
            for (Object entityID : (Object)passengers) {
                PacketEntity passenger = this.player.compensatedEntities.getEntity((int)entityID);
                if (passenger == null) continue;
                passenger.mount(vehicle);
            }
        });
    }

    private void handleMoveEntity(PacketSendEvent event, int entityId, double deltaX, double deltaY, double deltaZ, Float yaw, Float pitch, boolean isRelative, boolean hasPos) {
        TrackerData data = this.player.compensatedEntities.getTrackedEntity(entityId);
        if (!this.hasSentPreWavePacket) {
            this.hasSentPreWavePacket = true;
            this.player.sendTransaction();
        }
        if (data != null) {
            if (isRelative) {
                boolean vanillaVehicleFlight;
                boolean bl = vanillaVehicleFlight = this.player.compensatedEntities.serverPlayerVehicle != null && this.player.compensatedEntities.serverPlayerVehicle == entityId && this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) && PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9);
                if (vanillaVehicleFlight || (Math.abs(deltaX) >= 3.9375 || Math.abs(deltaY) >= 3.9375 || Math.abs(deltaZ) >= 3.9375) && this.player.getClientVersion().isOlderThan(ClientVersion.V_1_9) && PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
                    this.player.user.writePacket(new WrapperPlayServerEntityTeleport(entityId, new Vector3d(data.getX() + deltaX, data.getY() + deltaY, data.getZ() + deltaZ), yaw == null ? data.getXRot() : yaw.floatValue(), pitch == null ? data.getYRot() : pitch.floatValue(), false));
                    event.setCancelled(true);
                    return;
                }
                data.setX(data.getX() + deltaX);
                data.setY(data.getY() + deltaY);
                data.setZ(data.getZ() + deltaZ);
            } else {
                data.setX(deltaX);
                data.setY(deltaY);
                data.setZ(deltaZ);
            }
            if (yaw != null) {
                data.setXRot(yaw.floatValue());
                data.setYRot(pitch.floatValue());
            }
            if (data.getLastTransactionHung() == this.player.lastTransactionSent.get()) {
                this.player.sendTransaction();
            }
            data.setLastTransactionHung(this.player.lastTransactionSent.get());
        }
        int lastTrans = this.player.lastTransactionSent.get();
        this.player.latencyUtils.addRealTimeTask(lastTrans, () -> {
            PacketEntity entity = this.player.compensatedEntities.getEntity(entityId);
            if (entity == null) {
                return;
            }
            if (entity instanceof PacketEntityTrackXRot && yaw != null) {
                PacketEntityTrackXRot xRotEntity = (PacketEntityTrackXRot)entity;
                xRotEntity.packetYaw = yaw.floatValue();
                xRotEntity.steps = EntityTypes.isTypeInstanceOf(entity.type, EntityTypes.BOAT) ? 10 : 3;
            }
            entity.onFirstTransaction(isRelative, hasPos, deltaX, deltaY, deltaZ, this.player);
        });
        this.player.latencyUtils.addRealTimeTask(lastTrans + 1, () -> {
            PacketEntity entity = this.player.compensatedEntities.getEntity(entityId);
            if (entity == null) {
                return;
            }
            entity.onSecondTransaction();
        });
    }

    public void addEntity(int entityID, EntityType type, Vector3d position, float xRot, float yRot, List<EntityData> entityMetadata, int extraData) {
        if (this.despawnedEntitiesThisTransaction.contains(entityID)) {
            this.player.sendTransaction();
        }
        this.player.compensatedEntities.serverPositionsMap.put(entityID, new TrackerData(position.getX(), position.getY(), position.getZ(), xRot, yRot, type, this.player.lastTransactionSent.get()));
        this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
            this.player.compensatedEntities.addEntity(entityID, type, position, xRot, extraData);
            if (entityMetadata != null) {
                this.player.compensatedEntities.updateEntityMetadata(entityID, entityMetadata);
            }
        });
    }

    private boolean isDirectlyAffectingPlayer(GrimPlayer player, int entityID) {
        return player.compensatedEntities.serverPlayerVehicle == null && entityID == player.entityID || player.compensatedEntities.serverPlayerVehicle != null && entityID == player.compensatedEntities.serverPlayerVehicle;
    }

    public void onEndOfTickEvent() {
        this.player.sendTransaction(true);
    }

    public void tickStartTick() {
        this.hasSentPreWavePacket = false;
    }

    private /* synthetic */ void lambda$onPacketSend$2(WrapperPlayServerRemoveEntityEffect effect) {
        PacketEntity entity = this.player.compensatedEntities.getEntity(effect.getEntityId());
        if (entity == null) {
            return;
        }
        entity.removePotionEffect(effect.getPotionType());
    }

    private /* synthetic */ void lambda$onPacketSend$1(WrapperPlayServerEntityEffect effect, PotionType type) {
        PacketEntity entity = this.player.compensatedEntities.getEntity(effect.getEntityId());
        if (entity == null) {
            return;
        }
        entity.addPotionEffect(type, effect.getEffectAmplifier());
    }
}

