/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.events.packets;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.events.packets.PacketPlayerDigging;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketListenerAbstract;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketListenerPriority;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.ConnectionState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.ItemStack;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.DiggingAction;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.GameMode;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.InteractionHand;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.Location;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateValue;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3f;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerFlying;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientUseItem;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientVehicleMove;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerAcknowledgeBlockChanges;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerBlockChange;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetSlot;
import ac.grim.grimac.utils.anticheat.update.BlockPlace;
import ac.grim.grimac.utils.anticheat.update.PositionUpdate;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;
import ac.grim.grimac.utils.anticheat.update.RotationUpdate;
import ac.grim.grimac.utils.anticheat.update.VehiclePositionUpdate;
import ac.grim.grimac.utils.blockplace.BlockPlaceResult;
import ac.grim.grimac.utils.blockplace.ConsumesBlockPlace;
import ac.grim.grimac.utils.collisions.HitboxData;
import ac.grim.grimac.utils.collisions.datatypes.CollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.BlockPlaceSnapshot;
import ac.grim.grimac.utils.data.HeadRotation;
import ac.grim.grimac.utils.data.HitData;
import ac.grim.grimac.utils.data.Pair;
import ac.grim.grimac.utils.data.TeleportAcceptData;
import ac.grim.grimac.utils.data.VelocityData;
import ac.grim.grimac.utils.latency.CompensatedWorld;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.math.VectorUtils;
import ac.grim.grimac.utils.nmsutil.BlockBreakSpeed;
import ac.grim.grimac.utils.nmsutil.BoundingBoxSize;
import ac.grim.grimac.utils.nmsutil.Collisions;
import ac.grim.grimac.utils.nmsutil.Materials;
import ac.grim.grimac.utils.nmsutil.Ray;
import ac.grim.grimac.utils.nmsutil.ReachUtils;
import java.util.ArrayList;
import java.util.function.BiFunction;
import org.bukkit.util.Vector;

public class CheckManagerListener
extends PacketListenerAbstract {
    public CheckManagerListener() {
        super(PacketListenerPriority.LOW);
    }

    public static HitData traverseBlocks(GrimPlayer player, Vector3d start, Vector3d end, BiFunction<WrappedBlockState, Vector3i, HitData> predicate) {
        double endX = GrimMath.lerp(-1.0E-7, end.x, start.x);
        double endY = GrimMath.lerp(-1.0E-7, end.y, start.y);
        double endZ = GrimMath.lerp(-1.0E-7, end.z, start.z);
        double startX = GrimMath.lerp(-1.0E-7, start.x, end.x);
        double startY = GrimMath.lerp(-1.0E-7, start.y, end.y);
        double startZ = GrimMath.lerp(-1.0E-7, start.z, end.z);
        int floorStartX = GrimMath.floor(startX);
        int floorStartY = GrimMath.floor(startY);
        int floorStartZ = GrimMath.floor(startZ);
        if (start.equals(end)) {
            return null;
        }
        WrappedBlockState state = player.compensatedWorld.getWrappedBlockStateAt(floorStartX, floorStartY, floorStartZ);
        HitData apply = predicate.apply(state, new Vector3i(floorStartX, floorStartY, floorStartZ));
        if (apply != null) {
            return apply;
        }
        double xDiff = endX - startX;
        double yDiff = endY - startY;
        double zDiff = endZ - startZ;
        double xSign = Math.signum(xDiff);
        double ySign = Math.signum(yDiff);
        double zSign = Math.signum(zDiff);
        double posXInverse = xSign == 0.0 ? Double.MAX_VALUE : xSign / xDiff;
        double posYInverse = ySign == 0.0 ? Double.MAX_VALUE : ySign / yDiff;
        double posZInverse = zSign == 0.0 ? Double.MAX_VALUE : zSign / zDiff;
        double d12 = posXInverse * (xSign > 0.0 ? 1.0 - GrimMath.frac(startX) : GrimMath.frac(startX));
        double d13 = posYInverse * (ySign > 0.0 ? 1.0 - GrimMath.frac(startY) : GrimMath.frac(startY));
        double d14 = posZInverse * (zSign > 0.0 ? 1.0 - GrimMath.frac(startZ) : GrimMath.frac(startZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            if (d12 < d13) {
                if (d12 < d14) {
                    floorStartX = (int)((double)floorStartX + xSign);
                    d12 += posXInverse;
                } else {
                    floorStartZ = (int)((double)floorStartZ + zSign);
                    d14 += posZInverse;
                }
            } else if (d13 < d14) {
                floorStartY = (int)((double)floorStartY + ySign);
                d13 += posYInverse;
            } else {
                floorStartZ = (int)((double)floorStartZ + zSign);
                d14 += posZInverse;
            }
            if ((apply = predicate.apply(state = player.compensatedWorld.getWrappedBlockStateAt(floorStartX, floorStartY, floorStartZ), new Vector3i(floorStartX, floorStartY, floorStartZ))) == null) continue;
            return apply;
        }
        return null;
    }

    private static void placeWaterLavaSnowBucket(GrimPlayer player, ItemStack held, StateType toPlace, InteractionHand hand) {
        HitData data = CheckManagerListener.getNearestHitResult(player, StateTypes.AIR, false);
        if (data != null) {
            BlockPlace blockPlace = new BlockPlace(player, hand, data.getPosition(), data.getClosestDirection(), held, data);
            boolean didPlace = false;
            if (Materials.isPlaceableWaterBucket(blockPlace.getItemStack().getType()) && PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13)) {
                blockPlace.setReplaceClicked(true);
                WrappedBlockState existing = blockPlace.getExistingBlockData();
                if (!((Boolean)existing.getInternalData().getOrDefault((Object)StateValue.WATERLOGGED, true)).booleanValue()) {
                    didPlace = true;
                }
            }
            if (!didPlace) {
                blockPlace.setReplaceClicked(false);
                blockPlace.set(toPlace);
            }
            if (player.gamemode != GameMode.CREATIVE) {
                if (hand == InteractionHand.MAIN_HAND) {
                    player.getInventory().inventory.setHeldItem(ItemStack.builder().type(ItemTypes.BUCKET).amount(1).build());
                } else {
                    player.getInventory().inventory.setPlayerInventoryItem(45, ItemStack.builder().type(ItemTypes.BUCKET).amount(1).build());
                }
            }
        }
    }

    public static void handleQueuedPlaces(GrimPlayer player, boolean hasLook, float pitch, float yaw, long now) {
        BlockPlaceSnapshot snapshot;
        while ((snapshot = player.placeUseItemPackets.poll()) != null) {
            double lastX = player.x;
            double lastY = player.y;
            double lastZ = player.z;
            player.x = player.packetStateData.lastClaimedPosition.getX();
            player.y = player.packetStateData.lastClaimedPosition.getY();
            player.z = player.packetStateData.lastClaimedPosition.getZ();
            boolean lastSneaking = player.isSneaking;
            player.isSneaking = snapshot.isSneaking();
            if (player.compensatedEntities.getSelf().getRiding() != null) {
                Vector3d posFromVehicle = BoundingBoxSize.getRidingOffsetFromVehicle(player.compensatedEntities.getSelf().getRiding(), player);
                player.x = posFromVehicle.getX();
                player.y = posFromVehicle.getY();
                player.z = posFromVehicle.getZ();
            }
            if ((now - player.lastBlockPlaceUseItem < 15L || player.getClientVersion().isOlderThan(ClientVersion.V_1_9)) && hasLook) {
                player.xRot = yaw;
                player.yRot = pitch;
            }
            player.compensatedWorld.startPredicting();
            CheckManagerListener.handleBlockPlaceOrUseItem(snapshot.getWrapper(), player);
            player.compensatedWorld.stopPredicting(snapshot.getWrapper());
            player.x = lastX;
            player.y = lastY;
            player.z = lastZ;
            player.isSneaking = lastSneaking;
        }
    }

    private static void handleUseItem(GrimPlayer player, ItemStack placedWith, InteractionHand hand) {
        if (placedWith.getType() == ItemTypes.LILY_PAD) {
            CheckManagerListener.placeLilypad(player, hand);
            return;
        }
        StateType toBucketMat = Materials.transformBucketMaterial(placedWith.getType());
        if (toBucketMat != null) {
            CheckManagerListener.placeWaterLavaSnowBucket(player, placedWith, toBucketMat, hand);
        }
        if (placedWith.getType() == ItemTypes.BUCKET) {
            CheckManagerListener.placeBucket(player, hand);
        }
    }

    private static void handleBlockPlaceOrUseItem(PacketWrapper packet, GrimPlayer player) {
        ItemStack placedWith;
        PacketWrapper place;
        if (packet instanceof WrapperPlayClientPlayerBlockPlacement && PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_9)) {
            place = (WrapperPlayClientPlayerBlockPlacement)packet;
            if (player.gamemode == GameMode.SPECTATOR || player.gamemode == GameMode.ADVENTURE) {
                return;
            }
            if (((WrapperPlayClientPlayerBlockPlacement)place).getFace() == BlockFace.OTHER) {
                ItemStack placedWith2 = player.getInventory().getHeldItem();
                if (((WrapperPlayClientPlayerBlockPlacement)place).getHand() == InteractionHand.OFF_HAND) {
                    placedWith2 = player.getInventory().getOffHand();
                }
                CheckManagerListener.handleUseItem(player, placedWith2, ((WrapperPlayClientPlayerBlockPlacement)place).getHand());
                return;
            }
        }
        if (packet instanceof WrapperPlayClientUseItem) {
            place = (WrapperPlayClientUseItem)packet;
            if (player.gamemode == GameMode.SPECTATOR || player.gamemode == GameMode.ADVENTURE) {
                return;
            }
            placedWith = player.getInventory().getHeldItem();
            if (((WrapperPlayClientUseItem)place).getHand() == InteractionHand.OFF_HAND) {
                placedWith = player.getInventory().getOffHand();
            }
            CheckManagerListener.handleUseItem(player, placedWith, ((WrapperPlayClientUseItem)place).getHand());
        }
        if (packet instanceof WrapperPlayClientPlayerBlockPlacement) {
            boolean onlyAir;
            place = (WrapperPlayClientPlayerBlockPlacement)packet;
            placedWith = player.getInventory().getHeldItem();
            ItemStack offhand = player.getInventory().getOffHand();
            boolean bl = onlyAir = placedWith.isEmpty() && offhand.isEmpty();
            if ((!player.isSneaking || onlyAir) && ((WrapperPlayClientPlayerBlockPlacement)place).getHand() == InteractionHand.MAIN_HAND) {
                Vector3i blockPosition = ((WrapperPlayClientPlayerBlockPlacement)place).getBlockPosition();
                BlockPlace blockPlace = new BlockPlace(player, ((WrapperPlayClientPlayerBlockPlacement)place).getHand(), blockPosition, ((WrapperPlayClientPlayerBlockPlacement)place).getFace(), placedWith, CheckManagerListener.getNearestHitResult(player, null, true));
                StateType placedAgainst = blockPlace.getPlacedAgainstMaterial();
                if (player.getClientVersion().isOlderThan(ClientVersion.V_1_8) && (placedAgainst == StateTypes.IRON_TRAPDOOR || placedAgainst == StateTypes.IRON_DOOR) || Materials.isClientSideInteractable(placedAgainst)) {
                    Vector3i location = blockPlace.getPlacedAgainstBlockLocation();
                    player.compensatedWorld.tickOpenable(location.getX(), location.getY(), location.getZ());
                    return;
                }
                if (ConsumesBlockPlace.consumesPlace(player, player.compensatedWorld.getWrappedBlockStateAt(blockPlace.getPlacedAgainstBlockLocation()), blockPlace)) {
                    return;
                }
            }
        }
        if (packet instanceof WrapperPlayClientPlayerBlockPlacement) {
            place = (WrapperPlayClientPlayerBlockPlacement)packet;
            Vector3i blockPosition = ((WrapperPlayClientPlayerBlockPlacement)place).getBlockPosition();
            BlockFace face = ((WrapperPlayClientPlayerBlockPlacement)place).getFace();
            if (player.gamemode == GameMode.SPECTATOR || player.gamemode == GameMode.ADVENTURE) {
                return;
            }
            ItemStack placedWith3 = player.getInventory().getHeldItem();
            if (((WrapperPlayClientPlayerBlockPlacement)place).getHand() == InteractionHand.OFF_HAND) {
                placedWith3 = player.getInventory().getOffHand();
            }
            BlockPlace blockPlace = new BlockPlace(player, ((WrapperPlayClientPlayerBlockPlacement)place).getHand(), blockPosition, face, placedWith3, CheckManagerListener.getNearestHitResult(player, null, true));
            player.checkManager.onPostFlyingBlockPlace(blockPlace);
            blockPlace.setInside(((WrapperPlayClientPlayerBlockPlacement)place).getInsideBlock().orElse(false));
            if (placedWith3.getType().getPlacedType() != null || placedWith3.getType() == ItemTypes.FIRE_CHARGE) {
                BlockPlaceResult.getMaterialData(placedWith3.getType()).applyBlockPlaceToWorld(player, blockPlace);
            }
        }
    }

    private boolean isMojangStupid(GrimPlayer player, WrapperPlayClientPlayerFlying flying) {
        double threshold = player.getMovementThreshold();
        if (!player.packetStateData.lastPacketWasTeleport && flying.hasPositionChanged() && flying.hasRotationChanged() && (flying.isOnGround() == player.packetStateData.packetPlayerOnGround && player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_17) && player.filterMojangStupidityOnMojangStupidity.distanceSquared(flying.getLocation().getPosition()) < threshold * threshold || player.compensatedEntities.getSelf().inVehicle())) {
            player.packetStateData.lastPacketWasOnePointSeventeenDuplicate = true;
            if (player.xRot != flying.getLocation().getYaw() || player.yRot != flying.getLocation().getPitch()) {
                player.lastXRot = player.xRot;
                player.lastYRot = player.yRot;
            }
            player.xRot = flying.getLocation().getYaw();
            player.yRot = flying.getLocation().getPitch();
            player.packetStateData.lastClaimedPosition = flying.getLocation().getPosition();
            return true;
        }
        return false;
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        Vector3d position;
        if (event.getConnectionState() != ConnectionState.PLAY) {
            return;
        }
        GrimPlayer player = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
        if (player == null) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.VEHICLE_MOVE) {
            WrapperPlayClientVehicleMove move = new WrapperPlayClientVehicleMove(event);
            Vector3d position2 = move.getPosition();
            player.packetStateData.lastPacketWasTeleport = player.getSetbackTeleportUtil().checkVehicleTeleportQueue(position2.getX(), position2.getY(), position2.getZ());
        }
        TeleportAcceptData teleportData = null;
        if (WrapperPlayClientPlayerFlying.isFlying(event.getPacketType())) {
            WrapperPlayClientPlayerFlying flying = new WrapperPlayClientPlayerFlying(event);
            position = VectorUtils.clampVector(flying.getLocation().getPosition());
            teleportData = flying.hasPositionChanged() && flying.hasRotationChanged() ? player.getSetbackTeleportUtil().checkTeleportQueue(position.getX(), position.getY(), position.getZ()) : new TeleportAcceptData();
            player.packetStateData.lastPacketWasTeleport = teleportData.isTeleport();
            boolean bl = player.packetStateData.lastPacketWasOnePointSeventeenDuplicate = !player.packetStateData.lastPacketWasTeleport && this.isMojangStupid(player, flying);
        }
        if (player.compensatedEntities.getSelf().inVehicle() ? event.getPacketType() == PacketType.Play.Client.VEHICLE_MOVE : WrapperPlayClientPlayerFlying.isFlying(event.getPacketType())) {
            int kbEntityId = player.compensatedEntities.getSelf().inVehicle() ? player.getRidingVehicleId() : player.entityID;
            VelocityData calculatedFirstBreadKb = player.checkManager.getKnockbackHandler().calculateFirstBreadKnockback(kbEntityId, player.lastTransactionReceived.get());
            VelocityData calculatedRequireKb = player.checkManager.getKnockbackHandler().calculateRequiredKB(kbEntityId, player.lastTransactionReceived.get());
            player.firstBreadKB = calculatedFirstBreadKb == null ? player.firstBreadKB : calculatedFirstBreadKb;
            player.likelyKB = calculatedRequireKb == null ? player.likelyKB : calculatedRequireKb;
            VelocityData calculateFirstBreadExplosion = player.checkManager.getExplosionHandler().getFirstBreadAddedExplosion(player.lastTransactionReceived.get());
            VelocityData calculateRequiredExplosion = player.checkManager.getExplosionHandler().getPossibleExplosions(player.lastTransactionReceived.get());
            player.firstBreadExplosion = calculateFirstBreadExplosion == null ? player.firstBreadExplosion : calculateFirstBreadExplosion;
            player.likelyExplosions = calculateRequiredExplosion == null ? player.likelyExplosions : calculateRequiredExplosion;
        }
        player.checkManager.onPrePredictionReceivePacket(event);
        if (event.isCancelled() && (WrapperPlayClientPlayerFlying.isFlying(event.getPacketType()) || event.getPacketType() == PacketType.Play.Client.VEHICLE_MOVE)) {
            return;
        }
        if (WrapperPlayClientPlayerFlying.isFlying(event.getPacketType())) {
            WrapperPlayClientPlayerFlying flying = new WrapperPlayClientPlayerFlying(event);
            Location pos = flying.getLocation();
            this.handleFlying(player, pos.getX(), pos.getY(), pos.getZ(), pos.getYaw(), pos.getPitch(), flying.hasPositionChanged(), flying.hasRotationChanged(), flying.isOnGround(), teleportData, event);
        }
        if (event.getPacketType() == PacketType.Play.Client.VEHICLE_MOVE && player.compensatedEntities.getSelf().inVehicle()) {
            WrapperPlayClientVehicleMove move = new WrapperPlayClientVehicleMove(event);
            position = move.getPosition();
            player.lastX = player.x;
            player.lastY = player.y;
            player.lastZ = player.z;
            Vector3d clamp = VectorUtils.clampVector(position);
            player.x = clamp.getX();
            player.y = clamp.getY();
            player.z = clamp.getZ();
            player.xRot = move.getYaw();
            player.yRot = move.getPitch();
            VehiclePositionUpdate update = new VehiclePositionUpdate(clamp, position, move.getYaw(), move.getPitch(), player.packetStateData.lastPacketWasTeleport);
            player.checkManager.onVehiclePositionUpdate(update);
            player.packetStateData.receivedSteerVehicle = false;
        }
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING) {
            double damage;
            WrapperPlayClientPlayerDigging dig = new WrapperPlayClientPlayerDigging(event);
            WrappedBlockState block = player.compensatedWorld.getWrappedBlockStateAt(dig.getBlockPosition());
            if (dig.getAction() == DiggingAction.FINISHED_DIGGING && block.getType().getHardness() != -1.0f) {
                player.compensatedWorld.updateBlock(dig.getBlockPosition().getX(), dig.getBlockPosition().getY(), dig.getBlockPosition().getZ(), 0);
            }
            if (dig.getAction() == DiggingAction.START_DIGGING && (damage = BlockBreakSpeed.getBlockDamage(player, dig.getBlockPosition())) >= 1.0) {
                player.compensatedWorld.startPredicting();
                if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_13) && Materials.isWaterSource(player.getClientVersion(), block)) {
                    player.compensatedWorld.updateBlock(dig.getBlockPosition(), StateTypes.WATER.createBlockState(CompensatedWorld.blockVersion));
                } else {
                    player.compensatedWorld.updateBlock(dig.getBlockPosition().getX(), dig.getBlockPosition().getY(), dig.getBlockPosition().getZ(), 0);
                }
                player.compensatedWorld.stopPredicting(dig);
            }
            if (dig.getAction() == DiggingAction.START_DIGGING || dig.getAction() == DiggingAction.FINISHED_DIGGING || dig.getAction() == DiggingAction.CANCELLED_DIGGING) {
                player.compensatedWorld.handleBlockBreakPrediction(dig);
            }
        }
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT) {
            WrapperPlayClientPlayerBlockPlacement packet = new WrapperPlayClientPlayerBlockPlacement(event);
            player.lastBlockPlaceUseItem = System.currentTimeMillis();
            ItemStack placedWith = player.getInventory().getHeldItem();
            if (packet.getHand() == InteractionHand.OFF_HAND) {
                placedWith = player.getInventory().getOffHand();
            }
            if (packet.getFace() == BlockFace.OTHER && PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_9)) {
                player.placeUseItemPackets.add(new BlockPlaceSnapshot(packet, player.isSneaking));
                PacketPlayerDigging.handleUseItem(player, player.getInventory().getHeldItem(), InteractionHand.MAIN_HAND);
            } else {
                BlockPlace blockPlace = new BlockPlace(player, packet.getHand(), packet.getBlockPosition(), packet.getFace(), placedWith, CheckManagerListener.getNearestHitResult(player, null, true));
                blockPlace.setCursor(packet.getCursorPosition());
                if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_11) && player.getClientVersion().isOlderThan(ClientVersion.V_1_11) && packet.getCursorPosition().getX() * 15.0f % 1.0f == 0.0f && packet.getCursorPosition().getY() * 15.0f % 1.0f == 0.0f && packet.getCursorPosition().getZ() * 15.0f % 1.0f == 0.0f) {
                    int trueByteX = (int)(packet.getCursorPosition().getX() * 15.0f);
                    int trueByteY = (int)(packet.getCursorPosition().getY() * 15.0f);
                    int trueByteZ = (int)(packet.getCursorPosition().getZ() * 15.0f);
                    blockPlace.setCursor(new Vector3f((float)trueByteX / 16.0f, (float)trueByteY / 16.0f, (float)trueByteZ / 16.0f));
                }
                if (placedWith.getType().getPlacedType() != null || placedWith.getType() == ItemTypes.FIRE_CHARGE) {
                    player.checkManager.onBlockPlace(blockPlace);
                }
                if (blockPlace.isCancelled()) {
                    event.setCancelled(true);
                    player.onPacketCancel();
                    Vector3i facePos = new Vector3i(packet.getBlockPosition().getX() + packet.getFace().getModX(), packet.getBlockPosition().getY() + packet.getFace().getModY(), packet.getBlockPosition().getZ() + packet.getFace().getModZ());
                    int placed = player.compensatedWorld.getWrappedBlockStateAt(packet.getBlockPosition()).getGlobalId();
                    int face = player.compensatedWorld.getWrappedBlockStateAt(facePos).getGlobalId();
                    player.user.sendPacket(new WrapperPlayServerBlockChange(blockPlace.getPlacedBlockPos(), placed));
                    player.user.sendPacket(new WrapperPlayServerBlockChange(facePos, face));
                    if (player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_19) && PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_19)) {
                        player.user.sendPacket(new WrapperPlayServerAcknowledgeBlockChanges(packet.getSequence()));
                    }
                    if (packet.getHand() == InteractionHand.MAIN_HAND) {
                        player.user.sendPacket(new WrapperPlayServerSetSlot(0, player.getInventory().stateID, 36 + player.packetStateData.lastSlotSelected, player.getInventory().getHeldItem()));
                    } else {
                        player.user.sendPacket(new WrapperPlayServerSetSlot(0, player.getInventory().stateID, 45, player.getInventory().getOffHand()));
                    }
                } else {
                    player.placeUseItemPackets.add(new BlockPlaceSnapshot(packet, player.isSneaking));
                }
            }
        }
        if (event.getPacketType() == PacketType.Play.Client.USE_ITEM) {
            WrapperPlayClientUseItem packet = new WrapperPlayClientUseItem(event);
            player.placeUseItemPackets.add(new BlockPlaceSnapshot(packet, player.isSneaking));
            player.lastBlockPlaceUseItem = System.currentTimeMillis();
        }
        player.checkManager.onPacketReceive(event);
        player.packetStateData.lastPacketWasOnePointSeventeenDuplicate = false;
        player.packetStateData.lastPacketWasTeleport = false;
    }

    private static void placeBucket(GrimPlayer player, InteractionHand hand) {
        HitData data = CheckManagerListener.getNearestHitResult(player, null, true);
        if (data != null) {
            WrappedBlockState existing;
            BlockPlace blockPlace = new BlockPlace(player, hand, data.getPosition(), data.getClosestDirection(), ItemStack.EMPTY, data);
            blockPlace.setReplaceClicked(true);
            boolean placed = false;
            ItemType type = null;
            if (data.getState().getType() == StateTypes.POWDER_SNOW) {
                blockPlace.set(StateTypes.AIR);
                type = ItemTypes.POWDER_SNOW_BUCKET;
                placed = true;
            }
            if (data.getState().getType() == StateTypes.LAVA) {
                blockPlace.set(StateTypes.AIR);
                type = ItemTypes.LAVA_BUCKET;
                placed = true;
            }
            if (!placed && !player.compensatedWorld.isWaterSourceBlock(data.getPosition().getX(), data.getPosition().getY(), data.getPosition().getZ())) {
                return;
            }
            if (data.getState().getType() == StateTypes.KELP || data.getState().getType() == StateTypes.SEAGRASS || data.getState().getType() == StateTypes.TALL_SEAGRASS) {
                return;
            }
            if (!placed) {
                type = ItemTypes.WATER_BUCKET;
            }
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13) && (existing = blockPlace.getExistingBlockData()).getInternalData().containsKey((Object)StateValue.WATERLOGGED)) {
                existing.setWaterlogged(false);
                blockPlace.set(existing);
                placed = true;
            }
            if (!placed) {
                blockPlace.set(StateTypes.AIR);
            }
            CheckManagerListener.setPlayerItem(player, hand, type);
        }
    }

    public static void setPlayerItem(GrimPlayer player, InteractionHand hand, ItemType type) {
        if (player.gamemode != GameMode.CREATIVE) {
            if (hand == InteractionHand.MAIN_HAND) {
                if (player.getInventory().getHeldItem().getAmount() == 1) {
                    player.getInventory().inventory.setHeldItem(ItemStack.builder().type(type).amount(1).build());
                } else {
                    player.getInventory().inventory.add(ItemStack.builder().type(type).amount(1).build());
                    player.getInventory().getHeldItem().setAmount(player.getInventory().getHeldItem().getAmount() - 1);
                }
            } else if (player.getInventory().getOffHand().getAmount() == 1) {
                player.getInventory().inventory.setPlayerInventoryItem(45, ItemStack.builder().type(type).amount(1).build());
            } else {
                player.getInventory().inventory.add(45, ItemStack.builder().type(type).amount(1).build());
                player.getInventory().getOffHand().setAmount(player.getInventory().getOffHand().getAmount() - 1);
            }
        }
    }

    private void handleFlying(GrimPlayer player, double x, double y, double z, float yaw, float pitch, boolean hasPosition, boolean hasLook, boolean onGround, TeleportAcceptData teleportData, PacketReceiveEvent event) {
        Object update;
        long now = System.currentTimeMillis();
        if (!hasPosition) {
            player.uncertaintyHandler.lastPointThree.reset();
        }
        if (hasLook && (!player.packetStateData.lastPacketWasOnePointSeventeenDuplicate || player.xRot != yaw || player.yRot != pitch)) {
            player.lastXRot = player.xRot;
            player.lastYRot = player.yRot;
        }
        CheckManagerListener.handleQueuedPlaces(player, hasLook, pitch, yaw, now);
        if (hasPosition) {
            player.packetStateData.lastClaimedPosition = new Vector3d(x, y, z);
        }
        if (!hasPosition && onGround != player.packetStateData.packetPlayerOnGround && !player.compensatedEntities.getSelf().inVehicle()) {
            player.lastOnGround = onGround;
            player.clientClaimsLastOnGround = onGround;
            player.uncertaintyHandler.onGroundUncertain = true;
            boolean canFeasiblyPointThree = Collisions.slowCouldPointThreeHitGround(player, player.x, player.y, player.z);
            if (!canFeasiblyPointThree && !player.compensatedWorld.isNearHardEntity(player.boundingBox.copy().expand(4.0)) || player.clientVelocity.getY() > 0.06) {
                player.getSetbackTeleportUtil().executeForceResync();
            }
        }
        if (!player.packetStateData.lastPacketWasTeleport) {
            player.packetStateData.packetPlayerOnGround = onGround;
        }
        if (hasLook) {
            player.xRot = yaw;
            player.yRot = pitch;
            float deltaXRot = player.xRot - player.lastXRot;
            float deltaYRot = player.yRot - player.lastYRot;
            update = new RotationUpdate(new HeadRotation(player.lastXRot, player.lastYRot), new HeadRotation(player.xRot, player.yRot), deltaXRot, deltaYRot);
            player.checkManager.onRotationUpdate((RotationUpdate)update);
        }
        if (hasPosition) {
            Vector3d position = new Vector3d(x, y, z);
            Vector3d clampVector = VectorUtils.clampVector(position);
            update = new PositionUpdate(new Vector3d(player.x, player.y, player.z), position, onGround, teleportData.getSetback(), teleportData.getTeleportData(), teleportData.isTeleport());
            player.filterMojangStupidityOnMojangStupidity = clampVector;
            if (!player.compensatedEntities.getSelf().inVehicle() && !player.packetStateData.lastPacketWasOnePointSeventeenDuplicate) {
                player.lastX = player.x;
                player.lastY = player.y;
                player.lastZ = player.z;
                player.x = clampVector.getX();
                player.y = clampVector.getY();
                player.z = clampVector.getZ();
                player.checkManager.onPositionUpdate((PositionUpdate)update);
            } else if (((PositionUpdate)update).isTeleport()) {
                player.getSetbackTeleportUtil().onPredictionComplete(new PredictionComplete(0.0, (PositionUpdate)update, true));
            }
        }
        player.packetStateData.didLastLastMovementIncludePosition = player.packetStateData.didLastMovementIncludePosition;
        player.packetStateData.didLastMovementIncludePosition = hasPosition;
    }

    private static void placeLilypad(GrimPlayer player, InteractionHand hand) {
        HitData data = CheckManagerListener.getNearestHitResult(player, null, true);
        if (data != null) {
            if (player.compensatedWorld.getFluidLevelAt(data.getPosition().getX(), data.getPosition().getY() + 1, data.getPosition().getZ()) > 0.0) {
                return;
            }
            BlockPlace blockPlace = new BlockPlace(player, hand, data.getPosition(), data.getClosestDirection(), ItemStack.EMPTY, data);
            blockPlace.setReplaceClicked(false);
            if (player.compensatedWorld.getWaterFluidLevelAt(data.getPosition().getX(), data.getPosition().getY(), data.getPosition().getZ()) > 0.0 || data.getState().getType() == StateTypes.ICE || data.getState().getType() == StateTypes.FROSTED_ICE) {
                Vector3i pos = data.getPosition();
                pos = pos.add(0, 1, 0);
                blockPlace.set(pos, StateTypes.LILY_PAD.createBlockState(CompensatedWorld.blockVersion));
                if (player.gamemode != GameMode.CREATIVE) {
                    if (hand == InteractionHand.MAIN_HAND) {
                        player.getInventory().inventory.getHeldItem().setAmount(player.getInventory().inventory.getHeldItem().getAmount() - 1);
                    } else {
                        player.getInventory().getOffHand().setAmount(player.getInventory().getOffHand().getAmount() - 1);
                    }
                }
            }
        }
    }

    private static HitData getNearestHitResult(GrimPlayer player, StateType heldItem, boolean sourcesHaveHitbox) {
        Vector3d startingPos = new Vector3d(player.x, player.y + player.getEyeHeight(), player.z);
        Vector startingVec = new Vector(startingPos.getX(), startingPos.getY(), startingPos.getZ());
        Ray trace = new Ray(player, startingPos.getX(), startingPos.getY(), startingPos.getZ(), player.xRot, player.yRot);
        Vector endVec = trace.getPointAtDistance(5.0);
        Vector3d endPos = new Vector3d(endVec.getX(), endVec.getY(), endVec.getZ());
        return CheckManagerListener.traverseBlocks(player, startingPos, endPos, (block, vector3i) -> {
            CollisionBox data = HitboxData.getBlockHitbox(player, heldItem, player.getClientVersion(), block, vector3i.getX(), vector3i.getY(), vector3i.getZ());
            ArrayList<SimpleCollisionBox> boxes = new ArrayList<SimpleCollisionBox>();
            data.downCast(boxes);
            double bestHitResult = Double.MAX_VALUE;
            Vector bestHitLoc = null;
            BlockFace bestFace = null;
            for (SimpleCollisionBox box : boxes) {
                Vector hitLoc;
                Pair<Vector, BlockFace> intercept = ReachUtils.calculateIntercept(box, trace.getOrigin(), trace.getPointAtDistance(6.0));
                if (intercept.getFirst() == null || !((hitLoc = intercept.getFirst()).distanceSquared(startingVec) < bestHitResult)) continue;
                bestHitResult = hitLoc.distanceSquared(startingVec);
                bestHitLoc = hitLoc;
                bestFace = intercept.getSecond();
            }
            if (bestHitLoc != null) {
                return new HitData((Vector3i)vector3i, bestHitLoc, bestFace, (WrappedBlockState)block);
            }
            if (sourcesHaveHitbox && (player.compensatedWorld.isWaterSourceBlock(vector3i.getX(), vector3i.getY(), vector3i.getZ()) || player.compensatedWorld.getLavaFluidLevelAt(vector3i.getX(), vector3i.getY(), vector3i.getZ()) == 0.8888888955116272)) {
                double waterHeight = player.compensatedWorld.getFluidLevelAt(vector3i.getX(), vector3i.getY(), vector3i.getZ());
                SimpleCollisionBox box = new SimpleCollisionBox(vector3i.getX(), vector3i.getY(), vector3i.getZ(), vector3i.getX() + 1, (double)vector3i.getY() + waterHeight, vector3i.getZ() + 1);
                Pair<Vector, BlockFace> intercept = ReachUtils.calculateIntercept(box, trace.getOrigin(), trace.getPointAtDistance(6.0));
                if (intercept.getFirst() != null) {
                    return new HitData((Vector3i)vector3i, intercept.getFirst(), intercept.getSecond(), (WrappedBlockState)block);
                }
            }
            return null;
        });
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        if (event.getConnectionState() != ConnectionState.PLAY) {
            return;
        }
        GrimPlayer player = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
        if (player == null) {
            return;
        }
        player.checkManager.onPacketSend(event);
    }
}

