/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.events.bukkit;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.utils.blockstate.helper.BlockFaceHelper;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.PistonData;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class PistonEvent
implements Listener {
    Material SLIME_BLOCK = Material.getMaterial((String)"SLIME_BLOCK");
    Material HONEY_BLOCK = Material.getMaterial((String)"HONEY_BLOCK");

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPistonPushEvent(BlockPistonExtendEvent event) {
        boolean hasSlimeBlock = false;
        boolean hasHoneyBlock = false;
        ArrayList<SimpleCollisionBox> boxes = new ArrayList<SimpleCollisionBox>();
        for (Block block : event.getBlocks()) {
            boxes.add(new SimpleCollisionBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, true).offset(block.getX(), block.getY(), block.getZ()));
            boxes.add(new SimpleCollisionBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, true).offset(block.getX() + event.getDirection().getModX(), block.getY() + event.getDirection().getModY(), block.getZ() + event.getDirection().getModZ()));
            if (block.getType() == this.SLIME_BLOCK) {
                hasSlimeBlock = true;
            }
            if (block.getType() != this.HONEY_BLOCK) continue;
            hasHoneyBlock = true;
        }
        Block piston = event.getBlock();
        boxes.add(new SimpleCollisionBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, true).offset(piston.getX() + event.getDirection().getModX(), piston.getY() + event.getDirection().getModY(), piston.getZ() + event.getDirection().getModZ()));
        for (GrimPlayer player : GrimAPI.INSTANCE.getPlayerDataManager().getEntries()) {
            if (!player.compensatedWorld.isChunkLoaded(event.getBlock().getX() >> 4, event.getBlock().getZ() >> 4)) continue;
            PistonData data = new PistonData(BlockFaceHelper.fromBukkitFace(event.getDirection()), boxes, player.lastTransactionSent.get(), true, hasSlimeBlock, hasHoneyBlock);
            player.latencyUtils.addRealTimeTask(player.lastTransactionSent.get(), () -> player.compensatedWorld.activePistons.add(data));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPistonRetractEvent(BlockPistonRetractEvent event) {
        boolean hasSlimeBlock = false;
        boolean hasHoneyBlock = false;
        ArrayList<SimpleCollisionBox> boxes = new ArrayList<SimpleCollisionBox>();
        BlockFace face = BlockFaceHelper.fromBukkitFace(event.getDirection());
        if (event.getBlocks().isEmpty()) {
            Block piston = event.getBlock();
            boxes.add(new SimpleCollisionBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, true).offset(piston.getX() + face.getModX(), piston.getY() + face.getModY(), piston.getZ() + face.getModZ()));
        }
        for (Block block : event.getBlocks()) {
            boxes.add(new SimpleCollisionBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, true).offset(block.getX(), block.getY(), block.getZ()));
            boxes.add(new SimpleCollisionBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, true).offset(block.getX() + face.getModX(), block.getY() + face.getModY(), block.getZ() + face.getModZ()));
            if (block.getType() == this.SLIME_BLOCK) {
                hasSlimeBlock = true;
            }
            if (block.getType() != this.HONEY_BLOCK) continue;
            hasHoneyBlock = true;
        }
        for (GrimPlayer player : GrimAPI.INSTANCE.getPlayerDataManager().getEntries()) {
            if (!player.compensatedWorld.isChunkLoaded(event.getBlock().getX() >> 4, event.getBlock().getZ() >> 4)) continue;
            PistonData data = new PistonData(BlockFaceHelper.fromBukkitFace(event.getDirection()), boxes, player.lastTransactionSent.get(), false, hasSlimeBlock, hasHoneyBlock);
            player.latencyUtils.addRealTimeTask(player.lastTransactionSent.get(), () -> player.compensatedWorld.activePistons.add(data));
        }
    }
}

