/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.commands;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.User;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Optional;
import co.aikar.commands.annotation.Subcommand;
import co.aikar.commands.bukkit.contexts.OnlinePlayer;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="grim|grimac")
public class GrimDebug
extends BaseCommand {
    @Subcommand(value="debug")
    @CommandPermission(value="grim.debug")
    @CommandCompletion(value="@players")
    public void onDebug(CommandSender sender, @Optional OnlinePlayer target) {
        GrimPlayer grimPlayer;
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if ((grimPlayer = this.parseTarget(sender, player, target)) == null) {
            return;
        }
        if (sender instanceof ConsoleCommandSender) {
            grimPlayer.checkManager.getDebugHandler().toggleConsoleOutput();
        } else {
            grimPlayer.checkManager.getDebugHandler().toggleListener(player);
        }
    }

    private GrimPlayer parseTarget(CommandSender sender, Player player, OnlinePlayer target) {
        Player targetPlayer;
        Player player2 = targetPlayer = target == null ? player : target.getPlayer();
        if (player == null && target == null) {
            sender.sendMessage(ChatColor.RED + "You must specify a target as the console!");
            return null;
        }
        GrimPlayer grimPlayer = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(targetPlayer);
        if (grimPlayer == null) {
            User user = PacketEvents.getAPI().getPlayerManager().getUser(targetPlayer);
            sender.sendMessage(ChatColor.RED + "This player is exempt from all checks!");
            if (user == null) {
                sender.sendMessage(ChatColor.RED + "Unknown PacketEvents user");
            } else {
                boolean isExempt = GrimAPI.INSTANCE.getPlayerDataManager().shouldCheck(user);
                if (!isExempt) {
                    sender.sendMessage(ChatColor.RED + "User connection state: " + (Object)((Object)user.getConnectionState()));
                }
            }
        }
        return grimPlayer;
    }

    @Subcommand(value="consoledebug")
    @CommandPermission(value="grim.consoledebug")
    @CommandCompletion(value="@players")
    public void onConsoleDebug(CommandSender sender, @Optional OnlinePlayer target) {
        GrimPlayer grimPlayer;
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if ((grimPlayer = this.parseTarget(sender, player, target)) == null) {
            return;
        }
        boolean isOutput = grimPlayer.checkManager.getDebugHandler().toggleConsoleOutput();
        sender.sendMessage("Console output for " + (grimPlayer.bukkitPlayer == null ? grimPlayer.user.getProfile().getName() : grimPlayer.bukkitPlayer.getName()) + " is now " + isOutput);
    }
}

