/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.type;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.type.RotationCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.defaulttags.BlockTags;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.utils.anticheat.update.BlockPlace;
import ac.grim.grimac.utils.collisions.HitboxData;
import ac.grim.grimac.utils.collisions.datatypes.CollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import java.util.ArrayList;
import java.util.List;

public class BlockPlaceCheck
extends Check
implements RotationCheck {
    private static final List<StateType> weirdBoxes = new ArrayList<StateType>();
    private static final List<StateType> buggyBoxes = new ArrayList<StateType>();

    public BlockPlaceCheck(GrimPlayer player) {
        super(player);
    }

    public void onBlockPlace(BlockPlace place) {
    }

    public void onPostFlyingBlockPlace(BlockPlace place) {
    }

    protected SimpleCollisionBox getCombinedBox(BlockPlace place) {
        Vector3i clicked = place.getPlacedAgainstBlockLocation();
        CollisionBox placedOn = HitboxData.getBlockHitbox(this.player, place.getMaterial(), this.player.getClientVersion(), this.player.compensatedWorld.getWrappedBlockStateAt(clicked), clicked.getX(), clicked.getY(), clicked.getZ());
        ArrayList<SimpleCollisionBox> boxes = new ArrayList<SimpleCollisionBox>();
        placedOn.downCast(boxes);
        SimpleCollisionBox combined = new SimpleCollisionBox(clicked.getX(), (double)clicked.getY(), (double)clicked.getZ());
        for (SimpleCollisionBox box : boxes) {
            double minX = Math.max(box.minX, combined.minX);
            double minY = Math.max(box.minY, combined.minY);
            double minZ = Math.max(box.minZ, combined.minZ);
            double maxX = Math.min(box.maxX, combined.maxX);
            double maxY = Math.min(box.maxY, combined.maxY);
            double maxZ = Math.min(box.maxZ, combined.maxZ);
            combined = new SimpleCollisionBox(minX, minY, minZ, maxX, maxY, maxZ);
        }
        if (weirdBoxes.contains(place.getPlacedAgainstMaterial())) {
            combined = new SimpleCollisionBox(clicked.getX() + 1, clicked.getY() + 1, clicked.getZ() + 1, clicked.getX(), (double)clicked.getY() + 1.5, clicked.getZ());
        }
        if (buggyBoxes.contains(place.getPlacedAgainstMaterial())) {
            combined = new SimpleCollisionBox(clicked.getX() + 1, clicked.getY() + 1, clicked.getZ() + 1, clicked.getX(), clicked.getY(), clicked.getZ());
        }
        return combined;
    }

    static {
        weirdBoxes.addAll(new ArrayList<StateType>(BlockTags.FENCES.getStates()));
        weirdBoxes.addAll(new ArrayList<StateType>(BlockTags.WALLS.getStates()));
        weirdBoxes.add(StateTypes.LECTERN);
        buggyBoxes.addAll(new ArrayList<StateType>(BlockTags.DOORS.getStates()));
        buggyBoxes.addAll(new ArrayList<StateType>(BlockTags.STAIRS.getStates()));
        buggyBoxes.add(StateTypes.CHEST);
        buggyBoxes.add(StateTypes.TRAPPED_CHEST);
        buggyBoxes.add(StateTypes.CHORUS_PLANT);
        buggyBoxes.add(StateTypes.KELP);
        buggyBoxes.add(StateTypes.KELP_PLANT);
        buggyBoxes.add(StateTypes.TWISTING_VINES);
        buggyBoxes.add(StateTypes.TWISTING_VINES_PLANT);
        buggyBoxes.add(StateTypes.WEEPING_VINES);
        buggyBoxes.add(StateTypes.WEEPING_VINES_PLANT);
        buggyBoxes.add(StateTypes.REDSTONE_WIRE);
    }
}

