/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.velocity;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PostPredictionCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityVelocity;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;
import ac.grim.grimac.utils.data.VectorData;
import ac.grim.grimac.utils.data.VelocityData;
import java.util.Deque;
import java.util.LinkedList;
import org.bukkit.util.Vector;

@CheckData(name="AntiKB", alternativeName="AntiKnockback", configName="Knockback", setback=10.0, decay=0.025)
public class KnockbackHandler
extends Check
implements PostPredictionCheck {
    Deque<VelocityData> firstBreadMap = new LinkedList<VelocityData>();
    Deque<VelocityData> lastKnockbackKnownTaken = new LinkedList<VelocityData>();
    VelocityData firstBreadOnlyKnockback = null;
    boolean knockbackPointThree = false;
    double offsetToFlag;
    double setbackVL;

    public KnockbackHandler(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() == PacketType.Play.Server.ENTITY_VELOCITY) {
            WrapperPlayServerEntityVelocity velocity = new WrapperPlayServerEntityVelocity(event);
            int entityId = velocity.getEntityId();
            GrimPlayer player = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(event.getUser());
            if (player == null) {
                return;
            }
            if (player.compensatedEntities.serverPlayerVehicle != null && entityId != player.compensatedEntities.serverPlayerVehicle) {
                return;
            }
            if (player.compensatedEntities.serverPlayerVehicle == null && entityId != player.entityID) {
                return;
            }
            Vector3d playerVelocity = velocity.getVelocity();
            player.sendTransaction();
            this.addPlayerKnockback(entityId, player.lastTransactionSent.get(), new Vector(playerVelocity.getX(), playerVelocity.getY(), playerVelocity.getZ()));
            event.getTasksAfterSend().add(player::sendTransaction);
        }
    }

    public Vector getFutureKnockback() {
        if (this.firstBreadMap.size() > 0) {
            return this.firstBreadMap.peek().vector;
        }
        if (this.lastKnockbackKnownTaken.size() > 0) {
            return this.lastKnockbackKnownTaken.peek().vector;
        }
        if (this.player.firstBreadKB != null && this.player.likelyKB == null) {
            return this.player.firstBreadKB.vector.clone();
        }
        if (this.player.likelyKB != null) {
            return this.player.likelyKB.vector.clone();
        }
        return null;
    }

    private void addPlayerKnockback(int entityID, int breadOne, Vector knockback) {
        this.firstBreadMap.add(new VelocityData(entityID, breadOne, this.player.getSetbackTeleportUtil().isSendingSetback, knockback));
    }

    public VelocityData calculateRequiredKB(int entityID, int transaction) {
        this.tickKnockback(transaction);
        VelocityData returnLastKB = null;
        for (VelocityData data : this.lastKnockbackKnownTaken) {
            if (data.entityID != entityID) continue;
            returnLastKB = data;
        }
        this.lastKnockbackKnownTaken.clear();
        return returnLastKB;
    }

    private void tickKnockback(int transactionID) {
        this.firstBreadOnlyKnockback = null;
        if (this.firstBreadMap.isEmpty()) {
            return;
        }
        VelocityData data = this.firstBreadMap.peek();
        while (data != null) {
            if (data.transaction == transactionID) {
                this.firstBreadOnlyKnockback = new VelocityData(data.entityID, data.transaction, data.isSetback, data.vector);
                this.firstBreadMap.poll();
                break;
            }
            if (data.transaction >= transactionID) break;
            if (this.firstBreadOnlyKnockback != null) {
                this.lastKnockbackKnownTaken.add(new VelocityData(data.entityID, data.transaction, data.vector, data.isSetback, data.offset));
            } else {
                this.lastKnockbackKnownTaken.add(new VelocityData(data.entityID, data.transaction, data.isSetback, data.vector));
            }
            this.firstBreadOnlyKnockback = null;
            this.firstBreadMap.poll();
            data = this.firstBreadMap.peek();
        }
    }

    public void forceExempt() {
        if (this.player.firstBreadKB != null) {
            this.player.firstBreadKB.offset = 0.0;
        }
        if (this.player.likelyKB != null) {
            this.player.likelyKB.offset = 0.0;
        }
    }

    public void setPointThree(boolean isPointThree) {
        this.knockbackPointThree = this.knockbackPointThree || isPointThree;
    }

    public void handlePredictionAnalysis(double offset) {
        if (this.player.firstBreadKB != null) {
            this.player.firstBreadKB.offset = Math.min(this.player.firstBreadKB.offset, offset);
        }
        if (this.player.likelyKB != null) {
            this.player.likelyKB.offset = Math.min(this.player.likelyKB.offset, offset);
        }
    }

    @Override
    public void onPredictionComplete(PredictionComplete predictionComplete) {
        double offset = predictionComplete.getOffset();
        if (!predictionComplete.isChecked() || predictionComplete.getData().isTeleport()) {
            this.forceExempt();
            return;
        }
        boolean wasZero = this.knockbackPointThree;
        this.knockbackPointThree = false;
        if (this.player.likelyKB == null && this.player.firstBreadKB == null) {
            return;
        }
        if (this.player.predictedVelocity.isFirstBreadKb()) {
            this.firstBreadOnlyKnockback = null;
            this.firstBreadMap.poll();
        }
        if (wasZero || this.player.predictedVelocity.isKnockback()) {
            if (this.player.firstBreadKB != null) {
                this.player.firstBreadKB.offset = Math.min(this.player.firstBreadKB.offset, offset);
            }
            if (this.player.likelyKB != null) {
                this.player.likelyKB.offset = Math.min(this.player.likelyKB.offset, offset);
            }
        }
        if (this.player.likelyKB != null && this.player.likelyKB.offset > this.offsetToFlag) {
            if (this.player.likelyKB.isSetback) {
                this.player.getSetbackTeleportUtil().executeViolationSetback();
            } else if (this.flag()) {
                if (this.getViolations() > this.setbackVL) {
                    this.player.getSetbackTeleportUtil().executeViolationSetback();
                }
                String formatOffset = "o: " + this.formatOffset(this.player.likelyKB.offset);
                if (this.player.likelyKB.offset == 2.147483647E9) {
                    formatOffset = "ignored knockback";
                }
                this.alert(formatOffset);
            } else {
                this.reward();
            }
        }
    }

    public boolean shouldIgnoreForPrediction(VectorData data) {
        if (data.isKnockback() && data.isFirstBreadKb()) {
            return this.player.firstBreadKB.offset > this.offsetToFlag;
        }
        return false;
    }

    public boolean wouldFlag() {
        return this.player.likelyKB != null && this.player.likelyKB.offset > this.offsetToFlag || this.player.firstBreadKB != null && this.player.firstBreadKB.offset > this.offsetToFlag;
    }

    public VelocityData calculateFirstBreadKnockback(int entityID, int transaction) {
        this.tickKnockback(transaction);
        if (this.firstBreadOnlyKnockback != null && this.firstBreadOnlyKnockback.entityID == entityID) {
            return this.firstBreadOnlyKnockback;
        }
        return null;
    }

    @Override
    public void reload() {
        super.reload();
        this.offsetToFlag = this.getConfig().getDoubleElse("Knockback.threshold", 1.0E-5);
        this.setbackVL = this.getConfig().getDoubleElse("Knockback.setbackvl", 10.0);
        if (this.setbackVL == -1.0) {
            this.setbackVL = Double.MAX_VALUE;
        }
    }

    public boolean isKnockbackPointThree() {
        return this.knockbackPointThree;
    }
}

