/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.velocity;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PostPredictionCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3f;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerExplosion;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;
import ac.grim.grimac.utils.data.VectorData;
import ac.grim.grimac.utils.data.VelocityData;
import java.util.Deque;
import java.util.LinkedList;
import org.bukkit.util.Vector;

@CheckData(name="AntiExplosion", configName="Explosion", setback=10.0)
public class ExplosionHandler
extends Check
implements PostPredictionCheck {
    Deque<VelocityData> firstBreadMap = new LinkedList<VelocityData>();
    VelocityData lastExplosionsKnownTaken = null;
    VelocityData firstBreadAddedExplosion = null;
    boolean explosionPointThree = false;
    double offsetToFlag;
    double setbackVL;

    public ExplosionHandler(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() == PacketType.Play.Server.EXPLOSION) {
            WrapperPlayServerExplosion explosion = new WrapperPlayServerExplosion(event);
            Vector3f velocity = explosion.getPlayerMotion();
            if (!explosion.getRecords().isEmpty()) {
                this.player.sendTransaction();
                this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                    for (Vector3i records : explosion.getRecords()) {
                        this.player.compensatedWorld.updateBlock(records.x, records.y, records.z, 0);
                    }
                });
            }
            if (velocity.x != 0.0f || velocity.y != 0.0f || velocity.z != 0.0f) {
                if (explosion.getRecords().isEmpty()) {
                    this.player.sendTransaction();
                }
                this.addPlayerExplosion(this.player.lastTransactionSent.get(), velocity);
                event.getTasksAfterSend().add(this.player::sendTransaction);
            }
        }
    }

    public Vector getFutureExplosion() {
        if (this.firstBreadMap.size() > 0) {
            return this.firstBreadMap.peek().vector;
        }
        if (this.lastExplosionsKnownTaken != null) {
            return this.lastExplosionsKnownTaken.vector;
        }
        if (this.player.firstBreadExplosion != null && this.player.likelyExplosions == null) {
            return this.player.firstBreadExplosion.vector;
        }
        if (this.player.likelyExplosions != null) {
            return this.player.likelyExplosions.vector;
        }
        return null;
    }

    public boolean shouldIgnoreForPrediction(VectorData data) {
        if (data.isExplosion() && data.isFirstBreadExplosion()) {
            return this.player.firstBreadExplosion.offset > this.offsetToFlag;
        }
        return false;
    }

    public boolean wouldFlag() {
        return this.player.likelyExplosions != null && this.player.likelyExplosions.offset > this.offsetToFlag || this.player.firstBreadExplosion != null && this.player.firstBreadExplosion.offset > this.offsetToFlag;
    }

    public void addPlayerExplosion(int breadOne, Vector3f explosion) {
        this.firstBreadMap.add(new VelocityData(-1, breadOne, this.player.getSetbackTeleportUtil().isSendingSetback, new Vector(explosion.getX(), explosion.getY(), explosion.getZ())));
    }

    public void setPointThree(boolean isPointThree) {
        this.explosionPointThree = this.explosionPointThree || isPointThree;
    }

    public void handlePredictionAnalysis(double offset) {
        if (this.player.firstBreadExplosion != null) {
            this.player.firstBreadExplosion.offset = Math.min(this.player.firstBreadExplosion.offset, offset);
        }
        if (this.player.likelyExplosions != null) {
            this.player.likelyExplosions.offset = Math.min(this.player.likelyExplosions.offset, offset);
        }
    }

    public void forceExempt() {
        if (this.player.firstBreadExplosion != null) {
            this.player.firstBreadExplosion.offset = 0.0;
        }
        if (this.player.likelyExplosions != null) {
            this.player.likelyExplosions.offset = 0.0;
        }
    }

    @Override
    public void onPredictionComplete(PredictionComplete predictionComplete) {
        double offset = predictionComplete.getOffset();
        boolean wasZero = this.explosionPointThree;
        this.explosionPointThree = false;
        if (this.player.likelyExplosions == null && this.player.firstBreadExplosion == null) {
            this.firstBreadAddedExplosion = null;
            return;
        }
        int minTrans = Math.min(this.player.likelyExplosions != null ? this.player.likelyExplosions.transaction : Integer.MAX_VALUE, this.player.firstBreadExplosion != null ? this.player.firstBreadExplosion.transaction : Integer.MAX_VALUE);
        int kbTrans = Math.max(this.player.likelyKB != null ? this.player.likelyKB.transaction : Integer.MIN_VALUE, this.player.firstBreadKB != null ? this.player.firstBreadKB.transaction : Integer.MIN_VALUE);
        if (this.player.predictedVelocity.isFirstBreadExplosion()) {
            this.firstBreadAddedExplosion = null;
            this.firstBreadMap.poll();
        }
        if (wasZero || this.player.predictedVelocity.isExplosion() || minTrans < kbTrans) {
            if (this.player.firstBreadExplosion != null) {
                this.player.firstBreadExplosion.offset = Math.min(this.player.firstBreadExplosion.offset, offset);
            }
            if (this.player.likelyExplosions != null) {
                this.player.likelyExplosions.offset = Math.min(this.player.likelyExplosions.offset, offset);
            }
        }
        if (this.player.likelyExplosions != null) {
            if (this.player.likelyExplosions.offset > this.offsetToFlag) {
                if (this.flag() && this.getViolations() > this.setbackVL) {
                    this.player.getSetbackTeleportUtil().executeViolationSetback();
                }
                String formatOffset = "o: " + this.formatOffset(offset);
                if (this.player.likelyExplosions.offset == 2.147483647E9) {
                    formatOffset = "ignored explosion";
                }
                this.alert(formatOffset);
            } else {
                this.reward();
            }
        }
    }

    public VelocityData getPossibleExplosions(int lastTransaction) {
        this.handleTransactionPacket(lastTransaction);
        if (this.lastExplosionsKnownTaken == null) {
            return null;
        }
        VelocityData returnLastExplosion = this.lastExplosionsKnownTaken;
        this.lastExplosionsKnownTaken = null;
        return returnLastExplosion;
    }

    private void handleTransactionPacket(int transactionID) {
        VelocityData data = this.firstBreadMap.peek();
        while (data != null) {
            if (data.transaction == transactionID) {
                if (this.lastExplosionsKnownTaken != null) {
                    this.firstBreadAddedExplosion = new VelocityData(-1, data.transaction, data.isSetback, this.lastExplosionsKnownTaken.vector.clone().add(data.vector));
                    break;
                }
                this.firstBreadAddedExplosion = new VelocityData(-1, data.transaction, data.isSetback, data.vector);
                break;
            }
            if (data.transaction >= transactionID) break;
            if (this.lastExplosionsKnownTaken != null) {
                this.lastExplosionsKnownTaken.vector.add(data.vector);
            } else {
                this.lastExplosionsKnownTaken = new VelocityData(-1, data.transaction, data.isSetback, data.vector);
            }
            this.firstBreadAddedExplosion = null;
            this.firstBreadMap.poll();
            data = this.firstBreadMap.peek();
        }
    }

    public VelocityData getFirstBreadAddedExplosion(int lastTransaction) {
        this.handleTransactionPacket(lastTransaction);
        return this.firstBreadAddedExplosion;
    }

    @Override
    public void reload() {
        super.reload();
        this.offsetToFlag = this.getConfig().getDoubleElse("Explosion.threshold", 1.0E-5);
        this.setbackVL = this.getConfig().getDoubleElse("Explosion.setbackvl", 10.0);
        if (this.setbackVL == -1.0) {
            this.setbackVL = Double.MAX_VALUE;
        }
    }

    public boolean isExplosionPointThree() {
        return this.explosionPointThree;
    }
}

