/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.scaffolding;

import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.BlockPlaceCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.utils.anticheat.update.BlockPlace;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import java.util.Collections;

@CheckData(name="PositionPlace")
public class PositionPlace
extends BlockPlaceCheck {
    public PositionPlace(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onBlockPlace(BlockPlace place) {
        if (place.getMaterial() == StateTypes.SCAFFOLDING) {
            return;
        }
        SimpleCollisionBox combined = this.getCombinedBox(place);
        double minEyeHeight = Collections.min(this.player.getPossibleEyeHeights());
        double maxEyeHeight = Collections.max(this.player.getPossibleEyeHeights());
        double movementThreshold = !this.player.packetStateData.didLastMovementIncludePosition || this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? this.player.getMovementThreshold() : 0.0;
        SimpleCollisionBox eyePositions = new SimpleCollisionBox(this.player.x, this.player.y + minEyeHeight, this.player.z, this.player.x, this.player.y + maxEyeHeight, this.player.z);
        eyePositions.expand(movementThreshold);
        if (eyePositions.isIntersected(combined)) {
            return;
        }
        boolean flag = false;
        switch (place.getDirection()) {
            case NORTH: {
                flag = eyePositions.minZ > combined.minZ;
                break;
            }
            case SOUTH: {
                flag = eyePositions.maxZ < combined.maxZ;
                break;
            }
            case EAST: {
                flag = eyePositions.maxX < combined.maxX;
                break;
            }
            case WEST: {
                flag = eyePositions.minX > combined.minX;
                break;
            }
            case UP: {
                flag = eyePositions.maxY < combined.maxY;
                break;
            }
            case DOWN: {
                boolean bl = flag = eyePositions.minY > combined.minY;
            }
        }
        if (flag && this.flagAndAlert() && this.shouldModifyPackets()) {
            place.resync();
        }
    }
}

